/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.proxy.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.platform.proxy.api.IProxyFactory;
import org.pentaho.platform.proxy.api.IProxyRegistration;
import org.pentaho.platform.proxy.impl.ProxyException;
import org.pentaho.platform.proxy.impl.ProxyRequestRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyRequestTracker {
    private Map<Class<?>, ProxyTargetServiceTracker> classesToTrack = new HashMap();
    private BundleContext bundleContext;
    private IProxyFactory proxyFactory;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ProxyRequestTracker(BundleContext bundleContext, IProxyFactory proxyFactory) {
        this.bundleContext = bundleContext;
        this.proxyFactory = proxyFactory;
    }

    public void registrationRemoved(ProxyRequestRegistration registration) {
        if (registration == null) {
            return;
        }
        ProxyTargetServiceTracker tracker = this.classesToTrack.remove(registration.getClassForProxying());
        tracker.close();
    }

    public void registrationAdded(ProxyRequestRegistration registration) {
        Class<?> classForProxying = registration.getClassForProxying();
        ProxyTargetServiceTracker serviceTracker = new ProxyTargetServiceTracker(classForProxying);
        serviceTracker.open();
        this.classesToTrack.put(classForProxying, serviceTracker);
    }

    Map<Class<?>, ProxyTargetServiceTracker> getClassesToTrack() {
        return Collections.unmodifiableMap(this.classesToTrack);
    }

    private static Map<String, Object> extractPropertiesFromReference(ServiceReference<?> reference) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String s : reference.getPropertyKeys()) {
            properties.put(s, reference.getProperty(s));
        }
        return properties;
    }

    class ProxyTargetServiceTracker<S, T>
    extends ServiceTracker<S, T> {
        private Class<S> clazz;
        private final HashMap<ServiceReference, IProxyRegistration> registrations;

        public ProxyTargetServiceTracker(Class<S> clazz) {
            super(ProxyRequestTracker.this.bundleContext, clazz, null);
            this.registrations = new HashMap();
            this.clazz = clazz;
        }

        public T addingService(ServiceReference<S> serviceReference) {
            IProxyRegistration proxyRegistration = null;
            Object service = ProxyRequestTracker.this.bundleContext.getService(serviceReference);
            try {
                proxyRegistration = ProxyRequestTracker.this.proxyFactory.createAndRegisterProxy(service, Collections.singletonList(this.clazz), ProxyRequestTracker.extractPropertiesFromReference(serviceReference));
                this.registrations.put(serviceReference, proxyRegistration);
            }
            catch (ProxyException e) {
                ProxyRequestTracker.this.logger.error("Error Proxying Object: " + service.getClass(), (Throwable)e);
            }
            return (T)service;
        }

        public void modifiedService(ServiceReference<S> serviceReference, T t) {
            this.removedService(serviceReference, t);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<S> serviceReference, T t) {
            this.registrations.remove(serviceReference).getPentahoObjectRegistration().remove();
        }
    }
}

