/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.proxy.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.osgi.api.ProxyUnwrapper;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoObjectRegistration;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;
import org.pentaho.platform.proxy.api.IProxyCreator;
import org.pentaho.platform.proxy.api.IProxyFactory;
import org.pentaho.platform.proxy.api.IProxyRegistration;
import org.pentaho.platform.proxy.impl.ProxyException;
import org.pentaho.platform.proxy.impl.ProxyRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFactoryImpl
implements IProxyFactory {
    private List<IProxyCreator<?>> creators = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProxyUnwrapper proxyUnwrapper;

    public ProxyFactoryImpl(ProxyUnwrapper proxyUnwrapper) {
        this.proxyUnwrapper = proxyUnwrapper;
    }

    @Override
    public <T, K> K createProxy(T target) throws ProxyException {
        Class<?> parentClass;
        Class<?> targetClass = target.getClass();
        if (this.proxyUnwrapper != null) {
            target = this.proxyUnwrapper.unwrap(target);
            targetClass = target.getClass();
        }
        this.logger.debug("Proxy Request initiated for class: " + targetClass);
        this.logger.debug("Attempting to find Proxy Creator by class hierarchy: " + targetClass);
        K proxyWrapper = null;
        block0: for (parentClass = targetClass; parentClass != null; parentClass = parentClass.getSuperclass()) {
            for (IProxyCreator<?> creator : this.creators) {
                if (!creator.supports(parentClass)) continue;
                this.logger.debug("Proxy creator found for : " + targetClass + " : " + creator.getClass());
                proxyWrapper = (K)creator.create(target);
                if (proxyWrapper == null) continue;
                break block0;
            }
        }
        if (proxyWrapper == null) {
            this.logger.debug("Attempting to find Proxy Creator by declared Interfaces: " + targetClass);
            block2: for (parentClass = targetClass; parentClass != null; parentClass = parentClass.getSuperclass()) {
                Class<?>[] interfaces;
                for (Class<?> anInterface : interfaces = parentClass.getInterfaces()) {
                    for (IProxyCreator<?> creator : this.creators) {
                        if (!creator.supports(anInterface)) continue;
                        this.logger.debug("Proxy creator found for : " + targetClass + " : " + creator.getClass());
                        proxyWrapper = (K)creator.create(target);
                        if (proxyWrapper == null) continue;
                        break block2;
                    }
                }
            }
        }
        if (proxyWrapper == null) {
            throw new ProxyException("No Proxy Creator found for supplied target class: " + targetClass.getName());
        }
        return proxyWrapper;
    }

    @Override
    public <T, K> IProxyRegistration createAndRegisterProxy(T target, List<Class<?>> publishedClasses, Map<String, Object> properties) throws ProxyException {
        Class<?> proxyWrapperClass;
        publishedClasses = new ArrayList(publishedClasses);
        K proxyWrapper = this.createProxy(target);
        for (Class<?> parent = proxyWrapperClass = proxyWrapper.getClass(); parent != null; parent = parent.getSuperclass()) {
            publishedClasses.add(parent);
        }
        for (Class<?> aClass : proxyWrapperClass.getInterfaces()) {
            publishedClasses.add(aClass);
        }
        SingletonPentahoObjectReference reference = ((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(proxyWrapperClass).object(proxyWrapper)).attributes(properties)).build();
        IPentahoObjectRegistration iPentahoObjectRegistration = PentahoSystem.registerReference((IPentahoObjectReference)reference, (Class[])publishedClasses.toArray(new Class[publishedClasses.size()]));
        return new ProxyRegistration(iPentahoObjectRegistration, proxyWrapper);
    }

    public void setCreators(List<IProxyCreator<?>> creators) {
        this.creators = creators;
    }
}

