/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.hbase.table.row;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.BasicResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.hadoop.gateway.shell.hbase.table.row.Column;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;

public class QueryRows {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String rowsId;
        private String tableName;
        private List<Column> columns = new ArrayList<Column>();
        private Long startTime;
        private Long endTime;
        private Long numVersions;

        public Request(Hadoop session, String rowsId, String tableName) {
            super(session);
            this.rowsId = rowsId;
            this.tableName = tableName;
        }

        public Request column(String family, String qualifier) {
            Column column = new Column(family, qualifier);
            this.columns.add(column);
            return this;
        }

        public Request column(String family) {
            return this.column(family, null);
        }

        public Request startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Request endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Request times(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            return this;
        }

        public Request numVersions(Long numVersions) {
            this.numVersions = numVersions;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    String rowsIdToQuery = Request.this.rowsId;
                    if (rowsIdToQuery == null || rowsIdToQuery.isEmpty()) {
                        rowsIdToQuery = "*";
                    }
                    StringBuilder columnsURIPart = new StringBuilder("/");
                    int index = 0;
                    for (Column column : Request.this.columns) {
                        if (index++ > 0) {
                            columnsURIPart.append(",");
                        }
                        columnsURIPart.append(column.toURIPart());
                    }
                    columnsURIPart.append("/");
                    StringBuilder timesURIPart = new StringBuilder();
                    if (Request.this.startTime != null && Request.this.endTime != null) {
                        timesURIPart.append(Request.this.startTime).append(",").append(Request.this.endTime);
                    } else if (Request.this.startTime != null) {
                        timesURIPart.append(Request.this.startTime).append(",").append(Long.MAX_VALUE);
                    } else if (Request.this.endTime != null) {
                        timesURIPart.append(Request.this.endTime);
                    }
                    StringBuilder versionURIPart = new StringBuilder();
                    if (Request.this.numVersions != null) {
                        versionURIPart.append("?v=").append(Request.this.numVersions);
                    }
                    URIBuilder uri = Request.this.uri(new String[]{"/hbase", "/", Request.this.tableName, "/", rowsIdToQuery, columnsURIPart.toString(), timesURIPart.toString(), versionURIPart.toString()});
                    HttpGet get = new HttpGet(uri.build());
                    get.setHeader("Accept", "application/json");
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)get));
                }
            };
        }
    }
}

