/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclAceDto;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclAceAdapter;

public class RepositoryFileAclAdapter
extends XmlAdapter<RepositoryFileAclDto, RepositoryFileAcl> {
    public RepositoryFileAclDto marshal(RepositoryFileAcl v) {
        RepositoryFileAclDto aclDto = new RepositoryFileAclDto();
        Serializable id = v.getId();
        aclDto.setId(id != null ? id.toString() : null);
        RepositoryFileSid owner = v.getOwner();
        if (owner != null) {
            aclDto.setOwner(owner.getName());
            aclDto.setOwnerType(owner.getType() != null ? owner.getType().ordinal() : -1);
        }
        aclDto.setAces(this.toAcesDto(v.getAces()), v.isEntriesInheriting());
        return aclDto;
    }

    protected List<RepositoryFileAclAceDto> toAcesDto(List<RepositoryFileAce> aces) {
        ArrayList<RepositoryFileAclAceDto> aceDtos = new ArrayList<RepositoryFileAclAceDto>();
        for (RepositoryFileAce ace : aces) {
            aceDtos.add(RepositoryFileAclAceAdapter.toAceDto(ace));
        }
        return aceDtos;
    }

    public RepositoryFileAcl unmarshal(RepositoryFileAclDto v) {
        RepositoryFileAcl.Builder builder = null;
        builder = v.getOwnerType() != -1 ? (v.getId() != null ? new RepositoryFileAcl.Builder((Serializable)((Object)v.getId()), v.getOwner(), RepositoryFileSid.Type.values()[v.getOwnerType()]) : new RepositoryFileAcl.Builder((Serializable)((Object)v.getTenantPath()), v.getOwner(), RepositoryFileSid.Type.values()[v.getOwnerType()])) : new RepositoryFileAcl.Builder((Serializable)((Object)v.getId()), null);
        builder.entriesInheriting(v.isEntriesInheriting());
        for (RepositoryFileAclAceDto fileAclAceDto : v.getAces()) {
            builder.ace(RepositoryFileAclAceAdapter.toAce(fileAclAceDto));
        }
        return builder.build();
    }
}

