/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.transform;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.sample.SampleRepositoryFileData;
import org.pentaho.platform.repository2.unified.jcr.ITransformer;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;

public class SampleRepositoryFileDataTransformer
implements ITransformer<SampleRepositoryFileData> {
    private static final String PROPERTY_NAME_SAMPLE_STRING = "sampleString";
    private static final String PROPERTY_NAME_SAMPLE_BOOLEAN = "sampleBoolean";
    private static final String PROPERTY_NAME_SAMPLE_INTEGER = "sampleInteger";

    @Override
    public boolean canRead(String contentType, Class<? extends IRepositoryFileData> clazz) {
        return "sample".equals(contentType) && clazz.isAssignableFrom(SampleRepositoryFileData.class);
    }

    @Override
    public boolean canWrite(Class<? extends IRepositoryFileData> clazz) {
        return SampleRepositoryFileData.class.equals(clazz);
    }

    @Override
    public String getContentType() {
        return "sample";
    }

    @Override
    public void createContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, SampleRepositoryFileData data, Node fileNode) throws RepositoryException {
        Node unstructuredNode = fileNode.addNode(pentahoJcrConstants.getJCR_CONTENT(), pentahoJcrConstants.getNT_UNSTRUCTURED());
        unstructuredNode.setProperty(PROPERTY_NAME_SAMPLE_STRING, data.getSampleString());
        unstructuredNode.setProperty(PROPERTY_NAME_SAMPLE_BOOLEAN, data.getSampleBoolean());
        unstructuredNode.setProperty(PROPERTY_NAME_SAMPLE_INTEGER, (long)data.getSampleInteger());
    }

    @Override
    public SampleRepositoryFileData fromContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, Node fileNode) throws RepositoryException {
        Node unstructuredNode = fileNode.getNode(pentahoJcrConstants.getJCR_CONTENT());
        String sampleString = unstructuredNode.getProperty(PROPERTY_NAME_SAMPLE_STRING).getString();
        boolean sampleBoolean = unstructuredNode.getProperty(PROPERTY_NAME_SAMPLE_BOOLEAN).getBoolean();
        int sampleInteger = (int)unstructuredNode.getProperty(PROPERTY_NAME_SAMPLE_INTEGER).getLong();
        return new SampleRepositoryFileData(sampleString, sampleBoolean, sampleInteger);
    }

    @Override
    public void updateContentNode(Session session, PentahoJcrConstants pentahoJcrConstants, SampleRepositoryFileData data, Node fileNode) throws RepositoryException {
        Node unstructuredNode = fileNode.getNode(pentahoJcrConstants.getJCR_CONTENT());
        unstructuredNode.setProperty(PROPERTY_NAME_SAMPLE_STRING, data.getSampleString());
        unstructuredNode.setProperty(PROPERTY_NAME_SAMPLE_BOOLEAN, data.getSampleBoolean());
        unstructuredNode.setProperty(PROPERTY_NAME_SAMPLE_INTEGER, (long)data.getSampleInteger());
    }
}

