/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.exception;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.repository2.unified.exception.RepositoryFileDaoException;

public class RepositoryFileDaoReferentialIntegrityException
extends RepositoryFileDaoException {
    private static final long serialVersionUID = 451157145460281861L;
    private RepositoryFile target;
    private Set<RepositoryFile> referrers;

    public RepositoryFileDaoReferentialIntegrityException(RepositoryFile target, Set<RepositoryFile> referrers) {
        this.target = target;
        this.referrers = new HashSet<RepositoryFile>(referrers);
    }

    public RepositoryFileDaoReferentialIntegrityException(String message, Throwable cause, RepositoryFile target, Set<RepositoryFile> referrers) {
        super(message, cause);
        this.target = target;
        this.referrers = new HashSet<RepositoryFile>(referrers);
    }

    public RepositoryFileDaoReferentialIntegrityException(String message, RepositoryFile target, Set<RepositoryFile> referrers) {
        super(message);
        this.target = target;
        this.referrers = new HashSet<RepositoryFile>(referrers);
    }

    public RepositoryFileDaoReferentialIntegrityException(Throwable cause, RepositoryFile target, Set<RepositoryFile> referrers) {
        super(cause);
        this.target = target;
        this.referrers = new HashSet<RepositoryFile>(referrers);
    }

    public RepositoryFile getTarget() {
        return this.target;
    }

    public Set<RepositoryFile> getReferrers() {
        return Collections.unmodifiableSet(this.referrers);
    }

    @Override
    public String toString() {
        return "RepositoryFileDaoReferentialIntegrityException [target=" + this.target + ", referrers=" + this.referrers + "]";
    }
}

