/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.toc;

import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.extensions.toc.DataPassingDataFactory;
import org.pentaho.reporting.engine.classic.extensions.toc.IndexDataGeneratorFunction;
import org.pentaho.reporting.engine.classic.extensions.toc.IndexElement;
import org.pentaho.reporting.engine.classic.extensions.toc.TocDataGeneratorFunction;
import org.pentaho.reporting.engine.classic.extensions.toc.TocElement;

public class TocReportPreProcessor
extends AbstractReportPreProcessor {
    private HashSet<String> generatedExpressionNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        try {
            this.generatedExpressionNames = new HashSet();
            DataSchema schema = flowController.getDataSchema();
            this.processSection(schema, (AbstractReportDefinition)definition, (Section)definition);
            MasterReport masterReport = definition;
            return masterReport;
        }
        finally {
            this.generatedExpressionNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        try {
            this.generatedExpressionNames = new HashSet();
            DataSchema schema = flowController.getDataSchema();
            this.processSection(schema, (AbstractReportDefinition)definition, (Section)definition);
            SubReport subReport = definition;
            return subReport;
        }
        finally {
            this.generatedExpressionNames = null;
        }
    }

    private void processSection(DataSchema schema, AbstractReportDefinition definition, Section section) throws ReportProcessingException {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = section.getElement(i);
            if (!(element instanceof SubReport)) {
                if (!(element instanceof Section)) continue;
                this.processSection(schema, definition, (Section)element);
                continue;
            }
            if ("toc".equals(element.getMetaData().getName())) {
                this.activateTableOfContents(schema, definition, (ReportElement)element);
                continue;
            }
            if (!"index".equals(element.getMetaData().getName())) continue;
            this.activateIndex(schema, definition, (ReportElement)element);
        }
        if (section instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)section;
            SubReport[] reports = rlb.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport report = reports[i];
                if ("toc".equals(report.getMetaData().getName())) {
                    this.activateTableOfContents(schema, definition, (ReportElement)report);
                    continue;
                }
                if (!"index".equals(report.getMetaData().getName())) continue;
                this.activateIndex(schema, definition, (ReportElement)report);
            }
        }
    }

    private void activateTableOfContents(DataSchema schema, AbstractReportDefinition definition, ReportElement element) throws ReportProcessingException {
        TocDataGeneratorFunction o = new TocDataGeneratorFunction();
        String name = AutoGeneratorUtility.generateUniqueExpressionName((DataSchema)schema, (String)"::report:toc-generator:{0}", (String[])this.generatedExpressionNames.toArray(new String[this.generatedExpressionNames.size()]));
        o.setName(name);
        this.generatedExpressionNames.add(name);
        TocElement toc = (TocElement)element;
        toc.addInputParameter(name, name);
        toc.setQuery(name);
        Object groupFields = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields");
        Object collectDetails = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "collect-details");
        Object indexSeparator = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "index-separator");
        Object titleFormula = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "title-formula");
        Object titleField = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "title-field");
        if (Boolean.TRUE.equals(collectDetails)) {
            o.setCollectDetails(true);
        } else if (Boolean.FALSE.equals(collectDetails)) {
            o.setCollectDetails(false);
        }
        if (groupFields instanceof String[]) {
            String[] fields = (String[])groupFields;
            o.setGroup(fields);
        }
        if (indexSeparator != null) {
            o.setIndexSeparator(String.valueOf(indexSeparator));
        }
        if (titleFormula != null) {
            o.setTitleFormula(String.valueOf(titleFormula));
        }
        if (titleField != null) {
            o.setTitleField(String.valueOf(titleField));
        }
        DataFactory dataFactory = toc.getDataFactory();
        CompoundDataFactory normalizedDataFactory = CompoundDataFactory.normalize((DataFactory)dataFactory);
        normalizedDataFactory.add(0, (DataFactory)new DataPassingDataFactory(name));
        toc.setDataFactory((DataFactory)normalizedDataFactory);
        definition.addExpression((Expression)o);
    }

    private void activateIndex(DataSchema schema, AbstractReportDefinition definition, ReportElement element) throws ReportProcessingException {
        IndexDataGeneratorFunction o = new IndexDataGeneratorFunction();
        String name = AutoGeneratorUtility.generateUniqueExpressionName((DataSchema)schema, (String)"::report:index-generator:{0}", (String[])this.generatedExpressionNames.toArray(new String[this.generatedExpressionNames.size()]));
        o.setName(name);
        this.generatedExpressionNames.add(name);
        IndexElement toc = (IndexElement)element;
        toc.addInputParameter(name, name);
        toc.setQuery(name);
        Object indexSeparator = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "index-separator");
        Object titleFormula = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-formula");
        Object titleField = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-field");
        Object condensedStyle = toc.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "condensed-style");
        if (indexSeparator != null) {
            o.setIndexSeparator(String.valueOf(indexSeparator));
        }
        if (titleFormula != null) {
            o.setDataFormula(String.valueOf(titleFormula));
        }
        if (titleField != null) {
            o.setDataField(String.valueOf(titleField));
        }
        if (Boolean.TRUE.equals(condensedStyle)) {
            o.setCondensedStyle(true);
        } else if (Boolean.FALSE.equals(condensedStyle)) {
            o.setCondensedStyle(false);
        }
        DataFactory dataFactory = toc.getDataFactory();
        CompoundDataFactory normalizedDataFactory = CompoundDataFactory.normalize((DataFactory)dataFactory);
        normalizedDataFactory.add(0, (DataFactory)new DataPassingDataFactory(name));
        toc.setDataFactory((DataFactory)normalizedDataFactory);
        definition.addExpression((Expression)o);
    }
}

