/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutput;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutputData;
import org.pentaho.bigdata.api.jaas.JaasConfigService;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.w3c.dom.Node;

@Step(id="KafkaProducerOutput", image="KafkaProducerOutput.svg", i18nPackageName="org.pentaho.big.data.kettle.plugins.kafka", name="KafkaProducer.TypeLongDesc", description="KafkaProducer.TypeTooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Streaming", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/Kafka_Producer")
@InjectionSupported(localizationPrefix="KafkaProducerOutputMeta.Injection.", groups={"CONFIGURATION_PROPERTIES"})
public class KafkaProducerOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String CLUSTER_NAME = "clusterName";
    public static final String CONNECTION_TYPE = "connectionType";
    public static final String DIRECT_BOOTSTRAP_SERVERS = "directBootstrapServers";
    public static final String CLIENT_ID = "clientId";
    public static final String TOPIC = "topic";
    public static final String KEY_FIELD = "keyField";
    public static final String MESSAGE_FIELD = "messageField";
    public static final String ADVANCED_CONFIG = "advancedConfig";
    public static final String CONFIG_OPTION = "option";
    public static final String OPTION_PROPERTY = "property";
    public static final String OPTION_VALUE = "value";
    private static Class<?> PKG = KafkaProducerOutput.class;
    @Injection(name="CONNECTION_TYPE")
    private ConnectionType connectionType = ConnectionType.DIRECT;
    @Injection(name="DIRECT_BOOTSTRAP_SERVERS")
    private String directBootstrapServers;
    @Injection(name="CLUSTER_NAME")
    private String clusterName;
    @Injection(name="CLIENT_ID")
    private String clientId;
    @Injection(name="TOPIC")
    private String topic;
    @Injection(name="KEY_FIELD")
    private String keyField;
    @Injection(name="MESSAGE_FIELD")
    private String messageField;
    @Injection(name="NAMES", group="CONFIGURATION_PROPERTIES")
    protected transient List<String> injectedConfigNames;
    @Injection(name="VALUES", group="CONFIGURATION_PROPERTIES")
    protected transient List<String> injectedConfigValues;
    private Map<String, String> config = new LinkedHashMap<String, String>();
    private NamedClusterService namedClusterService;
    private NamedClusterServiceLocator namedClusterServiceLocator;
    private MetastoreLocator metastoreLocator;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode) {
        this.setConnectionType(ConnectionType.valueOf(XMLHandler.getTagValue((Node)stepnode, (String)CONNECTION_TYPE)));
        this.setDirectBootstrapServers(XMLHandler.getTagValue((Node)stepnode, (String)DIRECT_BOOTSTRAP_SERVERS));
        this.setClusterName(XMLHandler.getTagValue((Node)stepnode, (String)CLUSTER_NAME));
        this.setClientId(XMLHandler.getTagValue((Node)stepnode, (String)CLIENT_ID));
        this.setTopic(XMLHandler.getTagValue((Node)stepnode, (String)TOPIC));
        this.setKeyField(XMLHandler.getTagValue((Node)stepnode, (String)KEY_FIELD));
        this.setMessageField(XMLHandler.getTagValue((Node)stepnode, (String)MESSAGE_FIELD));
        this.config = new LinkedHashMap<String, String>();
        Optional.ofNullable(XMLHandler.getSubNode((Node)stepnode, (String)ADVANCED_CONFIG)).map(node -> node.getChildNodes()).ifPresent(nodes -> IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).filter(node -> node.getNodeType() == 1).forEach(node -> {
            if (CONFIG_OPTION.equals(node.getNodeName())) {
                this.config.put(node.getAttributes().getNamedItem(OPTION_PROPERTY).getTextContent(), node.getAttributes().getNamedItem(OPTION_VALUE).getTextContent());
            } else {
                this.config.put(node.getNodeName(), node.getTextContent());
            }
        }));
    }

    public void setDefault() {
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId stepId, List<DatabaseMeta> databases) throws KettleException {
        this.setConnectionType(ConnectionType.valueOf(rep.getStepAttributeString(stepId, CONNECTION_TYPE)));
        this.setDirectBootstrapServers(rep.getStepAttributeString(stepId, DIRECT_BOOTSTRAP_SERVERS));
        this.setClusterName(rep.getStepAttributeString(stepId, CLUSTER_NAME));
        this.setClientId(rep.getStepAttributeString(stepId, CLIENT_ID));
        this.setTopic(rep.getStepAttributeString(stepId, TOPIC));
        this.setKeyField(rep.getStepAttributeString(stepId, KEY_FIELD));
        this.setMessageField(rep.getStepAttributeString(stepId, MESSAGE_FIELD));
        this.config = new LinkedHashMap<String, String>();
        int i = 0;
        while ((long)i < rep.getStepAttributeInteger(stepId, "advancedConfig_COUNT")) {
            this.config.put(rep.getStepAttributeString(stepId, i, "advancedConfig_NAME"), rep.getStepAttributeString(stepId, i, "advancedConfig_VALUE"));
            ++i;
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId transformationId, ObjectId stepId) throws KettleException {
        rep.saveStepAttribute(transformationId, stepId, CONNECTION_TYPE, this.connectionType.name());
        rep.saveStepAttribute(transformationId, stepId, DIRECT_BOOTSTRAP_SERVERS, this.directBootstrapServers);
        rep.saveStepAttribute(transformationId, stepId, CLUSTER_NAME, this.clusterName);
        rep.saveStepAttribute(transformationId, stepId, CLIENT_ID, this.clientId);
        rep.saveStepAttribute(transformationId, stepId, TOPIC, this.topic);
        rep.saveStepAttribute(transformationId, stepId, KEY_FIELD, this.keyField);
        rep.saveStepAttribute(transformationId, stepId, MESSAGE_FIELD, this.messageField);
        rep.saveStepAttribute(transformationId, stepId, "advancedConfig_COUNT", (long)this.getConfig().size());
        int i = 0;
        for (String propName : this.getConfig().keySet()) {
            rep.saveStepAttribute(transformationId, stepId, i, "advancedConfig_NAME", propName);
            rep.saveStepAttribute(transformationId, stepId, i++, "advancedConfig_VALUE", this.getConfig().get(propName));
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new KafkaProducerOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new KafkaProducerOutputData();
    }

    public String getDialogClassName() {
        return "org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutputDialog";
    }

    public String getBootstrapServers() {
        Optional<NamedCluster> namedClusterByName;
        if (ConnectionType.DIRECT.equals((Object)this.getConnectionType())) {
            return this.getDirectBootstrapServers();
        }
        IMetaStore metastore = this.metastoreLocator.getMetastore();
        if (metastore == null) {
            metastore = this.getParentStepMeta().getParentTransMeta().getEmbeddedMetaStore();
        }
        if (!(namedClusterByName = Optional.ofNullable(this.namedClusterService.getNamedClusterByName(this.parentStepMeta.getParentTransMeta().environmentSubstitute(this.clusterName), metastore))).isPresent()) {
            namedClusterByName = Optional.ofNullable(this.namedClusterService.getNamedClusterByName(this.parentStepMeta.getParentTransMeta().environmentSubstitute(this.clusterName), (IMetaStore)this.getParentStepMeta().getParentTransMeta().getEmbeddedMetaStore()));
        }
        return namedClusterByName.map(NamedCluster::getKafkaBootstrapServers).orElse("");
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public String getXML() throws KettleException {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)CONNECTION_TYPE, (String)this.connectionType.name()));
        retval.append("    ").append(XMLHandler.addTagValue((String)DIRECT_BOOTSTRAP_SERVERS, (String)this.directBootstrapServers));
        retval.append("    ").append(XMLHandler.addTagValue((String)CLUSTER_NAME, (String)this.clusterName));
        retval.append("    ").append(XMLHandler.addTagValue((String)TOPIC, (String)this.topic));
        retval.append("    ").append(XMLHandler.addTagValue((String)CLIENT_ID, (String)this.clientId));
        retval.append("    ").append(XMLHandler.addTagValue((String)KEY_FIELD, (String)this.keyField));
        retval.append("    ").append(XMLHandler.addTagValue((String)MESSAGE_FIELD, (String)this.messageField));
        retval.append("    ").append(XMLHandler.openTag((String)ADVANCED_CONFIG)).append(Const.CR);
        this.getConfig().forEach((key, value) -> retval.append("        ").append(XMLHandler.addTagValue((String)CONFIG_OPTION, (String)"", (boolean)true, (String[])new String[]{OPTION_PROPERTY, key, OPTION_VALUE, value})));
        retval.append("    ").append(XMLHandler.closeTag((String)ADVANCED_CONFIG)).append(Const.CR);
        this.parentStepMeta.getParentTransMeta().getNamedClusterEmbedManager().registerUrl("hc://" + this.clusterName);
        return retval.toString();
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public MetastoreLocator getMetastoreLocator() {
        return this.metastoreLocator;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setDirectBootstrapServers(String directBootstrapServers) {
        this.directBootstrapServers = directBootstrapServers;
    }

    public String getDirectBootstrapServers() {
        return this.directBootstrapServers;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getConfig() {
        this.applyInjectedProperties();
        return this.config;
    }

    public void setNamedClusterService(NamedClusterService namedClusterService) {
        this.namedClusterService = namedClusterService;
    }

    public void setMetastoreLocator(MetastoreLocator metastoreLocator) {
        this.metastoreLocator = metastoreLocator;
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public void setNamedClusterServiceLocator(NamedClusterServiceLocator namedClusterServiceLocator) {
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public Optional<JaasConfigService> getJaasConfigService() {
        try {
            return Optional.ofNullable(this.namedClusterServiceLocator.getService(this.namedClusterService.getNamedClusterByName(this.getClusterName(), this.getMetastoreLocator().getMetastore()), JaasConfigService.class));
        }
        catch (Exception e) {
            this.getLog().logDebug("problem getting jaas config", new Object[]{e});
            return Optional.empty();
        }
    }

    protected void applyInjectedProperties() {
        if (this.injectedConfigNames != null || this.injectedConfigValues != null) {
            Preconditions.checkState((this.injectedConfigNames != null ? 1 : 0) != 0, (Object)"Options names were not injected");
            Preconditions.checkState((this.injectedConfigValues != null ? 1 : 0) != 0, (Object)"Options values were not injected");
            Preconditions.checkState((this.injectedConfigNames.size() == this.injectedConfigValues.size() ? 1 : 0) != 0, (Object)"Injected different number of options names and value");
            this.setConfig(IntStream.range(0, this.injectedConfigNames.size()).boxed().collect(Collectors.toMap(this.injectedConfigNames::get, this.injectedConfigValues::get, (v1, v2) -> v1, LinkedHashMap::new)));
            this.injectedConfigNames = null;
            this.injectedConfigValues = null;
        }
    }

    public static enum ConnectionType {
        DIRECT,
        CLUSTER;

    }
}

