/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.mapreduce.db.DBConfiguration;

public final class MainframeFTPClientUtils {
    private static final Log LOG = LogFactory.getLog((String)MainframeFTPClientUtils.class.getName());
    private static FTPClient mockFTPClient = null;

    private MainframeFTPClientUtils() {
    }

    public static List<String> listSequentialDatasets(String pdsName, Configuration conf) throws IOException {
        ArrayList<String> datasets = new ArrayList<String>();
        FTPClient ftp = null;
        try {
            ftp = MainframeFTPClientUtils.getFTPConnection(conf);
            if (ftp != null) {
                FTPFile[] ftpFiles;
                ftp.changeWorkingDirectory("'" + pdsName + "'");
                for (FTPFile f : ftpFiles = ftp.listFiles()) {
                    if (f.getType() != 0) continue;
                    datasets.add(f.getName());
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("Could not list datasets from " + pdsName + ":" + ioe.toString());
        }
        finally {
            if (ftp != null) {
                MainframeFTPClientUtils.closeFTPConnection(ftp);
            }
        }
        return datasets;
    }

    public static FTPClient getFTPConnection(Configuration conf) throws IOException {
        FTPClient ftp = null;
        try {
            String connectString;
            String password;
            String username = conf.get("mapreduce.jdbc.username");
            if (username == null) {
                username = "anonymous";
                password = "";
            } else {
                password = DBConfiguration.getPassword((JobConf)conf);
            }
            String server = connectString = conf.get("mapreduce.jdbc.url");
            int port = 0;
            String[] parts = connectString.split(":");
            if (parts.length == 2) {
                server = parts[0];
                try {
                    port = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Invalid port number: " + e.toString()));
                }
            }
            ftp = null != mockFTPClient ? mockFTPClient : new FTPClient();
            FTPClientConfig config = new FTPClientConfig("MVS");
            ftp.configure(config);
            if (conf.getBoolean("sqoop.verbose", false)) {
                ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), true));
            }
            try {
                if (port > 0) {
                    ftp.connect(server, port);
                } else {
                    ftp.connect(server);
                }
            }
            catch (IOException ioexp) {
                throw new IOException("Could not connect to server " + server, ioexp);
            }
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new IOException("FTP server " + server + " refused connection:" + ftp.getReplyString());
            }
            LOG.info((Object)("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort())));
            if (!ftp.login(username, password)) {
                ftp.logout();
                throw new IOException("Could not login to server " + server + ":" + ftp.getReplyString());
            }
            ftp.setFileType(0);
            ftp.enterLocalPassiveMode();
        }
        catch (IOException ioe) {
            if (ftp != null && ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ftp = null;
            throw ioe;
        }
        return ftp;
    }

    public static boolean closeFTPConnection(FTPClient ftp) {
        boolean success = true;
        try {
            ftp.noop();
            ftp.logout();
        }
        catch (FTPConnectionClosedException e) {
            success = false;
            LOG.warn((Object)("Server closed connection: " + e.toString()));
        }
        catch (IOException e) {
            success = false;
            LOG.warn((Object)("Server closed connection: " + e.toString()));
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    success = false;
                }
            }
        }
        return success;
    }

    public static void setMockFTPClient(FTPClient FTPClient2) {
        mockFTPClient = FTPClient2;
    }
}

