/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.io.CodecMap;
import com.cloudera.sqoop.io.SplittableBufferedWriter;
import com.cloudera.sqoop.io.SplittingOutputStream;
import com.cloudera.sqoop.manager.ImportJobContext;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.Shell;

public final class DirectImportUtils {
    public static final Log LOG = LogFactory.getLog((String)DirectImportUtils.class.getName());

    private DirectImportUtils() {
    }

    public static void setFilePermissions(File file, String modstr) throws IOException {
        try {
            Shell.execCommand((String[])new String[]{"chmod", modstr, file.toString()});
        }
        catch (IOException ioe) {
            LOG.error((Object)("Could not chmod " + modstr + " " + file.toString()));
            throw new IOException("Could not ensure password file security.", ioe);
        }
    }

    public static SplittableBufferedWriter createHdfsSink(Configuration conf, SqoopOptions options, ImportJobContext context) throws IOException {
        Path destDir = context.getDestination();
        FileSystem fs = destDir.getFileSystem(conf);
        LOG.debug((Object)("Writing to filesystem: " + fs.getUri()));
        LOG.debug((Object)("Creating destination directory " + destDir));
        fs.mkdirs(destDir);
        return new SplittableBufferedWriter(new SplittingOutputStream(conf, destDir, "part-m-", options.getDirectSplitSize(), DirectImportUtils.getCodec(conf, options)));
    }

    private static CompressionCodec getCodec(Configuration conf, SqoopOptions options) throws IOException {
        if (options.shouldUseCompression()) {
            if (options.getCompressionCodec() == null) {
                return new GzipCodec();
            }
            return CodecMap.getCodec(options.getCompressionCodec(), conf);
        }
        return null;
    }

    public static boolean isLocalhost(String someHost) {
        if (null == someHost) {
            return false;
        }
        try {
            InetAddress localHostAddr = InetAddress.getLocalHost();
            InetAddress someAddr = InetAddress.getByName(someHost);
            return localHostAddr.equals(someAddr);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }
}

