/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AsyncSqlOutputFormat;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.AsyncSqlRecordWriter;

public class UpdateOutputFormat<K extends SqoopRecord, V>
extends AsyncSqlOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(UpdateOutputFormat.class);

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        DBConfiguration dbConf = new DBConfiguration(conf);
        if (null == conf.get("mapreduce.jdbc.url")) {
            throw new IOException("Database connection URL is not set.");
        }
        if (null == dbConf.getOutputTableName()) {
            throw new IOException("Table name is not set for export.");
        }
        if (null == dbConf.getOutputFieldNames()) {
            throw new IOException("Output field names are null.");
        }
        if (null == conf.get("sqoop.mapreduce.export.update.col")) {
            throw new IOException("Update key column is not set for export.");
        }
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new UpdateRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class UpdateRecordWriter
    extends AsyncSqlRecordWriter<K, V> {
        protected String tableName;
        protected String[] columnNames;
        protected String[] updateCols;

        public UpdateRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
            Configuration conf = this.getConf();
            DBConfiguration dbConf = new DBConfiguration(conf);
            this.tableName = dbConf.getOutputTableName();
            this.columnNames = dbConf.getOutputFieldNames();
            String updateKeyColumns = conf.get("sqoop.mapreduce.export.update.col");
            LinkedHashSet<String> updateKeys = new LinkedHashSet<String>();
            StringTokenizer stok = new StringTokenizer(updateKeyColumns, ",");
            while (stok.hasMoreTokens()) {
                String nextUpdateKey = stok.nextToken().trim();
                if (nextUpdateKey.length() > 0) {
                    updateKeys.add(nextUpdateKey);
                    continue;
                }
                throw new RuntimeException("Invalid update key column value specified: '" + updateKeyColumns + "'");
            }
            this.updateCols = updateKeys.toArray(new String[updateKeys.size()]);
        }

        @Override
        protected boolean isBatchExec() {
            return true;
        }

        protected final String getTableName() {
            return this.tableName;
        }

        protected final String[] getColumnNames() {
            if (null == this.columnNames) {
                return null;
            }
            return Arrays.copyOf(this.columnNames, this.columnNames.length);
        }

        protected final String[] getUpdateColumns() {
            return this.updateCols;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PreparedStatement getPreparedStatement(List<SqoopRecord> userRecords) throws SQLException {
            PreparedStatement stmt = null;
            Connection conn = this.getConnection();
            Connection connection = conn;
            synchronized (connection) {
                stmt = conn.prepareStatement(this.getUpdateStatement());
            }
            for (SqoopRecord record : userRecords) {
                record.write(stmt, 0);
                stmt.addBatch();
            }
            return stmt;
        }

        protected String getUpdateStatement() {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE " + this.tableName + " SET ");
            boolean first = true;
            for (String col : this.columnNames) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(col);
                sb.append("=?");
                first = false;
            }
            sb.append(" WHERE ");
            first = true;
            for (int i = 0; i < this.updateCols.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(this.updateCols[i]).append("=?");
            }
            return sb.toString();
        }
    }
}

