/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.security;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.HttpClientUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.security.SecurityACL;
import org.pentaho.pms.util.Const;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SecurityService
extends ChangedFlag
implements Cloneable {
    public static final int SERVICE_TYPE_ALL = 0;
    public static final int SERVICE_TYPE_USERS = 1;
    public static final int SERVICE_TYPE_ROLES = 2;
    public static final String[] serviceTypeCodes = new String[]{"all", "users", "roles"};
    public static final String[] serviceTypeDescriptions = new String[]{Messages.getString("SecurityService.USER_ALL"), Messages.getString("SecurityService.USER_USERS"), Messages.getString("SecurityService.USER_ROLES")};
    public static final String ACTION = "action";
    public static final String USERNAME = "userid";
    public static final String PASSWORD = "password";
    private String serviceURL;
    private String serviceName;
    private String detailNameParameter;
    private int detailServiceType;
    private String username;
    private String password;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private String filename;
    LogChannelInterface log = new LogChannel((Object)this.toString());

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        if (this.hasService()) {
            return this.serviceName;
        }
        return "SecurityService";
    }

    public String getDetailNameParameter() {
        return this.detailNameParameter;
    }

    public void setDetailNameParameter(String detailServiceName) {
        this.detailNameParameter = detailServiceName;
    }

    public int getDetailServiceType() {
        return this.detailServiceType;
    }

    public void setDetailServiceType(int detailServiceType) {
        this.detailServiceType = detailServiceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getServiceTypeCode() {
        return serviceTypeCodes[this.detailServiceType];
    }

    public String getServiceTypeDesc() {
        return serviceTypeDescriptions[this.detailServiceType];
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public static final int getServiceType(String description) {
        int i;
        for (i = 0; i < serviceTypeDescriptions.length; ++i) {
            if (!serviceTypeDescriptions[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        for (i = 0; i < serviceTypeCodes.length; ++i) {
            if (!serviceTypeCodes[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        return 0;
    }

    public Node getContent(String url) throws Exception {
        if (this.hasService()) {
            return this.getContentFromServer(url);
        }
        if (this.hasFile()) {
            return this.getContentFromFile();
        }
        throw new Exception(Messages.getString("SecurityService.ERROR_0001_UNABLE_TO_GET_SECURITY_REFERENCE"));
    }

    public Node getContentFromServer(String urlToUse) throws PentahoMetadataException {
        URL tempURL;
        String result = null;
        int status = -1;
        try {
            tempURL = new URL(urlToUse);
        }
        catch (MalformedURLException e) {
            String msg = Messages.getString("SecurityService.ERROR_0002_INVALID_URL", urlToUse, e.getMessage());
            this.log.logError(msg, (Throwable)e);
            throw new PentahoMetadataException(msg, e);
        }
        HttpClientManager.HttpClientBuilderFacade httpClientBuilder = HttpClientManager.getInstance().createBuilder();
        this.log.logDebug(Messages.getString("SecurityService.INFO_CONNECTING_TO_URL", urlToUse));
        HttpClientContext context = null;
        if (StringUtils.isNotBlank((String)this.proxyHostname) && StringUtils.isNotBlank((String)this.proxyPort)) {
            int port = Integer.parseInt(this.proxyPort);
            httpClientBuilder.setProxy(this.proxyHostname, port);
        }
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            AuthScope authScope = new AuthScope(tempURL.getHost(), tempURL.getPort());
            httpClientBuilder.setCredentials(this.username, this.password, authScope);
            context = HttpClientUtil.createPreemptiveBasicAuthentication((String)tempURL.getHost(), (int)tempURL.getPort(), (String)this.username, (String)this.password);
        }
        CloseableHttpClient client = httpClientBuilder.build();
        HttpGet getMethod = new HttpGet(urlToUse);
        try {
            HttpResponse response = context != null ? client.execute((HttpUriRequest)getMethod, context) : client.execute((HttpUriRequest)getMethod);
            status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                this.log.logDetailed(Messages.getString("SecurityService.INFO_START_READING_WEBSERVER_REPLY"));
                result = HttpClientUtil.responseToString((HttpResponse)response);
                this.log.logBasic(Messages.getString("SecurityService.INFO_FINISHED_READING_RESPONSE", Integer.toString(result.length())));
            } else if (status == 401) {
                String msg = Messages.getString("SecurityService.ERROR_0009_UNAUTHORIZED_ACCESS_TO_URL", urlToUse);
                this.log.logError(msg);
                throw new PentahoMetadataException(msg);
            }
        }
        catch (IOException e) {
            String msg = Messages.getString("SecurityService.ERROR_0003_CANT_SAVE_IO_ERROR", e.getMessage());
            this.log.logError(msg);
            this.log.logError(Const.getStackTracker(e));
            throw new PentahoMetadataException(msg, e);
        }
        if (result != null) {
            Document doc;
            try {
                doc = XMLHandler.loadXMLString((String)result);
            }
            catch (KettleXMLException e) {
                String msg = Messages.getString("SecurityService.ERROR_0008_ERROR_PARSING_XML", e.getMessage());
                this.log.logError(msg);
                this.log.logError(Const.getStackTracker(e));
                throw new PentahoMetadataException(msg, e);
            }
            if (this.serviceURL.endsWith("ServiceAction")) {
                Node response;
                Node body;
                Node envelope = XMLHandler.getSubNode((Node)doc, (String)"SOAP-ENV:Envelope");
                if (envelope != null && (body = XMLHandler.getSubNode((Node)envelope, (String)"SOAP-ENV:Body")) != null && (response = XMLHandler.getSubNode((Node)body, (String)"ExecuteActivityResponse")) != null) {
                    Node content = XMLHandler.getSubNode((Node)response, (String)"content");
                    return content;
                }
            } else {
                return doc.getFirstChild();
            }
        }
        return null;
    }

    public Node getContentFromFile() throws Exception {
        try {
            Document doc = XMLHandler.loadXMLFile((String)this.filename);
            return XMLHandler.getSubNode((Node)doc, (String)"content");
        }
        catch (KettleXMLException e) {
            throw new Exception(Messages.getString("SecurityService.ERROR_0007_UNABLE_TO_GET_SECURITY_CONTENT", this.filename), e);
        }
    }

    public String getContentAsXMLString() throws Exception {
        Node content = this.getContent(this.getURL(null));
        if (content == null) {
            return null;
        }
        return content.getChildNodes().toString();
    }

    public String getURL() {
        return this.getURL(this.getServiceTypeCode());
    }

    public String getURL(String serviceTypeCode) {
        StringBuffer url = new StringBuffer();
        url.append(this.serviceURL);
        if (this.serviceURL != null && this.serviceURL.endsWith("ServiceAction")) {
            url.append("?").append(ACTION).append("=").append(this.serviceName);
            url.append("&").append(this.detailNameParameter).append("=").append(this.getServiceTypeCode());
        } else if (serviceTypeCode != null) {
            if (!this.serviceURL.endsWith("/")) {
                url.append("/");
            }
            url.append(serviceTypeCode);
        }
        return url.toString();
    }

    public boolean hasService() {
        return !Const.isEmpty(this.serviceURL) && !Const.isEmpty(this.serviceName) && !Const.isEmpty(this.detailNameParameter);
    }

    public boolean hasFile() {
        return !Const.isEmpty(this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<String> getUsers() {
        ArrayList<String> users = new ArrayList<String>();
        if (this.hasService() || this.hasFile()) {
            try {
                if (this.getDetailServiceType() == 1 || this.getDetailServiceType() == 0) {
                    String url = this.getURL(serviceTypeCodes[1]);
                    Node contentNode = this.getContent(url);
                    String usersNode = "users";
                    if (this.serviceURL.endsWith("ServiceAction")) {
                        contentNode = XMLHandler.getSubNode((Node)contentNode, (String)usersNode);
                        usersNode = "user";
                    }
                    int nrUsers = XMLHandler.countNodes((Node)contentNode, (String)usersNode);
                    for (int i = 0; i < nrUsers; ++i) {
                        Node userNode = XMLHandler.getSubNodeByNr((Node)contentNode, (String)usersNode, (int)i);
                        String username = XMLHandler.getNodeValue((Node)userNode);
                        if (username == null) continue;
                        users.add(username);
                    }
                }
            }
            catch (PentahoMetadataException ex) {
                this.log.logError(Messages.getString("SecurityReference.ERROR_0001_CANT_CREATE_REFERENCE_FROM_XML"), (Throwable)ex);
            }
            catch (Exception e) {
                this.log.logError(Messages.getString("SecurityReference.ERROR_0001_CANT_CREATE_REFERENCE_FROM_XML"), (Throwable)e);
            }
        }
        return users;
    }

    public List<String> getRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.hasService() || this.hasFile()) {
            try {
                if (this.getDetailServiceType() == 2 || this.getDetailServiceType() == 0) {
                    String url = this.getURL(serviceTypeCodes[2]);
                    Node contentNode = this.getContent(url);
                    String rolesNode = "roles";
                    if (this.serviceURL.endsWith("ServiceAction")) {
                        contentNode = XMLHandler.getSubNode((Node)contentNode, (String)rolesNode);
                        rolesNode = "role";
                    }
                    int nrRoles = XMLHandler.countNodes((Node)contentNode, (String)rolesNode);
                    for (int i = 0; i < nrRoles; ++i) {
                        Node roleNode = XMLHandler.getSubNodeByNr((Node)contentNode, (String)rolesNode, (int)i);
                        String rolename = XMLHandler.getNodeValue((Node)roleNode);
                        if (rolename == null) continue;
                        roles.add(rolename);
                    }
                }
            }
            catch (PentahoMetadataException ex) {
                this.log.logError(Messages.getString("SecurityReference.ERROR_0001_CANT_CREATE_REFERENCE_FROM_XML"), (Throwable)ex);
            }
            catch (Exception e) {
                this.log.logError(Messages.getString("SecurityReference.ERROR_0001_CANT_CREATE_REFERENCE_FROM_XML"), (Throwable)e);
            }
        }
        return roles;
    }

    public List<SecurityACL> getAcls() {
        ArrayList<SecurityACL> acls = new ArrayList<SecurityACL>();
        if (this.hasService() || this.hasFile()) {
            try {
                Node contentNode = this.getContent(this.getURL(null));
                Node aclsNode = XMLHandler.getSubNode((Node)contentNode, (String)"acls");
                int nrAcls = XMLHandler.countNodes((Node)aclsNode, (String)"acl");
                for (int i = 0; i < nrAcls; ++i) {
                    Node aclNode = XMLHandler.getSubNodeByNr((Node)aclsNode, (String)"acl", (int)i);
                    SecurityACL acl = new SecurityACL(aclNode);
                    acls.add(acl);
                }
                Collections.sort(acls);
            }
            catch (PentahoMetadataException ex) {
                this.log.logError(Messages.getString("SecurityReference.ERROR_0001_CANT_CREATE_REFERENCE_FROM_XML"), new Object[]{ex.getLocalizedMessage()});
            }
            catch (Exception e) {
                this.log.logError(Messages.getString("SecurityReference.ERROR_0001_CANT_CREATE_REFERENCE_FROM_XML"), new Object[]{e.getLocalizedMessage()});
            }
        }
        return acls;
    }
}

