/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.SQLJoin;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.pms.util.Const;

public abstract class BaseHiveDialect
extends DefaultSQLDialect {
    protected final Pattern INVALID_JOIN_OPERATORS = Pattern.compile("[!]|[>]|[<]|is null|is not null");
    protected final Pattern TABLE_QUALIFIER_PATTERN = Pattern.compile("([^\\(\\s.])+(\\s)*[.]");
    protected Integer driverMajorVersion;
    protected Integer driverMinorVersion;
    private static final String HIVE_DIALECT_TYPE = "HIVE";
    private static final String DRIVER_CLASS_NAME = "org.apache.hadoop.hive.jdbc.HiveDriver";

    public BaseHiveDialect() {
        this(BaseHiveDialect.getHiveDialectType());
    }

    public BaseHiveDialect(String hiveDialectType) {
        super(hiveDialectType);
    }

    public static boolean canLoad() {
        try {
            return DatabaseMeta.getDatabaseInterface((String)HIVE_DIALECT_TYPE) != null;
        }
        catch (KettleDatabaseException ex) {
            return false;
        }
    }

    @Override
    protected List<SQLQueryModel.SQLWhereFormula> generateOuterJoin(SQLQueryModel query, StringBuilder sql) {
        throw new RuntimeException(Messages.getErrorString("HiveDialect.ERROR_0001_OUTER_JOIN_NOT_SUPPORTED", new Object[0]));
    }

    @Override
    protected void generateHaving(SQLQueryModel query, StringBuilder sql) {
        if (!query.getHavings().isEmpty()) {
            throw new RuntimeException(Messages.getErrorString("HiveDialect.ERROR_0004_HAVING_NOT_SUPPORTED", new Object[0]));
        }
    }

    @Override
    protected void generateSelect(SQLQueryModel query, StringBuilder sql) {
        sql.append("SELECT ");
        this.generateSelectPredicate(query, sql);
        sql.append(Const.CR);
        boolean first = true;
        for (SQLQueryModel.SQLSelection selection : query.getSelections()) {
            if (first) {
                first = false;
                sql.append("          ");
            } else {
                sql.append("         ,");
            }
            sql.append(selection.getFormula());
            if (this.isDriverVersion(0, 6) && selection.getAlias() != null) {
                sql.append(" AS ");
                sql.append(selection.getAlias());
            }
            sql.append(Const.CR);
        }
    }

    @Override
    protected void generateFrom(SQLQueryModel query, StringBuilder sql) {
        sql.append("FROM ").append(Const.CR);
        if (query.getJoins().isEmpty()) {
            sql.append(this.getFromClauseWithTables(query));
        } else {
            sql.append(this.getFromAndWhereClauseWithInnerJoins(query));
        }
    }

    @Override
    protected void generateJoins(SQLQueryModel query, StringBuilder sql) {
    }

    protected String getFromClauseWithTables(SQLQueryModel query) {
        StringBuilder sql = new StringBuilder();
        Iterator<SQLQueryModel.SQLTable> iter = query.getTables().iterator();
        SQLQueryModel.SQLTable table = iter.next();
        sql.append("          ");
        this.appendTableAndAlias(sql, table);
        while (iter.hasNext()) {
            sql.append(Const.CR).append("     JOIN ");
            this.appendTableAndAlias(sql, iter.next());
        }
        sql.append(Const.CR);
        return sql.toString();
    }

    protected String getFromAndWhereClauseWithInnerJoins(SQLQueryModel query) {
        StringBuilder sql = new StringBuilder();
        ArrayList<SQLJoin> joins = new ArrayList<SQLJoin>(query.getJoins());
        HashSet<String> usedTables = new HashSet<String>();
        LinkedList<SQLJoin> joinsForWhereClause = new LinkedList<SQLJoin>();
        Collections.sort(joins, InnerJoinComparator.getInstance());
        SQLJoin join = (SQLJoin)joins.get(0);
        String firstTable = this.getTableAndAlias(join.getLeftTablename(), join.getLeftTableAlias());
        sql.append("          ").append(firstTable);
        sql.append(Const.CR);
        usedTables.add(firstTable);
        this.connectNode(sql, usedTables, joins, joinsForWhereClause);
        if (!joins.isEmpty()) {
            throw new RuntimeException(String.format(Messages.getErrorString("HiveDialect.ERROR_0002_JOIN_PATH_NOT_FOUND", this.getTableAndAlias(join.getLeftTablename(), join.getLeftTableAlias()), this.getTableAndAlias(join.getRightTablename(), join.getRightTableAlias())), new Object[0]));
        }
        this.generateInnerJoinWhereConditions(query, sql, joinsForWhereClause);
        return sql.toString();
    }

    protected void connectNode(StringBuilder sql, Set<String> usedTables, List<SQLJoin> unusedJoins, List<SQLJoin> joinsForWhereClause) {
        Iterator<SQLJoin> iter = unusedJoins.iterator();
        while (iter.hasNext()) {
            SQLJoin join = iter.next();
            String lhs = this.getTableAndAlias(join.getLeftTablename(), join.getLeftTableAlias());
            String rhs = this.getTableAndAlias(join.getRightTablename(), join.getRightTableAlias());
            boolean lhsUsed = usedTables.contains(lhs);
            boolean rhsUsed = usedTables.contains(rhs);
            if (lhsUsed && rhsUsed) {
                throw new RuntimeException(Messages.getErrorString("HiveDialect.ERROR_0003_ADDITIONAL_JOIN_CONDITIONS_FOUND", lhs, rhs));
            }
            if (!lhsUsed && !rhsUsed) continue;
            if (!lhsUsed && rhsUsed) {
                String t = lhs;
                lhs = rhs;
                rhs = t;
            }
            iter.remove();
            usedTables.add(rhs);
            sql.append("          JOIN ");
            sql.append(rhs);
            if (!this.isValidJoinFormula(join.getSqlWhereFormula().getFormula())) {
                joinsForWhereClause.add(join);
            } else {
                sql.append(" ON ( ").append(join.getSqlWhereFormula().getFormula()).append(" )");
            }
            sql.append(Const.CR);
            this.connectNode(sql, usedTables, unusedJoins, joinsForWhereClause);
            break;
        }
    }

    protected boolean isValidJoinFormula(String formula) {
        return !this.INVALID_JOIN_OPERATORS.matcher(formula).find();
    }

    protected void generateInnerJoinWhereConditions(SQLQueryModel query, StringBuilder sql, List<SQLJoin> joins) {
        if (!joins.isEmpty()) {
            boolean first = true;
            sql.append("WHERE").append(Const.CR);
            for (SQLJoin join : joins) {
                if (first) {
                    sql.append("          ( ");
                    first = false;
                } else {
                    sql.append("      AND ( ");
                }
                sql.append(join.getSqlWhereFormula().getFormula());
                sql.append(" )").append(Const.CR);
            }
        }
    }

    protected void appendTableAndAlias(StringBuilder sql, SQLQueryModel.SQLTable table) {
        sql.append(this.getTableAndAlias(table.getTableName(), table.getAlias()));
    }

    protected String getTableAndAlias(String table, String alias) {
        String tableAndAlias = table;
        if (!Const.isEmpty(alias)) {
            tableAndAlias = tableAndAlias + " " + alias;
        }
        return tableAndAlias;
    }

    @Override
    protected void generateGroupBy(SQLQueryModel query, StringBuilder sql) {
        if (query.getGroupBys().size() > 0) {
            sql.append("GROUP BY ").append(Const.CR);
            boolean first = true;
            for (SQLQueryModel.SQLSelection groupby : query.getGroupBys()) {
                if (first) {
                    first = false;
                    sql.append("          ");
                } else {
                    sql.append("         ,");
                }
                sql.append(groupby.getFormula());
                sql.append(Const.CR);
            }
        }
    }

    @Override
    protected void generateOrderBy(SQLQueryModel query, StringBuilder sql) {
        if (query.getOrderBys().size() > 0) {
            sql.append("ORDER BY ").append(Const.CR);
            boolean first = true;
            for (SQLQueryModel.SQLOrderBy orderby : query.getOrderBys()) {
                if (first) {
                    first = false;
                    sql.append("          ");
                } else {
                    sql.append("         ,");
                }
                if (this.isDriverVersion(0, 7)) {
                    if (orderby.getSelection().getAlias() != null) {
                        sql.append(orderby.getSelection().getAlias());
                    } else {
                        sql.append(orderby.getSelection().getFormula());
                    }
                } else {
                    String formula = this.stripTableAliasesFromFormula(orderby.getSelection().getFormula());
                    sql.append(formula);
                }
                if (orderby.getOrder() != null) {
                    sql.append(" ");
                    switch (orderby.getOrder()) {
                        case ASCENDING: {
                            sql.append("ASC");
                            break;
                        }
                        case DESCENDING: {
                            sql.append("DESC");
                            break;
                        }
                        default: {
                            throw new RuntimeException("unsupported order type: " + (Object)((Object)orderby.getOrder()));
                        }
                    }
                }
                sql.append(Const.CR);
            }
        }
    }

    protected String stripTableAliasesFromFormula(String formula) {
        return this.TABLE_QUALIFIER_PATTERN.matcher(formula).replaceAll(new String());
    }

    @Override
    protected boolean containsWhereCondition(SQLQueryModel query, StringBuilder sql, List<SQLQueryModel.SQLWhereFormula> usedSQLWhereFormula) {
        for (SQLJoin join : query.getJoins()) {
            if (this.isValidJoinFormula(join.getSqlWhereFormula().getFormula())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String generateStringConcat(String ... vals) {
        StringBuilder sb = new StringBuilder("CONCAT(");
        for (int i = 0; i < vals.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(vals[i]);
        }
        return sb.append(")").toString();
    }

    @Override
    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateDistinct(query, sql);
    }

    @Override
    protected void generatePostOrderBy(SQLQueryModel query, StringBuilder sql) {
        this.generateLimit(query, sql);
    }

    @Override
    protected void generateLimit(SQLQueryModel query, StringBuilder sql) {
        if (query.getLimit() >= 0) {
            sql.append(Const.CR).append("LIMIT ").append(query.getLimit()).append(Const.CR);
        }
    }

    protected synchronized void initDriverInfo() {
        Integer majorVersion = 0;
        Integer minorVersion = 0;
        try {
            Class<?> driverClass = Class.forName(this.getDriverClassName());
            if (driverClass != null) {
                Driver driver = (Driver)driverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                majorVersion = driver.getMajorVersion();
                minorVersion = driver.getMinorVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.driverMajorVersion = majorVersion;
        this.driverMinorVersion = minorVersion;
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    protected static String getHiveDialectType() {
        return HIVE_DIALECT_TYPE;
    }

    protected boolean isDriverVersion(int majorVersion, int minorVersion) {
        if (this.driverMajorVersion == null) {
            this.initDriverInfo();
        }
        if (majorVersion < this.driverMajorVersion) {
            return true;
        }
        return majorVersion == this.driverMajorVersion && minorVersion <= this.driverMinorVersion;
    }

    protected static class InnerJoinComparator
    implements Comparator<SQLJoin> {
        private static InnerJoinComparator INSTANCE = new InnerJoinComparator();

        private InnerJoinComparator() {
        }

        public static InnerJoinComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(SQLJoin left, SQLJoin right) {
            if (Const.isEmpty(left.getJoinOrderKey()) && Const.isEmpty(right.getJoinOrderKey())) {
                return 0;
            }
            if (!Const.isEmpty(left.getJoinOrderKey()) && Const.isEmpty(right.getJoinOrderKey())) {
                return -1;
            }
            if (Const.isEmpty(left.getJoinOrderKey()) && !Const.isEmpty(right.getJoinOrderKey())) {
                return 1;
            }
            return left.getJoinOrderKey().compareTo(right.getJoinOrderKey());
        }
    }
}

