/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.example;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.example.AdvancedMQLQuery;
import org.pentaho.pms.example.AliasAwarePMSFormula;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.MappedQuery;
import org.pentaho.pms.mql.OrderBy;
import org.pentaho.pms.mql.Path;
import org.pentaho.pms.mql.SQLAndTables;
import org.pentaho.pms.mql.SQLGenerator;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.mql.WhereCondition;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLDialectFactory;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.RelationshipMeta;

public class AdvancedSQLGenerator
extends SQLGenerator {
    public static final String DEFAULT_ALIAS = "__DEFAULT__";

    public MappedQuery getQuery(BusinessModel model, List<Selection> selections, List<WhereCondition> constraints, List<OrderBy> orderbys, DatabaseMeta databaseMeta, boolean disableDistinct, int limit, String locale) throws PentahoMetadataException {
        SQLAndAliasedTables sqlAndTables;
        int i;
        int i2;
        HashMap<String, String> columnsMap = new HashMap<String, String>();
        if (model == null || selections.size() == 0) {
            return null;
        }
        ArrayList<AdvancedMQLQuery.AliasedSelection> defaultList = null;
        ArrayList lists = new ArrayList();
        ArrayList<String> aliasNames = new ArrayList<String>();
        HashMap listlookup = new HashMap();
        ArrayList<Selection> selectionsAndOrderBys = new ArrayList<Selection>();
        selectionsAndOrderBys.addAll(selections);
        for (OrderBy orderBy : orderbys) {
            selectionsAndOrderBys.add(orderBy.getSelection());
        }
        for (Selection selection : selectionsAndOrderBys) {
            ArrayList<AdvancedMQLQuery.AliasedSelection> list;
            AdvancedMQLQuery.AliasedSelection sel = (AdvancedMQLQuery.AliasedSelection)selection;
            if (sel.hasFormula()) {
                sel.initPMSFormula(model, databaseMeta, selections);
            }
            if (sel.alias == null) {
                sel.alias = DEFAULT_ALIAS;
            }
            if ((list = (ArrayList<AdvancedMQLQuery.AliasedSelection>)listlookup.get(sel.alias)) == null) {
                list = new ArrayList<AdvancedMQLQuery.AliasedSelection>();
                if (sel.alias.equals(DEFAULT_ALIAS)) {
                    defaultList = list;
                    lists.add(0, list);
                    aliasNames.add(0, DEFAULT_ALIAS);
                } else {
                    lists.add(list);
                    aliasNames.add(sel.alias);
                }
                listlookup.put(sel.alias, list);
            }
            if (list.contains(sel)) continue;
            list.add(sel);
        }
        if (!listlookup.containsKey(DEFAULT_ALIAS)) {
            throw new PentahoMetadataException("No non-aliased columns selected");
        }
        ArrayList<AliasedRelationshipMeta> allRelationships = new ArrayList<AliasedRelationshipMeta>();
        List<BusinessTable> defaultTables = this.getTablesInvolved(model, defaultList, constraints, orderbys, databaseMeta, locale);
        Path defaultPath = this.getShortestPathBetween(model, defaultTables);
        List<BusinessTable> tbls = defaultPath.getUsedTables();
        ArrayList<AliasedPathBusinessTable> allTables = new ArrayList<AliasedPathBusinessTable>();
        for (BusinessTable tbl : tbls) {
            allTables.add(new AliasedPathBusinessTable(DEFAULT_ALIAS, tbl));
        }
        if (tbls.size() == 0) {
            allTables.add(new AliasedPathBusinessTable(DEFAULT_ALIAS, defaultTables.get(0)));
        }
        if (defaultPath == null) {
            throw new PentahoMetadataException(Messages.getErrorString("BusinessModel.ERROR_0001_FAILED_TO_FIND_PATH"));
        }
        for (i2 = 0; i2 < defaultPath.size(); ++i2) {
            allRelationships.add(new AliasedRelationshipMeta(DEFAULT_ALIAS, DEFAULT_ALIAS, defaultPath.getRelationship(i2)));
        }
        for (i2 = 1; i2 < lists.size(); ++i2) {
            List aliasedColumns = (List)lists.get(i2);
            ArrayList<Selection> aliasedAndDefaultColumns = new ArrayList<Selection>();
            aliasedAndDefaultColumns.addAll(aliasedColumns);
            aliasedAndDefaultColumns.addAll(defaultList);
            List<BusinessTable> aliasedTables = this.getTablesInvolved(model, aliasedColumns, null, null, databaseMeta, locale);
            List<BusinessTable> aliasedAndDefaultTables = this.getTablesInvolved(model, aliasedAndDefaultColumns, null, null, databaseMeta, locale);
            Path aliasedAndDefaultPath = this.getShortestPathBetween(model, aliasedAndDefaultTables);
            for (BusinessTable aliasedTable : aliasedTables) {
                this.traversePath((String)aliasNames.get(i2), aliasedTable, aliasedAndDefaultPath, aliasedTables, defaultTables, allTables, allRelationships);
            }
        }
        SQLQueryModel sqlquery = new SQLQueryModel();
        boolean group = this.hasFactsInIt(selections, constraints);
        sqlquery.setDistinct(!disableDistinct && !group);
        sqlquery.setLimit(limit);
        for (i = 0; i < selections.size(); ++i) {
            String formula;
            Selection selection = (AdvancedMQLQuery.AliasedSelection)selections.get(i);
            if (((AdvancedMQLQuery.AliasedSelection)selection).hasFormula()) {
                try {
                    formula = ((AdvancedMQLQuery.AliasedSelection)selection).getPMSFormula().generateSQL(locale);
                }
                catch (PentahoMetadataException e) {
                    throw new RuntimeException(e);
                }
            } else {
                sqlAndTables = AdvancedSQLGenerator.getSelectionSQL(model, (AdvancedMQLQuery.AliasedSelection)selection, databaseMeta, locale);
                formula = sqlAndTables.getSql();
            }
            String alias = null;
            if (columnsMap != null) {
                String suggestedName = selection.getBusinessColumn() != null && ((AdvancedMQLQuery.AliasedSelection)selection).getAlias().equals(DEFAULT_ALIAS) ? selection.getBusinessColumn().getId() : "CUSTOM_" + i;
                alias = databaseMeta.generateColumnAlias(i, suggestedName);
                columnsMap.put(alias, suggestedName);
                alias = databaseMeta.quoteField(alias);
            } else {
                alias = databaseMeta.quoteField(selection.getBusinessColumn().getId());
            }
            sqlquery.addSelection(formula, alias);
        }
        for (i = 0; i < allTables.size(); ++i) {
            AliasedPathBusinessTable tbl = (AliasedPathBusinessTable)allTables.get(i);
            String alias = tbl.getBusinessTable().getId();
            if (!tbl.getAlias().equals(DEFAULT_ALIAS)) {
                alias = alias + "_" + tbl.getAlias();
            }
            String schemaName = null;
            if (tbl.getBusinessTable().getTargetSchema() != null) {
                schemaName = databaseMeta.quoteField(tbl.getBusinessTable().getTargetSchema());
            }
            String tableName = databaseMeta.quoteField(tbl.getBusinessTable().getTargetTable());
            sqlquery.addTable(databaseMeta.getSchemaTableCombination(schemaName, tableName), databaseMeta.quoteField(alias));
        }
        for (i = 0; i < allRelationships.size(); ++i) {
            JoinType joinType;
            AliasedRelationshipMeta aliasedRelation = (AliasedRelationshipMeta)allRelationships.get(i);
            String joinFormula = this.getJoin(model, aliasedRelation, databaseMeta, locale, selections);
            String joinOrderKey = aliasedRelation.relation.getJoinOrderKey();
            switch (aliasedRelation.relation.getJoinType()) {
                case 1: {
                    joinType = JoinType.LEFT_OUTER_JOIN;
                    break;
                }
                case 2: {
                    joinType = JoinType.RIGHT_OUTER_JOIN;
                    break;
                }
                case 3: {
                    joinType = JoinType.FULL_OUTER_JOIN;
                    break;
                }
                default: {
                    joinType = JoinType.INNER_JOIN;
                }
            }
            String leftTableName = databaseMeta.getQuotedSchemaTableCombination(aliasedRelation.relation.getTableFrom().getTargetSchema(), aliasedRelation.relation.getTableFrom().getTargetTable());
            String rightTableName = databaseMeta.getQuotedSchemaTableCombination(aliasedRelation.relation.getTableTo().getTargetSchema(), aliasedRelation.relation.getTableTo().getTargetTable());
            String leftTableAlias = aliasedRelation.relation.getTableFrom().getId();
            if (!aliasedRelation.leftAlias.equals(DEFAULT_ALIAS)) {
                leftTableAlias = leftTableAlias + "_" + aliasedRelation.leftAlias;
            }
            String rightTableAlias = aliasedRelation.relation.getTableTo().getId();
            if (!aliasedRelation.rightAlias.equals(DEFAULT_ALIAS)) {
                rightTableAlias = rightTableAlias + "_" + aliasedRelation.rightAlias;
            }
            sqlquery.addJoin(leftTableName, leftTableAlias, rightTableName, rightTableAlias, joinType, joinFormula, joinOrderKey);
        }
        if (constraints != null) {
            boolean first = true;
            for (WhereCondition constraint : constraints) {
                if (!constraint.hasAggregate() && !constraint.getPMSFormula().hasAggregateFunction()) {
                    String sql = constraint.getPMSFormula().generateSQL(locale);
                    String[] usedTables = ((AliasAwarePMSFormula)constraint.getPMSFormula()).getTableAliasNames();
                    sqlquery.addWhereFormula(sql, first ? "AND" : constraint.getOperator(), usedTables);
                    first = false;
                    continue;
                }
                sqlquery.addHavingFormula(constraint.getPMSFormula().generateSQL(locale), constraint.getOperator());
            }
        }
        if (group) {
            for (Selection selection : selections) {
                Selection aliasedSelection = selection;
                if (((AdvancedMQLQuery.AliasedSelection)aliasedSelection).hasAggregate()) continue;
                sqlAndTables = AdvancedSQLGenerator.getSelectionSQL(model, (AdvancedMQLQuery.AliasedSelection)aliasedSelection, databaseMeta, locale);
                sqlquery.addGroupBy(sqlAndTables.getSql(), null);
            }
        }
        if (orderbys != null) {
            for (OrderBy orderItem : orderbys) {
                AdvancedMQLQuery.AliasedSelection selection = (AdvancedMQLQuery.AliasedSelection)orderItem.getSelection();
                String sqlSelection = null;
                if (!selection.hasFormula()) {
                    SQLAndAliasedTables sqlAndTables2 = AdvancedSQLGenerator.getSelectionSQL(model, selection, databaseMeta, locale);
                    sqlSelection = sqlAndTables2.getSql();
                } else {
                    sqlSelection = selection.getPMSFormula().generateSQL(locale);
                }
                sqlquery.addOrderBy(sqlSelection, null, !orderItem.isAscending() ? SQLQueryModel.OrderType.DESCENDING : null);
            }
        }
        SQLDialectInterface dialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        String sql = dialect.generateSelectStatement(sqlquery);
        MappedQuery query = new MappedQuery(sql, columnsMap, selections);
        return query;
    }

    public boolean hasFactsInIt(List<Selection> selections, List<WhereCondition> conditions) {
        for (Selection selection : selections) {
            AdvancedMQLQuery.AliasedSelection aliasedSelection = (AdvancedMQLQuery.AliasedSelection)selection;
            if (!aliasedSelection.hasAggregate()) continue;
            return true;
        }
        if (conditions != null) {
            for (WhereCondition condition : conditions) {
                if (!condition.hasAggregate()) continue;
                return true;
            }
        }
        return false;
    }

    protected List<BusinessTable> getTablesInvolved(BusinessModel model, List<Selection> selections, List<WhereCondition> conditions, List<OrderBy> orderBys, DatabaseMeta databaseMeta, String locale) {
        Object sqlAndTables;
        BusinessTable businessTable;
        List<Selection> cols;
        AdvancedMQLQuery.AliasedSelection aliasedSelection;
        TreeSet<BusinessTable> treeSet = new TreeSet<BusinessTable>();
        for (Selection selection : selections) {
            aliasedSelection = (AdvancedMQLQuery.AliasedSelection)selection;
            if (aliasedSelection.hasFormula()) {
                cols = aliasedSelection.getPMSFormula().getBusinessColumns();
                for (Selection selection2 : cols) {
                    businessTable = selection2.getBusinessColumn().getBusinessTable();
                    treeSet.add(businessTable);
                }
                continue;
            }
            sqlAndTables = AdvancedSQLGenerator.getSelectionSQL(model, aliasedSelection, databaseMeta, locale);
            for (AliasedPathBusinessTable aliasedPathBusinessTable : ((SQLAndAliasedTables)sqlAndTables).getAliasedBusinessTables()) {
                treeSet.add(aliasedPathBusinessTable.getBusinessTable());
            }
        }
        if (conditions != null) {
            for (WhereCondition condition : conditions) {
                List<Selection> cols2 = condition.getBusinessColumns();
                for (Selection sel : cols2) {
                    BusinessTable businessTable2 = sel.getBusinessColumn().getBusinessTable();
                    treeSet.add(businessTable2);
                }
            }
        }
        if (orderBys != null) {
            for (OrderBy order : orderBys) {
                aliasedSelection = (AdvancedMQLQuery.AliasedSelection)order.getSelection();
                if (aliasedSelection.hasFormula()) {
                    cols = aliasedSelection.getPMSFormula().getBusinessColumns();
                    for (Selection selection : cols) {
                        businessTable = selection.getBusinessColumn().getBusinessTable();
                        treeSet.add(businessTable);
                    }
                    continue;
                }
                sqlAndTables = AdvancedSQLGenerator.getSelectionSQL(model, (AdvancedMQLQuery.AliasedSelection)order.getSelection(), databaseMeta, locale);
                for (AliasedPathBusinessTable aliasedPathBusinessTable : ((SQLAndAliasedTables)sqlAndTables).getAliasedBusinessTables()) {
                    treeSet.add(aliasedPathBusinessTable.getBusinessTable());
                }
            }
        }
        return new ArrayList<BusinessTable>(treeSet);
    }

    public static SQLAndAliasedTables getSelectionSQL(BusinessModel businessModel, AdvancedMQLQuery.AliasedSelection selection, DatabaseMeta databaseMeta, String locale) {
        if (selection.getBusinessColumn().isExact()) {
            try {
                AliasAwarePMSFormula formula = new AliasAwarePMSFormula(businessModel, selection.getBusinessColumn().getBusinessTable(), databaseMeta, selection.getBusinessColumn().getFormula(), selection.getAlias());
                formula.parseAndValidate();
                return new SQLAndAliasedTables(formula.generateSQL(locale), formula.getUsedAliasedTables());
            }
            catch (PentahoMetadataException e) {
                throw new RuntimeException(Messages.getErrorString("BusinessColumn.ERROR_0001_FAILED_TO_PARSE_FORMULA", selection.getBusinessColumn().getFormula()));
            }
        }
        String tableColumn = "";
        String tblName = selection.getBusinessColumn().getBusinessTable().getId();
        if (!selection.getAlias().equals(DEFAULT_ALIAS)) {
            tblName = tblName + "_" + selection.getAlias();
        }
        tableColumn = tableColumn + databaseMeta.quoteField(tblName);
        tableColumn = tableColumn + ".";
        tableColumn = tableColumn + databaseMeta.quoteField(selection.getBusinessColumn().getFormula());
        if (selection.hasAggregate()) {
            return new SQLAndAliasedTables(AdvancedSQLGenerator.getFunctionExpression(selection, tableColumn, databaseMeta), new AliasedPathBusinessTable(tblName, selection.getBusinessColumn().getBusinessTable()));
        }
        return new SQLAndAliasedTables(tableColumn, new AliasedPathBusinessTable(tblName, selection.getBusinessColumn().getBusinessTable()));
    }

    public String getJoin(BusinessModel businessModel, AliasedRelationshipMeta relation, DatabaseMeta databaseMeta, String locale, List<Selection> selections) throws PentahoMetadataException {
        String join = "";
        if (relation.relation.isComplex()) {
            String formulaString = relation.relation.getComplexJoin();
            AliasAwarePMSFormula formula = new AliasAwarePMSFormula(businessModel, databaseMeta, formulaString, selections, DEFAULT_ALIAS);
            if (!relation.rightAlias.equals(DEFAULT_ALIAS) || !relation.leftAlias.equals(DEFAULT_ALIAS)) {
                HashMap<String, String> businessTableToAliasMap = new HashMap<String, String>();
                if (!relation.rightAlias.equals(DEFAULT_ALIAS)) {
                    businessTableToAliasMap.put(relation.relation.getTableTo().getId(), relation.rightAlias);
                }
                if (!relation.leftAlias.equals(DEFAULT_ALIAS)) {
                    businessTableToAliasMap.put(relation.relation.getTableFrom().getId(), relation.leftAlias);
                }
                formula.setBusinessTableToAliasMap(businessTableToAliasMap);
            }
            formula.parseAndValidate();
            join = formula.generateSQL(locale);
        } else if (relation.relation.getTableFrom() != null && relation.relation.getTableTo() != null && relation.relation.getFieldFrom() != null && relation.relation.getFieldTo() != null) {
            String rightAlias = relation.relation.getTableTo().getId();
            if (!relation.rightAlias.equals(DEFAULT_ALIAS)) {
                rightAlias = rightAlias + "_" + relation.rightAlias;
            }
            String leftAlias = relation.relation.getTableFrom().getId();
            if (!relation.leftAlias.equals(DEFAULT_ALIAS)) {
                leftAlias = leftAlias + "_" + relation.leftAlias;
            }
            join = databaseMeta.quoteField(leftAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField(relation.relation.getFieldFrom().getFormula());
            join = join + " = ";
            join = join + databaseMeta.quoteField(rightAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField(relation.relation.getFieldTo().getFormula());
        }
        return join;
    }

    protected void traversePath(String alias, BusinessTable aliasedTable, Path aliasedPath, List<BusinessTable> aliasedTables, List<BusinessTable> defaultTables, List<AliasedPathBusinessTable> allTables, List<AliasedRelationshipMeta> allRelationships) {
        int i;
        AliasedPathBusinessTable aliasedPathTable = new AliasedPathBusinessTable(alias, aliasedTable);
        if (allTables.contains(aliasedPathTable)) {
            allTables.add(aliasedPathTable);
        }
        allTables.add(aliasedPathTable);
        ArrayList<RelationshipMeta> cachedAliasedPath = new ArrayList<RelationshipMeta>();
        for (i = 0; i < aliasedPath.size(); ++i) {
            cachedAliasedPath.add(aliasedPath.getRelationship(i));
        }
        for (i = 0; i < cachedAliasedPath.size(); ++i) {
            RelationshipMeta rel = (RelationshipMeta)cachedAliasedPath.get(i);
            int index = -1;
            for (int j = 0; j < aliasedPath.size(); ++j) {
                if (aliasedPath.getRelationship(j) != rel) continue;
                index = j;
                break;
            }
            if (index == -1 || !rel.isUsingTable(aliasedTable)) continue;
            boolean joinsToADefaultTable = false;
            for (BusinessTable defaultTable : defaultTables) {
                if (!rel.isUsingTable(defaultTable)) continue;
                boolean inAliasedTables = false;
                for (BusinessTable aliased : aliasedTables) {
                    if (!defaultTable.equals(aliased)) continue;
                    inAliasedTables = true;
                }
                if (inAliasedTables) continue;
                joinsToADefaultTable = true;
                aliasedPath.removeRelationship(index);
                String leftAlias = null;
                String rightAlias = null;
                if (aliasedTable.equals(rel.getTableFrom())) {
                    leftAlias = alias;
                    rightAlias = DEFAULT_ALIAS;
                } else {
                    leftAlias = DEFAULT_ALIAS;
                    rightAlias = alias;
                }
                allRelationships.add(new AliasedRelationshipMeta(leftAlias, rightAlias, rel));
            }
            if (joinsToADefaultTable) continue;
            aliasedPath.removeRelationship(index);
            allRelationships.add(new AliasedRelationshipMeta(alias, alias, rel));
            BusinessTable tbl = rel.getTableFrom() == aliasedTable ? rel.getTableTo() : rel.getTableFrom();
            this.traversePath(alias, tbl, aliasedPath, aliasedTables, defaultTables, allTables, allRelationships);
        }
    }

    class AliasedRelationshipMeta {
        String leftAlias;
        String rightAlias;
        RelationshipMeta relation;

        AliasedRelationshipMeta(String left, String right, RelationshipMeta rel) {
            this.leftAlias = left;
            this.rightAlias = right;
            this.relation = rel;
        }
    }

    public static class SQLAndAliasedTables
    extends SQLAndTables {
        final List<AliasedPathBusinessTable> aliasedTables;

        public SQLAndAliasedTables(String sql, AliasedPathBusinessTable aliasedTable) {
            super(sql, (BusinessTable)null, (Selection)null);
            this.aliasedTables = new ArrayList<AliasedPathBusinessTable>();
            this.aliasedTables.add(aliasedTable);
        }

        public SQLAndAliasedTables(String sql, List<AliasedPathBusinessTable> aliasedTables) {
            super(sql, (BusinessTable)null, (Selection)null);
            this.aliasedTables = aliasedTables;
        }

        public List<AliasedPathBusinessTable> getAliasedBusinessTables() {
            return this.aliasedTables;
        }

        @Override
        public List<BusinessTable> getUsedTables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUsedTables(List<BusinessTable> tables) {
            throw new UnsupportedOperationException();
        }
    }

    static class AliasedPathBusinessTable {
        private String alias;
        private BusinessTable table;

        AliasedPathBusinessTable(String alias, BusinessTable table) {
            this.alias = alias;
            this.table = table;
        }

        public boolean equals(Object obj) {
            AliasedPathBusinessTable apbt = (AliasedPathBusinessTable)obj;
            return apbt.alias.equals(this.alias) && apbt.table.equals(this.table);
        }

        public String getAlias() {
            return this.alias;
        }

        public BusinessTable getBusinessTable() {
            return this.table;
        }
    }
}

