/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.repository;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.SecurityHelper;

public class InMemoryMetadataDomainRepository
implements IMetadataDomainRepository {
    private static final Log logger = LogFactory.getLog(InMemoryMetadataDomainRepository.class);
    Map<String, Domain> domains = new HashMap<String, Domain>();

    @Override
    public synchronized void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        if (domain.getId() == null) {
            throw new DomainIdNullException(Messages.getErrorString("IMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL", new Object[0]));
        }
        if (!overwrite && this.domains != null && this.domains.get(domain.getId()) != null) {
            throw new DomainAlreadyExistsException(Messages.getErrorString("IMetadataDomainRepository.ERROR_0002_DOMAIN_OBJECT_EXISTS", domain.getId()));
        }
        if (this.domains == null) {
            this.domains = new HashMap<String, Domain>();
        }
        this.domains.put(domain.getId(), domain);
    }

    @Override
    public Domain getDomain(String id) {
        if (this.domains == null) {
            return null;
        }
        Domain domain = this.domains.get(id);
        if (domain != null) {
            SecurityHelper helper = new SecurityHelper();
            Domain clone = helper.createSecureDomain(this, domain);
            return clone;
        }
        logger.error((Object)("domain not found : " + id));
        return null;
    }

    @Override
    public Set<String> getDomainIds() {
        if (this.domains == null) {
            this.reloadDomains();
        }
        return this.domains.keySet();
    }

    @Override
    public synchronized void flushDomains() {
        this.domains = null;
    }

    @Override
    public synchronized void reloadDomains() {
        this.domains = new HashMap<String, Domain>();
    }

    @Override
    public synchronized void removeDomain(String domainId) {
        this.domains.remove(domainId);
    }

    @Override
    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        return null;
    }

    @Override
    public boolean hasAccess(int accessType, IConcept aclHolder) {
        return true;
    }

    @Override
    public synchronized void removeModel(String domainId, String modelId) throws DomainIdNullException, DomainStorageException {
        Domain domain = this.domains.get(domainId);
        if (domain == null) {
            throw new DomainIdNullException(Messages.getErrorString("IMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL", new Object[0]));
        }
        Iterator<LogicalModel> iter = domain.getLogicalModels().iterator();
        while (iter.hasNext()) {
            LogicalModel model = iter.next();
            if (!modelId.equals(model.getId())) continue;
            iter.remove();
            break;
        }
        if (domain.getLogicalModels().size() == 0) {
            this.removeDomain(domainId);
        } else {
            try {
                this.storeDomain(domain, true);
            }
            catch (DomainAlreadyExistsException e) {
                logger.error((Object)"this should not happen", (Throwable)e);
            }
        }
    }
}

