/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.concept.types;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LocalizedString
implements Serializable {
    private static final long serialVersionUID = 8214549012790547810L;
    public static final String DEFAULT_LOCALE = "en_US";
    private Map<String, String> localeStringMap;

    public LocalizedString() {
        this.localeStringMap = new HashMap<String, String>();
    }

    public LocalizedString(Map<String, String> localeStringMap) {
        this.localeStringMap = localeStringMap;
    }

    public LocalizedString(String locale, String value) {
        this();
        this.localeStringMap.put(locale, value);
    }

    public String getString(String locale) {
        return this.localeStringMap.get(locale);
    }

    public String getLocalizedString(String locale) {
        String str = this.getString(locale);
        for (String tmpLocale = locale; this.stringIsEmpty(str) && tmpLocale != null && tmpLocale.indexOf(95) > 0; tmpLocale = tmpLocale.substring(0, tmpLocale.lastIndexOf(95))) {
            str = this.getString(tmpLocale);
        }
        if (!this.stringIsEmpty(str)) {
            return str;
        }
        return this.getString(DEFAULT_LOCALE);
    }

    private boolean stringIsEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public void setString(String locale, String string) {
        this.localeStringMap.put(locale, string);
    }

    public Set<String> getLocales() {
        return this.localeStringMap.keySet();
    }

    public Map<String, String> getLocaleStringMap() {
        return this.localeStringMap;
    }

    public boolean equals(Object object) {
        LocalizedString l = (LocalizedString)object;
        return this.localeStringMap.equals(l.getLocaleStringMap());
    }
}

