/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.InlineEtlPhysicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;

public class InlineEtlPhysicalModel
extends Concept
implements IPhysicalModel {
    private static final long serialVersionUID = 998991922256017536L;
    public static final String FILE_LOCATION = "file_location";
    public static final String HEADER_PRESENT = "header_present";
    public static final String ENCLOSURE = "enclosure";
    public static final String DELIMITER = "delimiter";
    private static final String CLASS_ID = "IPhysicalModel";
    private List<InlineEtlPhysicalTable> physicalTables = new ArrayList<InlineEtlPhysicalTable>();

    public void setDomain(Domain domain) {
        this.setParent(domain);
    }

    public Domain getDomain() {
        return (Domain)this.getParent();
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>();
        uid.add(CLASS_ID.concat("-") + this.getId());
        return uid;
    }

    @Override
    public List<IConcept> getChildren() {
        ArrayList<IConcept> children = new ArrayList<IConcept>();
        children.addAll(this.physicalTables);
        return children;
    }

    @Override
    public String getQueryExecName() {
        return "metadataqueryexec-ETL";
    }

    @Override
    public String getDefaultQueryClassname() {
        return "org.pentaho.metadata.query.impl.ietl.InlineEtlQueryExecutor";
    }

    public String getFileLocation() {
        return (String)this.getProperty(FILE_LOCATION);
    }

    public void setFileLocation(String fileLocation) {
        this.setProperty(FILE_LOCATION, fileLocation);
    }

    public void setHeaderPresent(Boolean headerPresent) {
        this.setProperty(HEADER_PRESENT, headerPresent);
    }

    public Boolean getHeaderPresent() {
        return (Boolean)this.getProperty(HEADER_PRESENT);
    }

    public String getEnclosure() {
        return (String)this.getProperty(ENCLOSURE);
    }

    public void setEnclosure(String enclosure) {
        this.setProperty(ENCLOSURE, enclosure);
    }

    public String getDelimiter() {
        return (String)this.getProperty(DELIMITER);
    }

    public void setDelimiter(String delimiter) {
        this.setProperty(DELIMITER, delimiter);
    }

    public List<InlineEtlPhysicalTable> getPhysicalTables() {
        return this.physicalTables;
    }
}

