/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractDigitsFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSDecimal
extends AbstractDigitsFacet {
    public static final String NAME = "decimal";
    public static final short TYPE = 16;
    private static final JType JTYPE = new JClass("java.math.BigDecimal");

    public XSDecimal() {
        super(false);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public short getType() {
        return 16;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isDateTime() {
        return false;
    }

    @Override
    public JType getJType() {
        return JTYPE;
    }

    @Override
    public String newInstanceCode() {
        return "new java.math.BigDecimal(0);";
    }

    @Override
    public String createToJavaObjectCode(String variableName) {
        return variableName;
    }

    @Override
    public String createFromJavaObjectCode(String variableName) {
        return "(java.math.BigDecimal) " + variableName;
    }

    @Override
    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.DecimalValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.DecimalValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(" + fixedValue + ");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("java.math.BigDecimal min = new java.math.BigDecimal(\"{0}\");\ntypeValidator.setMinExclusive(min);", this.getMinExclusive());
        } else if (this.getMinInclusive() != null) {
            jsc.add("java.math.BigDecimal min = new java.math.BigDecimal(\"{0}\");\ntypeValidator.setMinInclusive(min);", this.getMinInclusive());
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("java.math.BigDecimal max = new java.math.BigDecimal(\"{0}\");\ntypeValidator.setMaxExclusive(max);", this.getMaxExclusive());
        } else if (this.getMaxInclusive() != null) {
            jsc.add("java.math.BigDecimal max = new java.math.BigDecimal(\"{0}\");\ntypeValidator.setMaxInclusive(max);", this.getMaxInclusive());
        }
        this.codeDigitsFacet(jsc, "typeValidator");
    }
}

