/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.listener;

import java.util.Map;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.di.osgi.service.notifier.DelayedInstanceNotifierFactory;

public class BundleContextServiceListener
implements ServiceListener {
    private final Map<ServiceReference, Object> referenceToInstanceMap;
    private final DelayedInstanceNotifierFactory delayedInstanceNotifierFactory;

    public BundleContextServiceListener(Map<ServiceReference, Object> referenceToInstanceMap, DelayedInstanceNotifierFactory delayedInstanceNotifierFactory) {
        this.referenceToInstanceMap = referenceToInstanceMap;
        this.delayedInstanceNotifierFactory = delayedInstanceNotifierFactory;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (this.referenceToInstanceMap.containsKey(serviceEvent.getServiceReference())) {
            Object instance = this.referenceToInstanceMap.get(serviceEvent.getServiceReference());
            LifecycleEvent type = LifecycleEvent.MODIFY;
            switch (serviceEvent.getType()) {
                case 2: {
                    type = LifecycleEvent.MODIFY;
                    break;
                }
                case 4: {
                    type = LifecycleEvent.STOP;
                }
            }
            this.delayedInstanceNotifierFactory.create(instance, type).run();
        }
    }
}

