/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi;

import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.OSGIPluginTrackerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintBeanFactory {
    private final String beanId;
    private final Object container;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BlueprintBeanFactory(String beanId, Object container) {
        this.beanId = beanId;
        this.container = container;
    }

    public <T> T create(Class<T> pluginClass) {
        try {
            return (T)OSGIPluginTracker.getInstance().findOrCreateBeanFactoryFor(this.container).getInstance(this.beanId, pluginClass);
        }
        catch (OSGIPluginTrackerException e) {
            this.logger.error("Error retriving plugin bean from blueprint container", (Throwable)e);
            return null;
        }
    }
}

