/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.hadoop.HadoopConfigurationInfo;
import org.pentaho.di.core.hadoop.HadoopConfigurationListener;
import org.pentaho.di.core.hadoop.HadoopConfigurationPrompter;
import org.pentaho.di.core.hadoop.NoShimSpecifiedException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.PluginPropertiesUtil;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationLocator;
import org.pentaho.hadoop.shim.api.ActiveHadoopConfigurationLocator;
import org.pentaho.hadoop.shim.api.ShimProperties;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;

@KettleLifecyclePlugin(id="HadoopConfigurationBootstrap", name="Hadoop Configuration Bootstrap")
public class HadoopConfigurationBootstrap
implements KettleLifecycleListener,
ActiveHadoopConfigurationLocator {
    public static final String PLUGIN_ID = "HadoopConfigurationBootstrap";
    public static final String PROPERTY_ACTIVE_HADOOP_CONFIGURATION = "active.hadoop.configuration";
    public static final String PROPERTY_HADOOP_CONFIGURATIONS_PATH = "hadoop.configurations.path";
    public static final String DEFAULT_FOLDER_HADOOP_CONFIGURATIONS = "hadoop-configurations";
    public static final String CONFIG_PROPERTIES = "config.properties";
    private static final Class<?> PKG = HadoopConfigurationBootstrap.class;
    public static final String PMR_PROPERTIES = "pmr.properties";
    private static final String NOTIFICATIONS_BEFORE_LOADING_SHIM = "notificationsBeforeLoadingShim";
    static final String MAX_TIMEOUT_BEFORE_LOADING_SHIM = "maxTimeoutBeforeLoadingShim";
    private static LogChannelInterface log = new LogChannel((Object)BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.LoggingPrefix", (String[])new String[0]));
    private static HadoopConfigurationBootstrap instance = new HadoopConfigurationBootstrap();
    private final Set<HadoopConfigurationListener> hadoopConfigurationListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CountDownLatch remainingDependencies = new CountDownLatch(NumberUtils.toInt((String)this.getMergedPmrAndPluginProperties().getProperty("notificationsBeforeLoadingShim"), (int)0));
    private HadoopConfigurationPrompter prompter;
    private HadoopConfigurationProvider provider;
    private PluginInterface plugin;

    public static HadoopConfigurationProvider getHadoopConfigurationProvider() throws ConfigurationException {
        return instance.getProvider();
    }

    public static HadoopConfigurationBootstrap getInstance() {
        return instance;
    }

    protected static void setInstance(HadoopConfigurationBootstrap instance) {
        HadoopConfigurationBootstrap.instance = instance;
    }

    public HadoopConfigurationProvider getProvider() throws ConfigurationException {
        try {
            int timeout = NumberUtils.toInt((String)this.getMergedPmrAndPluginProperties().getProperty(MAX_TIMEOUT_BEFORE_LOADING_SHIM), (int)300);
            CountDownLatch remainingDependencies = this.getRemainingDependencies();
            long nrNotifications = remainingDependencies.getCount();
            if (nrNotifications > 0L) {
                log.logDebug(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.WaitForShimLoad", (Object[])new Object[]{nrNotifications, timeout}));
            }
            remainingDependencies.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            while (this.remainingDependencies.getCount() > 0L) {
                this.remainingDependencies.countDown();
            }
            Thread.currentThread().interrupt();
        }
        this.initProvider();
        return this.provider;
    }

    public void setPrompter(HadoopConfigurationPrompter prompter) {
        this.prompter = prompter;
    }

    protected synchronized void initProvider() throws ConfigurationException {
        if (this.provider == null) {
            HadoopConfigurationPrompter prompter = this.prompter;
            if (Utils.isEmpty((CharSequence)this.getWillBeActiveConfigurationId()) && prompter != null) {
                try {
                    this.setActiveShim(prompter.getConfigurationSelection(this.getHadoopConfigurationInfos()));
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            if (Utils.isEmpty((CharSequence)this.getWillBeActiveConfigurationId())) {
                throw new NoShimSpecifiedException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.NoShimSet", (String[])new String[0]));
            }
            try {
                FileObject hadoopConfigurationsDir = this.resolveHadoopConfigurationsDirectory();
                HadoopConfigurationProvider p = this.initializeHadoopConfigurationProvider(hadoopConfigurationsDir);
                HadoopConfiguration activeConfig = null;
                try {
                    activeConfig = p.getActiveConfiguration();
                }
                catch (Exception ex) {
                    throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.InvalidActiveConfiguration", (String[])new String[]{this.getActiveConfigurationId()}), (Throwable)ex);
                }
                if (activeConfig == null) {
                    throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.InvalidActiveConfiguration", (String[])new String[]{this.getActiveConfigurationId()}));
                }
                this.provider = p;
                for (HadoopConfigurationListener hadoopConfigurationListener : this.hadoopConfigurationListeners) {
                    hadoopConfigurationListener.onConfigurationOpen(activeConfig, true);
                }
                log.logDetailed(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.Loaded", (String[])new String[0]), new Object[]{this.provider.getConfigurations().size(), hadoopConfigurationsDir});
            }
            catch (Exception ex) {
                if (ex instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)ex);
                }
                throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.StartupError", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    protected HadoopConfigurationProvider initializeHadoopConfigurationProvider(FileObject hadoopConfigurationsDir) throws ConfigurationException {
        final String activeConfigurationId = this.getWillBeActiveConfigurationId();
        HadoopConfigurationLocator locator = new HadoopConfigurationLocator(){

            protected ClassLoader createConfigurationLoader(FileObject root, ClassLoader parent, List<URL> classpathUrls, ShimProperties configurationProperties, String ... ignoredClasses) throws ConfigurationException {
                ClassLoader classLoader = super.createConfigurationLoader(root, parent, classpathUrls, configurationProperties, ignoredClasses);
                for (HadoopConfigurationListener listener : HadoopConfigurationBootstrap.this.hadoopConfigurationListeners) {
                    listener.onClassLoaderAvailable(classLoader);
                }
                return classLoader;
            }
        };
        locator.init(hadoopConfigurationsDir, new ActiveHadoopConfigurationLocator(){

            public String getActiveConfigurationId() throws ConfigurationException {
                return activeConfigurationId;
            }
        }, new DefaultFileSystemManager());
        return locator;
    }

    public synchronized List<HadoopConfigurationInfo> getHadoopConfigurationInfos() throws KettleException, ConfigurationException, IOException {
        ArrayList<HadoopConfigurationInfo> result = new ArrayList<HadoopConfigurationInfo>();
        FileObject hadoopConfigurationsDir = this.resolveHadoopConfigurationsDirectory();
        if (hadoopConfigurationsDir.exists()) {
            String activeId = this.getActiveConfigurationId();
            String willBeActiveId = this.getWillBeActiveConfigurationId();
            for (FileObject childFolder : hadoopConfigurationsDir.getChildren()) {
                if (childFolder.getType() != FileType.FOLDER) continue;
                String id = childFolder.getName().getBaseName();
                FileObject configPropertiesFile = childFolder.getChild(CONFIG_PROPERTIES);
                if (!configPropertiesFile.exists()) continue;
                Properties properties = new Properties();
                properties.load(configPropertiesFile.getContent().getInputStream());
                result.add(new HadoopConfigurationInfo(id, properties.getProperty("name", id), id.equals(activeId), willBeActiveId.equals(id)));
            }
        }
        return result;
    }

    public Properties getPluginProperties() throws ConfigurationException {
        try {
            return new PluginPropertiesUtil().loadPluginProperties(this.getPluginInterface());
        }
        catch (Exception ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.UnableToLoadPluginProperties", (String[])new String[0]), (Throwable)ex);
        }
    }

    protected PluginInterface getPluginInterface() throws KettleException {
        if (this.plugin == null) {
            PluginInterface pi = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
            if (pi == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.CannotLocatePlugin", (String[])new String[0]));
            }
            this.plugin = pi;
        }
        return this.plugin;
    }

    public FileObject locatePluginDirectory() throws ConfigurationException {
        FileObject dir = null;
        boolean exists = false;
        try {
            dir = KettleVFS.getFileObject((String)this.getPluginInterface().getPluginDirectory().toExternalForm());
            exists = dir.exists();
        }
        catch (Exception e) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.PluginDirectoryNotFound", (String[])new String[0]), (Throwable)e);
        }
        if (!exists) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.PluginDirectoryNotFound", (String[])new String[0]));
        }
        return dir;
    }

    public FileObject resolveHadoopConfigurationsDirectory() throws ConfigurationException, IOException, KettleException {
        String hadoopConfigurationPath = this.getPluginProperties().getProperty(PROPERTY_HADOOP_CONFIGURATIONS_PATH, DEFAULT_FOLDER_HADOOP_CONFIGURATIONS);
        return this.locatePluginDirectory().resolveFile(hadoopConfigurationPath);
    }

    public synchronized String getActiveConfigurationId() throws ConfigurationException {
        if (this.provider != null) {
            return this.provider.getActiveConfiguration().getIdentifier();
        }
        return this.getWillBeActiveConfigurationId();
    }

    public synchronized void setActiveShim(String shimId) throws ConfigurationException {
        if (this.provider != null && !shimId.equals(this.provider.getActiveConfiguration().getIdentifier()) && this.prompter != null) {
            this.prompter.promptForRestart();
        }
        this.getPluginProperties().setProperty(PROPERTY_ACTIVE_HADOOP_CONFIGURATION, shimId);
    }

    public String getWillBeActiveConfigurationId() throws ConfigurationException {
        Properties p;
        try {
            p = this.getPluginProperties();
        }
        catch (Exception ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.UnableToDetermineActiveConfiguration", (String[])new String[0]), (Throwable)ex);
        }
        if (!p.containsKey(PROPERTY_ACTIVE_HADOOP_CONFIGURATION)) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.MissingActiveConfigurationProperty", (String[])new String[]{PROPERTY_ACTIVE_HADOOP_CONFIGURATION}));
        }
        return p.getProperty(PROPERTY_ACTIVE_HADOOP_CONFIGURATION);
    }

    public void onEnvironmentInit() throws LifecycleException {
        Properties pmrProperties = this.getPmrProperties();
        String isPmr = pmrProperties.getProperty("isPmr", "false");
        if ("true".equals(isPmr)) {
            try {
                log.logDebug(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.InitializingShimPmr", (String[])new String[0]));
                HadoopConfigurationBootstrap.getInstance().getProvider();
                log.logBasic(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.InitializedShimPmr", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new LifecycleException(BaseMessages.getString(PKG, (String)"HadoopConfigurationBootstrap.HadoopConfiguration.StartupError", (String[])new String[0]), (Throwable)e, true);
            }
        }
    }

    public void onEnvironmentShutdown() {
    }

    public synchronized void registerHadoopConfigurationListener(HadoopConfigurationListener hadoopConfigurationListener) throws ConfigurationException {
        if (this.hadoopConfigurationListeners.add(hadoopConfigurationListener) && this.provider != null) {
            hadoopConfigurationListener.onConfigurationOpen(this.getProvider().getActiveConfiguration(), true);
        }
    }

    public void unregisterHadoopConfigurationListener(HadoopConfigurationListener hadoopConfigurationListener) {
        this.hadoopConfigurationListeners.remove(hadoopConfigurationListener);
    }

    public void notifyDependencyLoaded() {
        this.getRemainingDependencies().countDown();
    }

    protected Properties getMergedPmrAndPluginProperties() {
        Properties properties = new Properties();
        try {
            properties.putAll((Map<?, ?>)this.getPluginProperties());
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties.putAll((Map<?, ?>)this.getPmrProperties());
        return properties;
    }

    protected CountDownLatch getRemainingDependencies() {
        return this.remainingDependencies;
    }

    private Properties getPmrProperties() {
        InputStream pmrProperties = HadoopConfigurationBootstrap.class.getClassLoader().getResourceAsStream(PMR_PROPERTIES);
        Properties properties = new Properties();
        if (pmrProperties != null) {
            try {
                properties.load(pmrProperties);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }
}

