/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hadoop;

import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.hadoop.HadoopClusterViewTreeExtension;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class HadoopClusterFolderProvider
extends TreeFolderProvider {
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(HadoopClusterViewTreeExtension.class, (String)"NamedClusterDialog.STRING_NAMED_CLUSTERS", (String[])new String[0]);
    private static Class<?> PKG = Spoon.class;

    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        List<NamedCluster> namedClusters;
        try {
            namedClusters = NamedClusterManager.getInstance().list((IMetaStore)Spoon.getInstance().metaStore);
        }
        catch (MetaStoreException e) {
            new ErrorDialog(Spoon.getInstance().getShell(), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.NamedCluster", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        for (NamedCluster namedCluster : namedClusters) {
            if (!this.filterMatch(namedCluster.getName(), filter)) continue;
            this.createTreeNode(treeNode, namedCluster.getName(), this.getHadoopClusterImage(Spoon.getInstance().getDisplay()));
        }
    }

    public String getTitle() {
        return STRING_NAMED_CLUSTERS;
    }

    private Image getHadoopClusterImage(Display display) {
        SwtUniversalImage swtImage = SwtSvgImageUtil.getUniversalImage((Display)display, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"hadoop_clusters.svg");
        Image image = swtImage.getAsBitmapForSize((Device)display, 24, 24);
        display.addListener(12, event -> swtImage.dispose());
        return image;
    }
}

