/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import java.util.Arrays;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.s3n.vfs.S3NFileProvider;

@KettleLifecyclePlugin(id="AmazonS3NFileSystemBootstrap", name="Amazon S3N FileSystem Bootstrap")
public class AmazonS3NFileSystemBootstrap
implements KettleLifecycleListener {
    private static Class<?> PKG = AmazonS3NFileSystemBootstrap.class;
    private LogChannelInterface log = new LogChannel((Object)AmazonS3NFileSystemBootstrap.class.getName());

    public static String getS3NFileSystemDisplayText() {
        return BaseMessages.getString(PKG, (String)"S3NVfsFileChooserDialog.FileSystemChoice.S3.Label", (String[])new String[0]);
    }

    public void onEnvironmentInit() throws LifecycleException {
        try {
            FileSystemManager fsm = KettleVFS.getInstance().getFileSystemManager();
            if (fsm instanceof DefaultFileSystemManager && !Arrays.asList(fsm.getSchemes()).contains("s3n")) {
                ((DefaultFileSystemManager)fsm).addProvider("s3n", (FileProvider)new S3NFileProvider());
            }
        }
        catch (FileSystemException e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"AmazonSpoonPlugin.StartupError.FailedToLoadS3Driver", (String[])new String[0]));
        }
    }

    public void onEnvironmentShutdown() {
    }
}

