/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SlaveSequence;
import org.pentaho.di.www.TransformationMap;

public class NextSequenceValueServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/nextSequence";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_INCREMENT = "increment";
    public static final String XML_TAG = "seq";
    public static final String XML_TAG_VALUE = "value";
    public static final String XML_TAG_INCREMENT = "increment";
    public static final String XML_TAG_ERROR = "error";

    public NextSequenceValueServlet() {
    }

    public NextSequenceValueServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(this.toString());
        }
        String name = request.getParameter(PARAM_NAME);
        long increment = Const.toLong((String)request.getParameter("increment"), (long)10000L);
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.println(XMLHandler.getXMLHeader((String)"UTF-8"));
        out.println(XMLHandler.openTag((String)XML_TAG));
        try {
            SlaveSequence slaveSequence = this.getTransformationMap().getSlaveSequence(name);
            if (slaveSequence == null && this.getTransformationMap().isAutomaticSlaveSequenceCreationAllowed()) {
                slaveSequence = this.getTransformationMap().createSlaveSequence(name);
            }
            if (slaveSequence == null) {
                response.sendError(404);
                out.println(XMLHandler.addTagValue((String)XML_TAG_ERROR, (String)("Slave sequence '" + name + "' could not be found.")));
            } else {
                SimpleLoggingObject loggingObject = new SimpleLoggingObject("Carte", LoggingObjectType.CARTE, null);
                long nextValue = slaveSequence.getNextValue((LoggingObjectInterface)loggingObject, increment);
                out.println(XMLHandler.addTagValue((String)XML_TAG_VALUE, (long)nextValue));
                out.println(XMLHandler.addTagValue((String)"increment", (long)increment));
            }
        }
        catch (Exception e) {
            response.sendError(404);
            out.println(XMLHandler.addTagValue((String)XML_TAG_ERROR, (String)("Error retrieving next value from slave sequence: " + Const.getStackTracker((Throwable)e))));
        }
        out.println(XMLHandler.closeTag((String)XML_TAG));
    }

    public String toString() {
        return "Retrieve the next value of slave server sequence requested.";
    }

    @Override
    public String getService() {
        return "/kettle/nextSequence (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

