/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;

public class ExecuteJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = ExecuteJobServlet.class;
    private static final long serialVersionUID = -5879219287669847357L;
    public static final String CONTEXT_PATH = "/kettle/executeJob";

    public ExecuteJobServlet() {
    }

    public ExecuteJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Log.ExecuteJobRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{"rep", "user", "pass", "job", "level"};
        String repOption = request.getParameter("rep");
        String userOption = request.getParameter("user");
        String passOption = Encr.decryptPasswordOptionallyEncrypted((String)request.getParameter("pass"));
        String jobOption = request.getParameter("job");
        String levelOption = request.getParameter("level");
        response.setStatus(200);
        String encoding = System.getProperty("KETTLE_DEFAULT_SERVLET_ENCODING", null);
        if (encoding != null && !Utils.isEmpty((CharSequence)encoding.trim())) {
            response.setCharacterEncoding(encoding);
            response.setContentType("text/html; charset=" + encoding);
        }
        PrintWriter out = response.getWriter();
        try {
            final Repository repository = this.openRepository(repOption, userOption, passOption);
            JobMeta jobMeta = this.loadJob(repository, jobOption);
            String[] parameters = jobMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
                if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                    jobMeta.setVariable(parameter, values[0]);
                    continue;
                }
                jobMeta.setParameterValue(parameter, values[0]);
            }
            JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
            LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
            jobExecutionConfiguration.setLogLevel(logLevel);
            JobConfiguration jobConfiguration = new JobConfiguration(jobMeta, jobExecutionConfiguration);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(logLevel);
            Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
            job.setRepository(repository);
            job.setSocketRepository(this.getSocketRepository());
            this.getJobMap().addJob(jobMeta.getName(), carteObjectId, job, jobConfiguration);
            job.setContainerObjectId(carteObjectId);
            if (repository != null) {
                job.addJobListener(new JobAdapter(){

                    @Override
                    public void jobFinished(Job job) {
                        repository.disconnect();
                    }
                });
            }
            try {
                this.runJob(job);
                WebResult webResult = new WebResult("OK", "Job started", carteObjectId);
                out.println(webResult.getXML());
                out.flush();
            }
            catch (Exception executionException) {
                String logging = KettleLogStore.getAppender().getBuffer(job.getLogChannelId(), false).toString();
                throw new KettleException("Error executing job: " + logging, (Throwable)executionException);
            }
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
        }
    }

    private JobMeta loadJob(Repository repository, String job) throws KettleException {
        String name;
        String directoryPath;
        if (repository == null) {
            JobMeta jobMeta = new JobMeta(job, repository);
            return jobMeta;
        }
        int lastSlash = job.lastIndexOf("/");
        if (lastSlash < 0) {
            directoryPath = "/";
            name = job;
        } else {
            directoryPath = job.substring(0, lastSlash);
            name = job.substring(lastSlash + 1);
        }
        RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
        if (directory == null) {
            throw new KettleException("Unable to find directory path '" + directoryPath + "' in the repository");
        }
        ObjectId jobID = repository.getJobId(name, directory);
        if (jobID == null) {
            throw new KettleException("Unable to find job '" + name + "' in directory :" + directory);
        }
        JobMeta jobMeta = repository.loadJob(jobID, null);
        return jobMeta;
    }

    private Repository openRepository(String repositoryName, String user, String pass) throws KettleException {
        if (Utils.isEmpty((CharSequence)repositoryName)) {
            return null;
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        repositoriesMeta.readData();
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta == null) {
            throw new KettleException("Unable to find repository: " + repositoryName);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Repository repository = (Repository)registry.loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        repository.init(repositoryMeta);
        repository.connect(user, pass);
        return repository;
    }

    public String toString() {
        return "Start job";
    }

    @Override
    public String getService() {
        return "/kettle/executeJob (" + this.toString() + ")";
    }

    protected void runJob(Job job) {
        job.start();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

