/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MappingParameters
implements Cloneable {
    public static final String XML_TAG = "parameters";
    private static final String XML_VARIABLES_TAG = "variablemapping";
    private String[] variable;
    private String[] input;
    private boolean inheritingAllVariables;

    public MappingParameters() {
        this.variable = new String[0];
        this.input = new String[0];
        this.inheritingAllVariables = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public MappingParameters(Node paramNode) {
        int nrVariables = XMLHandler.countNodes((Node)paramNode, (String)XML_VARIABLES_TAG);
        this.variable = new String[nrVariables];
        this.input = new String[nrVariables];
        for (int i = 0; i < this.variable.length; ++i) {
            Node variableMappingNode = XMLHandler.getSubNodeByNr((Node)paramNode, (String)XML_VARIABLES_TAG, (int)i);
            this.variable[i] = XMLHandler.getTagValue((Node)variableMappingNode, (String)"variable");
            this.input[i] = XMLHandler.getTagValue((Node)variableMappingNode, (String)"input");
        }
        this.inheritingAllVariables = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)paramNode, (String)"inherit_all_vars"));
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder(200);
        xml.append("    ").append(XMLHandler.openTag((String)XML_TAG));
        for (int i = 0; i < this.variable.length; ++i) {
            xml.append("       ").append(XMLHandler.openTag((String)XML_VARIABLES_TAG));
            xml.append(XMLHandler.addTagValue((String)"variable", (String)this.variable[i], (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"input", (String)this.input[i], (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.closeTag((String)XML_VARIABLES_TAG)).append(Const.CR);
        }
        xml.append("    ").append(XMLHandler.addTagValue((String)"inherit_all_vars", (boolean)this.inheritingAllVariables));
        xml.append("    ").append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        for (int i = 0; i < this.variable.length; ++i) {
            rep.saveStepAttribute(id_transformation, id_step, i, "mapping_parameter_variable", this.variable[i]);
            rep.saveStepAttribute(id_transformation, id_step, i, "mapping_parameter_input", this.input[i]);
        }
        rep.saveStepAttribute(id_transformation, id_step, "mapping_parameter_inherit_all_vars", this.inheritingAllVariables);
    }

    public MappingParameters(Repository rep, ObjectId id_step) throws KettleException {
        int nrVariables = rep.countNrStepAttributes(id_step, "mapping_parameter_variable");
        this.variable = new String[nrVariables];
        this.input = new String[nrVariables];
        for (int i = 0; i < nrVariables; ++i) {
            this.variable[i] = rep.getStepAttributeString(id_step, i, "mapping_parameter_variable");
            this.input[i] = rep.getStepAttributeString(id_step, i, "mapping_parameter_input");
        }
        this.inheritingAllVariables = rep.getStepAttributeBoolean(id_step, "mapping_parameter_inherit_all_vars");
    }

    public String[] getInputField() {
        return this.input;
    }

    public void setInputField(String[] inputField) {
        this.input = inputField;
    }

    public String[] getVariable() {
        return this.variable;
    }

    public void setVariable(String[] variable) {
        this.variable = variable;
    }

    public boolean isInheritingAllVariables() {
        return this.inheritingAllVariables;
    }

    public void setInheritingAllVariables(boolean inheritingAllVariables) {
        this.inheritingAllVariables = inheritingAllVariables;
    }
}

