/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.file;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;

public class BaseFileInputStepUtils {
    public static void handleMissingFiles(FileInputList files, LogChannelInterface log, boolean isErrorIgnored, FileErrorHandler errorHandler) throws KettleException {
        List nonAccessibleFiles;
        List nonExistantFiles = files.getNonExistantFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (log.isBasic()) {
                log.logBasic("Required files", new Object[]{"WARNING: Missing " + message});
            }
            if (isErrorIgnored) {
                for (FileObject fileObject : nonExistantFiles) {
                    errorHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new KettleException("Following required files are missing: " + message);
            }
        }
        if (!(nonAccessibleFiles = files.getNonAccessibleFiles()).isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (log.isBasic()) {
                log.logBasic("Required files", new Object[]{"WARNING: Not accessible " + message});
            }
            if (isErrorIgnored) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    errorHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new KettleException("Following required files are not accessible: " + message);
            }
        }
    }

    public static int addValueMeta(String stepName, RowMetaInterface rowMeta, String fieldName) {
        ValueMetaString valueMeta = new ValueMetaString(fieldName);
        valueMeta.setOrigin(stepName);
        int index = -1;
        if (!rowMeta.exists((ValueMetaInterface)valueMeta)) {
            index = rowMeta.size();
            rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        } else {
            index = rowMeta.indexOfValue(fieldName);
        }
        return index;
    }
}

