/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.AfterInjection;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.DataTypeConverter;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitter;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.TrimTypeConverter;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="FieldSplitter.Injection.", groups={"FIELDS"})
public class FieldSplitterMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = FieldSplitterMeta.class;
    @Injection(name="FIELD_TO_SPLIT")
    private String splitField;
    @Injection(name="DELIMITER")
    private String delimiter;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="ID", group="FIELDS")
    private String[] fieldID;
    @Injection(name="REMOVE_ID", group="FIELDS")
    private boolean[] fieldRemoveID;
    @Injection(name="DATA_TYPE", group="FIELDS", converter=DataTypeConverter.class)
    private int[] fieldType;
    @Injection(name="FORMAT", group="FIELDS")
    private String[] fieldFormat;
    @Injection(name="GROUPING", group="FIELDS")
    private String[] fieldGroup;
    @Injection(name="DECIMAL", group="FIELDS")
    private String[] fieldDecimal;
    @Injection(name="CURRENCY", group="FIELDS")
    private String[] fieldCurrency;
    @Injection(name="LENGTH", group="FIELDS")
    private int[] fieldLength;
    @Injection(name="PRECISION", group="FIELDS")
    private int[] fieldPrecision;
    @Injection(name="NULL_IF", group="FIELDS")
    private String[] fieldNullIf;
    @Injection(name="DEFAULT", group="FIELDS")
    private String[] fieldIfNull;
    @Injection(name="TRIM_TYPE", group="FIELDS", converter=TrimTypeConverter.class)
    private int[] fieldTrimType;

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String[] fieldID) {
        this.fieldID = fieldID;
    }

    public boolean[] getFieldRemoveID() {
        return this.fieldRemoveID;
    }

    public void setFieldRemoveID(boolean[] fieldRemoveID) {
        this.fieldRemoveID = fieldRemoveID;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String[] getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(String[] fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public String[] getFieldDecimal() {
        return this.fieldDecimal;
    }

    public void setFieldDecimal(String[] fieldDecimal) {
        this.fieldDecimal = fieldDecimal;
    }

    public String[] getFieldCurrency() {
        return this.fieldCurrency;
    }

    public void setFieldCurrency(String[] fieldCurrency) {
        this.fieldCurrency = fieldCurrency;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldNullIf() {
        return this.fieldNullIf;
    }

    public void setFieldNullIf(String[] fieldNullIf) {
        this.fieldNullIf = fieldNullIf;
    }

    public String[] getFieldIfNull() {
        return this.fieldIfNull;
    }

    public void setFieldIfNull(String[] fieldIfNull) {
        this.fieldIfNull = fieldIfNull;
    }

    public int[] getFieldTrimType() {
        return this.fieldTrimType;
    }

    public void setFieldTrimType(int[] fieldTrimType) {
        this.fieldTrimType = fieldTrimType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldID = new String[nrfields];
        this.fieldRemoveID = new boolean[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldGroup = new String[nrfields];
        this.fieldDecimal = new String[nrfields];
        this.fieldCurrency = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.fieldNullIf = new String[nrfields];
        this.fieldIfNull = new String[nrfields];
        this.fieldTrimType = new int[nrfields];
    }

    @Override
    public Object clone() {
        FieldSplitterMeta retval = (FieldSplitterMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrfields);
        System.arraycopy(this.fieldID, 0, retval.fieldID, 0, nrfields);
        System.arraycopy(this.fieldRemoveID, 0, retval.fieldRemoveID, 0, nrfields);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, nrfields);
        System.arraycopy(this.fieldLength, 0, retval.fieldLength, 0, nrfields);
        System.arraycopy(this.fieldPrecision, 0, retval.fieldPrecision, 0, nrfields);
        System.arraycopy(this.fieldFormat, 0, retval.fieldFormat, 0, nrfields);
        System.arraycopy(this.fieldGroup, 0, retval.fieldGroup, 0, nrfields);
        System.arraycopy(this.fieldDecimal, 0, retval.fieldDecimal, 0, nrfields);
        System.arraycopy(this.fieldCurrency, 0, retval.fieldCurrency, 0, nrfields);
        System.arraycopy(this.fieldNullIf, 0, retval.fieldNullIf, 0, nrfields);
        System.arraycopy(this.fieldIfNull, 0, retval.fieldIfNull, 0, nrfields);
        System.arraycopy(this.fieldTrimType, 0, retval.fieldTrimType, 0, nrfields);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.splitField = XMLHandler.getTagValue((Node)stepnode, (String)"splitfield");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldID[i] = XMLHandler.getTagValue((Node)fnode, (String)"id");
                String sidrem = XMLHandler.getTagValue((Node)fnode, (String)"idrem");
                String stype = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.fieldGroup[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                this.fieldDecimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.fieldCurrency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                String slen = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldNullIf[i] = XMLHandler.getTagValue((Node)fnode, (String)"nullif");
                this.fieldIfNull[i] = XMLHandler.getTagValue((Node)fnode, (String)"ifnull");
                String trim = XMLHandler.getTagValue((Node)fnode, (String)"trimtype");
                this.fieldRemoveID[i] = "Y".equalsIgnoreCase(sidrem);
                this.fieldType[i] = ValueMetaFactory.getIdForValueMeta((String)stype);
                this.fieldLength[i] = Const.toInt((String)slen, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprc, (int)-1);
                this.fieldTrimType[i] = ValueMetaString.getTrimTypeByCode((String)trim);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.splitField = "";
        this.delimiter = ",";
        this.enclosure = null;
        this.allocate(0);
    }

    public int getFieldsCount() {
        int count = Math.min(this.getFieldName().length, this.getFieldType().length);
        count = Math.min(count, this.getFieldLength().length);
        count = Math.min(count, this.getFieldPrecision().length);
        count = Math.min(count, this.getFieldFormat().length);
        count = Math.min(count, this.getFieldDecimal().length);
        count = Math.min(count, this.getFieldGroup().length);
        count = Math.min(count, this.getFieldCurrency().length);
        count = Math.min(count, this.getFieldTrimType().length);
        return count;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int idx = r.indexOfValue(this.getSplitField());
        if (idx < 0) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{this.getSplitField()}));
        }
        int count = this.getFieldsCount();
        for (int i = 0; i < count; ++i) {
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)this.getFieldName()[i], (int)this.getFieldType()[i]);
                v.setLength(this.getFieldLength()[i], this.getFieldPrecision()[i]);
                v.setOrigin(name);
                v.setConversionMask(this.getFieldFormat()[i]);
                v.setDecimalSymbol(this.getFieldDecimal()[i]);
                v.setGroupingSymbol(this.getFieldGroup()[i]);
                v.setCurrencySymbol(this.getFieldCurrency()[i]);
                v.setTrimType(this.getFieldTrimType()[i]);
                if (i == 0 && idx >= 0) {
                    r.setValueMeta(idx, v);
                    continue;
                }
                if (idx >= r.size()) {
                    r.addValueMeta(v);
                }
                r.addValueMeta(idx + i, v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("   ").append(XMLHandler.addTagValue((String)"splitfield", (String)this.splitField)).append("   ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter)).append("   ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("   ").append("<fields>");
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      ").append("<field>").append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i])).append("        ").append(XMLHandler.addTagValue((String)"id", ArrayUtils.isEmpty((Object[])this.fieldID) ? null : this.fieldID[i])).append("        ").append(XMLHandler.addTagValue((String)"idrem", (boolean)(ArrayUtils.isEmpty((boolean[])this.fieldRemoveID) ? false : this.fieldRemoveID[i]))).append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)(ArrayUtils.isEmpty((int[])this.fieldType) ? 0 : this.fieldType[i])))).append("        ").append(XMLHandler.addTagValue((String)"format", ArrayUtils.isEmpty((Object[])this.fieldFormat) ? null : this.fieldFormat[i])).append("        ").append(XMLHandler.addTagValue((String)"group", ArrayUtils.isEmpty((Object[])this.fieldGroup) ? null : this.fieldGroup[i])).append("        ").append(XMLHandler.addTagValue((String)"decimal", ArrayUtils.isEmpty((Object[])this.fieldDecimal) ? null : this.fieldDecimal[i])).append("        ").append(XMLHandler.addTagValue((String)"currency", ArrayUtils.isEmpty((Object[])this.fieldCurrency) ? null : this.fieldCurrency[i])).append("        ").append(XMLHandler.addTagValue((String)"length", (int)(ArrayUtils.isEmpty((int[])this.fieldLength) ? -1 : this.fieldLength[i]))).append("        ").append(XMLHandler.addTagValue((String)"precision", (int)(ArrayUtils.isEmpty((int[])this.fieldPrecision) ? -1 : this.fieldPrecision[i]))).append("        ").append(XMLHandler.addTagValue((String)"nullif", ArrayUtils.isEmpty((Object[])this.fieldNullIf) ? null : this.fieldNullIf[i])).append("        ").append(XMLHandler.addTagValue((String)"ifnull", ArrayUtils.isEmpty((Object[])this.fieldIfNull) ? null : this.fieldIfNull[i])).append("        ").append(XMLHandler.addTagValue((String)"trimtype", (String)ValueMetaString.getTrimTypeCode((int)(ArrayUtils.isEmpty((int[])this.fieldTrimType) ? 0 : this.fieldTrimType[i])))).append("      ").append("</field>");
        }
        retval.append("    ").append("</fields>");
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.splitField = rep.getStepAttributeString(id_step, "splitfield");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldID[i] = rep.getStepAttributeString(id_step, i, "field_id");
                this.fieldRemoveID[i] = rep.getStepAttributeBoolean(id_step, i, "field_idrem");
                this.fieldType[i] = ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.fieldGroup[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.fieldDecimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.fieldCurrency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.fieldNullIf[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
                this.fieldIfNull[i] = rep.getStepAttributeString(id_step, i, "field_ifnull");
                this.fieldTrimType[i] = ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trimtype"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "splitfield", this.splitField);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_id", this.fieldID[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_idrem", this.fieldRemoveID[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMetaFactory.getValueMetaName((int)this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.fieldGroup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.fieldDecimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.fieldCurrency[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", this.fieldNullIf[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ifnull", this.fieldIfNull[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trimtype", ValueMetaString.getTrimTypeCode((int)this.fieldTrimType[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnalbeToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            int i = prev.indexOfValue(this.splitField);
            if (i < 0) {
                error_message = BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldNotPresentInInputStream", (String[])new String[]{this.splitField});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldFoundInInputStream", (String[])new String[]{this.splitField}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.StepReceivingInfoFromOtherStep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.NoInputReceivedFromOtherStep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new FieldSplitter(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FieldSplitterData();
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.fieldName == null ? -1 : this.fieldName.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] normalizedStringArrays = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.fieldID, this.fieldFormat, this.fieldGroup, this.fieldDecimal, this.fieldCurrency, this.fieldNullIf, this.fieldIfNull});
        this.fieldID = normalizedStringArrays[0];
        this.fieldFormat = normalizedStringArrays[1];
        this.fieldGroup = normalizedStringArrays[2];
        this.fieldDecimal = normalizedStringArrays[3];
        this.fieldCurrency = normalizedStringArrays[4];
        this.fieldNullIf = normalizedStringArrays[5];
        this.fieldIfNull = normalizedStringArrays[6];
        boolean[][] normalizedBooleanArrays = Utils.normalizeArrays((int)nrFields, (boolean[][])new boolean[][]{this.fieldRemoveID});
        this.fieldRemoveID = normalizedBooleanArrays[0];
        int[][] normalizedIntArrays = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.fieldType, this.fieldLength, this.fieldPrecision, this.fieldTrimType});
        this.fieldType = normalizedIntArrays[0];
        this.fieldLength = normalizedIntArrays[1];
        this.fieldPrecision = normalizedIntArrays[2];
        this.fieldTrimType = normalizedIntArrays[3];
    }
}

