/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import com.google.common.base.Strings;
import java.net.URI;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.protocol.HttpContext;

public class SessionConfigurator
extends ClientEndpointConfig.Configurator {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String NEGOTIATE = "NEGOTIATE";
    private static final String LOGIN_MODULE_NAME = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String ERROR_MSG = "Error starting websocket session";
    private static final String USE_KEY_TAB_OPT = "useKeyTab";
    private static final String KEY_TAB_OPT = "keyTab";
    private static final String PRINCIPAL_OPT = "principal";
    private static final String STORE_KEY_OPT = "storeKey";
    private static final String USE_TICKET_CACHE_OPT = "useTicketCache";
    private static final String DO_NOT_PROMPT_OPT = "doNotPrompt";
    private static final String IS_INITIATOR_OPT = "isInitiator";
    private boolean withAuth = false;
    private String principal = null;
    private String keytab = null;
    private URI url;
    private LoginContext loginContext;
    private static final Credentials credentials = new NullCredentials();
    private static final Header AUTHENTICATE_HEADER = new Header(){

        public String getName() {
            return SessionConfigurator.WWW_AUTHENTICATE;
        }

        public String getValue() {
            return SessionConfigurator.NEGOTIATE;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }
    };

    public SessionConfigurator(URI url, String keytab, String principal) {
        this.url = url;
        this.withAuth = !Strings.isNullOrEmpty((String)principal);
        this.principal = principal;
        this.keytab = keytab;
    }

    public void beforeRequest(Map<String, List<String>> headers) {
        Header authenticationHeader;
        if (this.withAuth && (authenticationHeader = this.getAuthenticationHeader(this.url)) != null) {
            headers.put(authenticationHeader.getName(), Collections.singletonList(authenticationHeader.getValue()));
        }
    }

    public void afterResponse(HandshakeResponse hr) {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
    }

    private Header getAuthenticationHeader(final URI uri) throws RuntimeException {
        try {
            ClientLoginConfig loginConfig = new ClientLoginConfig(this.keytab, this.principal);
            Subject serviceSubject = this.getServiceSubject(loginConfig);
            return Subject.doAs(serviceSubject, new PrivilegedAction<Header>(){

                @Override
                public Header run() {
                    try {
                        return SessionConfigurator.this.spnegoAuthenticate(false, uri);
                    }
                    catch (Exception e) {
                        RuntimeException saveFirstException = new RuntimeException(e);
                        try {
                            return SessionConfigurator.this.spnegoAuthenticate(true, uri);
                        }
                        catch (Exception e2) {
                            throw saveFirstException;
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(ERROR_MSG, e);
        }
    }

    private Header spnegoAuthenticate(boolean stripPort, URI uri) throws Exception {
        SPNegoSchemeFactory spNegoSchemeFactory = new SPNegoSchemeFactory(stripPort);
        SPNegoScheme spNegoScheme = (SPNegoScheme)spNegoSchemeFactory.newInstance(null);
        spNegoScheme.processChallenge(AUTHENTICATE_HEADER);
        return spNegoScheme.authenticate(credentials, (HttpRequest)new HttpGet(""), this.getContext(uri));
    }

    private HttpContext getContext(URI uri) {
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setAttribute("http.route", (Object)new HttpRoute(new HttpHost(uri.getHost(), uri.getPort())));
        httpClientContext.setAttribute("http.target_host", (Object)new HttpHost(uri.getHost(), uri.getPort()));
        return httpClientContext;
    }

    private Subject getServiceSubject(ClientLoginConfig loginConfig) throws Exception {
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        princ.add(new KerberosPrincipal(this.principal));
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        this.loginContext = new LoginContext("", sub, null, loginConfig);
        this.loginContext.login();
        return this.loginContext.getSubject();
    }

    private static class ClientLoginConfig
    extends Configuration {
        private final String keyTabLocation;
        private final String userPrincipal;

        private ClientLoginConfig(String keyTabLocation, String userPrincipal) {
            this.keyTabLocation = keyTabLocation;
            this.userPrincipal = userPrincipal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (!Strings.isNullOrEmpty((String)this.keyTabLocation) && !Strings.isNullOrEmpty((String)this.userPrincipal)) {
                options.put(SessionConfigurator.USE_KEY_TAB_OPT, Boolean.TRUE.toString());
                options.put(SessionConfigurator.KEY_TAB_OPT, this.keyTabLocation);
                options.put(SessionConfigurator.PRINCIPAL_OPT, this.userPrincipal);
                options.put(SessionConfigurator.STORE_KEY_OPT, Boolean.TRUE.toString());
            } else {
                options.put(SessionConfigurator.USE_TICKET_CACHE_OPT, Boolean.TRUE.toString());
            }
            options.put(SessionConfigurator.DO_NOT_PROMPT_OPT, Boolean.TRUE.toString());
            options.put(SessionConfigurator.IS_INITIATOR_OPT, Boolean.TRUE.toString());
            return new AppConfigurationEntry[]{new AppConfigurationEntry(SessionConfigurator.LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    private static class NullCredentials
    implements Credentials {
        private NullCredentials() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getPassword() {
            return null;
        }
    }
}

