/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.pentaho.di.base.AbstractBaseCommandExecutor;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.metastore.api.IMetaStore;

public class KitchenCommandExecutor
extends AbstractBaseCommandExecutor {
    Future<KettleException> kettleInit;

    public KitchenCommandExecutor(Class<?> pkgClazz) {
        this(pkgClazz, (LogChannelInterface)new LogChannel((Object)"Kitchen"), null);
    }

    public KitchenCommandExecutor(Class<?> pkgClazz, LogChannelInterface log) {
        this(pkgClazz, log, null);
    }

    public KitchenCommandExecutor(Class<?> pkgClazz, LogChannelInterface log, Future<KettleException> kettleInit) {
        this.setPkgClazz(pkgClazz);
        this.setLog(log);
        this.setKettleInit(kettleInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(String repoName, String noRepo, String username, String trustUser, String password, String dirName, String filename, String jobName, String listJobs, String listDirs, String exportRepo, String initialDir, String listRepos, String listParams, NamedParams params, NamedParams customParams, String[] arguments) throws Throwable {
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Log.Starting", (String[])new String[0]));
        Date start = Calendar.getInstance().getTime();
        this.logDebug("Kitchen.Log.AllocateNewJob");
        Job job = null;
        Repository repository = null;
        try {
            if (this.getMetaStore() == null) {
                this.setMetaStore(this.createDefaultMetastore());
            }
            if (!Utils.isEmpty((CharSequence)repoName) || !Utils.isEmpty((CharSequence)filename)) {
                this.logDebug("Kitchen.Log.ParsingCommandLine");
                if (!Utils.isEmpty((CharSequence)repoName) && !this.isEnabled(noRepo)) {
                    if (this.isEnabled(trustUser)) {
                        System.setProperty("pentaho.repository.client.attemptTrust", "Y");
                    }
                    RepositoryMeta repositoryMeta = this.loadRepositoryConnection(repoName, "Kitchen.Log.LoadingRep", "Kitchen.Error.NoRepDefinied", "Kitchen.Log.FindingRep");
                    repository = this.establishRepositoryConnection(repositoryMeta, username, password, RepositoryOperation.EXECUTE_JOB);
                    job = this.executeRepositoryBasedCommand(repository, repositoryMeta, dirName, jobName, listJobs, listDirs);
                }
                if (!Utils.isEmpty((CharSequence)filename) && job == null) {
                    job = this.executeFilesystemBasedCommand(initialDir, filename);
                }
            } else if (this.isEnabled(listRepos)) {
                this.printRepositories(this.loadRepositoryInfo("Kitchen.Log.ListRep", "Kitchen.Error.NoRepDefinied"));
            }
        }
        catch (KettleException e) {
            job = null;
            if (repository != null) {
                repository.disconnect();
            }
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.StopProcess", (String[])new String[]{e.getMessage()}));
        }
        if (job == null) {
            if (!(this.isEnabled(listJobs) || this.isEnabled(listDirs) || this.isEnabled(listRepos))) {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.canNotLoadJob", (String[])new String[0]));
            }
            return this.exitWithStatus(CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode());
        }
        if (!Utils.isEmpty((CharSequence)exportRepo)) {
            try {
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(exportRepo, job.getJobMeta(), job, repository, (IMetaStore)this.getMetaStore());
                String launchFile = topLevelResource.getResourceName();
                String message = ResourceUtil.getExplanation(exportRepo, launchFile, job.getJobMeta());
                System.out.println();
                System.out.println(message);
                listParams = "Y";
            }
            catch (Exception e) {
                System.out.println(Const.getStackTracker((Throwable)e));
                return this.exitWithStatus(CommandExecutorCodes.Kitchen.UNEXPECTED_ERROR.getCode());
            }
        }
        int returnCode = CommandExecutorCodes.Kitchen.SUCCESS.getCode();
        try {
            Result jobParams;
            job.setArguments((String[])(arguments != null ? arguments : null));
            job.initializeVariablesFrom(null);
            job.setLogLevel(this.getLog().getLogLevel());
            job.getJobMeta().setInternalKettleVariables(job);
            job.setRepository(repository);
            job.getJobMeta().setRepository(repository);
            job.getJobMeta().setMetaStore((IMetaStore)this.getMetaStore());
            for (String param : jobParams = job.getJobMeta().listParameters()) {
                String value = params.getParameterValue(param);
                if (value == null) continue;
                job.getJobMeta().setParameterValue(param, value);
            }
            job.copyParametersFrom(job.getJobMeta());
            job.activateParameters();
            for (String optionName : customParams.listParameters()) {
                String optionValue = customParams.getParameterValue(optionName);
                if (optionName == null || optionValue == null) continue;
                job.getExtensionDataMap().put(optionName, optionValue);
            }
            if (this.isEnabled(listParams)) {
                this.printJobParameters(job);
                Result result = this.exitWithStatus(CommandExecutorCodes.Kitchen.COULD_NOT_LOAD_JOB.getCode());
                return result;
            }
            job.start();
            job.waitUntilFinished();
            this.setResult(job.getResult());
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
            if (this.isEnabled(trustUser)) {
                System.clearProperty("pentaho.repository.client.attemptTrust");
            }
        }
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Log.Finished", (String[])new String[0]));
        if (this.getResult().getNrErrors() != 0L) {
            this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.FinishedWithErrors", (String[])new String[0]));
            returnCode = CommandExecutorCodes.Kitchen.ERRORS_DURING_PROCESSING.getCode();
        }
        Date stop = Calendar.getInstance().getTime();
        this.calculateAndPrintElapsedTime(start, stop, "Kitchen.Log.StartStop", "Kitchen.Log.ProcessEndAfter", "Kitchen.Log.ProcessEndAfterLong", "Kitchen.Log.ProcessEndAfterLonger", "Kitchen.Log.ProcessEndAfterLongest");
        this.getResult().setElapsedTimeMillis(stop.getTime() - start.getTime());
        return this.exitWithStatus(returnCode);
    }

    public int printVersion() {
        this.printVersion("Kitchen.Log.KettleVersion");
        return CommandExecutorCodes.Kitchen.KETTLE_VERSION_PRINT.getCode();
    }

    public Job executeRepositoryBasedCommand(Repository repository, RepositoryMeta repositoryMeta, String dirName, String jobName, String listJobs, String listDirs) throws Exception {
        if (repository != null && repositoryMeta != null) {
            this.logDebug("Kitchen.Log.Alocate&ConnectRep");
            RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree();
            if (repository.getMetaStore() != null && this.getMetaStore() != null) {
                this.getMetaStore().addMetaStore(repository.getMetaStore());
            }
            if (!Utils.isEmpty((CharSequence)dirName)) {
                directory = directory.findDirectory(dirName);
            }
            if (directory != null) {
                this.logDebug("Kitchen.Log.CheckUserPass");
                if (!Utils.isEmpty((CharSequence)jobName)) {
                    this.logDebug("Kitchen.Log.LoadingJobInfo");
                    this.blockAndThrow(this.getKettleInit());
                    JobMeta jobMeta = repository.loadJob(jobName, directory, null, null);
                    this.logDebug("Kitchen.Log.AllocateJob");
                    return new Job(repository, jobMeta);
                }
                if (this.isEnabled(listJobs)) {
                    this.printRepositoryStoredJobs(repository, directory);
                } else if (this.isEnabled(listDirs)) {
                    this.printRepositoryDirectories(repository, directory);
                }
            } else {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.CanNotFindSuppliedDirectory", (String[])new String[]{dirName + ""}));
                repositoryMeta = null;
            }
        } else {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Error.NoRepProvided", (String[])new String[0]));
        }
        return null;
    }

    public Job executeFilesystemBasedCommand(String initialDir, String filename) throws Exception {
        if (Utils.isEmpty((CharSequence)filename)) {
            return null;
        }
        this.blockAndThrow(this.getKettleInit());
        String fileName = filename;
        if (!KettleVFS.startsWithScheme((String)fileName) && !FileUtil.isFullyQualified(fileName)) {
            fileName = initialDir + fileName;
        }
        JobMeta jobMeta = new JobMeta(fileName, null, null);
        return new Job(null, jobMeta);
    }

    protected void printJobParameters(Job job) throws UnknownParamException {
        if (job != null && job.listParameters() != null) {
            for (String pName : job.listParameters()) {
                this.printParameter(pName, job.getParameterValue(pName), job.getParameterDefault(pName), job.getParameterDescription(pName));
            }
        }
    }

    protected void printRepositoryStoredJobs(Repository repository, RepositoryDirectoryInterface directory) throws KettleException {
        this.logDebug("Kitchen.Log.GettingLostJobsInDirectory", "" + directory);
        String[] jobnames = repository.getJobNames(directory.getObjectId(), false);
        for (int i = 0; i < jobnames.length; ++i) {
            System.out.println(jobnames[i]);
        }
    }

    protected void printRepositories(RepositoriesMeta repositoriesMeta) {
        if (repositoriesMeta != null) {
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Kitchen.Log.ListRep", (String[])new String[0]));
            for (int i = 0; i < repositoriesMeta.nrRepositories(); ++i) {
                RepositoryMeta rinfo = repositoriesMeta.getRepository(i);
                System.out.println("#" + (i + 1) + " : " + rinfo.getName() + " [" + rinfo.getDescription() + "]  id=" + rinfo.getId());
            }
        }
    }

    private <T extends Throwable> void blockAndThrow(Future<T> future) throws T {
        if (future == null) {
            return;
        }
        try {
            Throwable e = (Throwable)future.get();
            if (e != null) {
                throw e;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<KettleException> getKettleInit() {
        return this.kettleInit;
    }

    public void setKettleInit(Future<KettleException> kettleInit) {
        this.kettleInit = kettleInit;
    }
}

