/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.pentaho.di.core.compress.CompressionInputStream;
import org.pentaho.di.core.compress.CompressionProvider;

public class ZIPCompressionInputStream
extends CompressionInputStream {
    public ZIPCompressionInputStream(InputStream in, CompressionProvider provider) throws IOException {
        super(ZIPCompressionInputStream.getDelegate(in), provider);
    }

    protected static ZipInputStream getDelegate(InputStream in) throws IOException {
        ZipInputStream delegate = null;
        delegate = in instanceof ZipInputStream ? (ZipInputStream)in : new ZipInputStream(in);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException("Not a valid input stream!");
        }
        zis.close();
    }

    @Override
    public int read() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException("Not a valid input stream!");
        }
        return zis.read();
    }

    @Override
    public Object nextEntry() throws IOException {
        ZipInputStream zis = (ZipInputStream)this.delegate;
        if (zis == null) {
            throw new IOException("Not a valid input stream!");
        }
        return zis.getNextEntry();
    }
}

