/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.data.AppendableSchemaTuple;
import org.apache.pig.data.SchemaTuple;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.SchemaTupleFactory;
import org.apache.pig.data.SchemaTupleFrontend;
import org.apache.pig.data.utils.StructuresHelper;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;

public class SchemaTupleBackend {
    private static final Log LOG = LogFactory.getLog(SchemaTupleBackend.class);
    private Set<String> filesToResolve = Sets.newHashSet();
    private URLClassLoader classLoader;
    private Map<StructuresHelper.Triple<StructuresHelper.SchemaKey, Boolean, SchemaTupleClassGenerator.GenContext>, SchemaTupleFactory> schemaTupleFactoriesByTriple = Maps.newHashMap();
    private Map<Integer, SchemaTupleFactory> schemaTupleFactoriesById = Maps.newHashMap();
    private Configuration jConf;
    private File codeDir;
    private boolean isLocal;
    private boolean abort = false;
    private static SchemaTupleBackend stb;

    private SchemaTupleBackend(Configuration jConf, boolean isLocal) {
        if (isLocal) {
            String localCodeDir = jConf.get("pig.schematuple.local.dir");
            if (localCodeDir == null) {
                LOG.debug((Object)"No local code dir set in local mode. Aborting code gen resolution.");
                this.abort = true;
                return;
            }
            this.codeDir = new File(jConf.get("pig.schematuple.local.dir"));
        } else {
            this.codeDir = Files.createTempDir();
            this.codeDir.deleteOnExit();
        }
        try {
            this.classLoader = new URLClassLoader(new URL[]{this.codeDir.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to make URLClassLoader for tempDir: " + this.codeDir.getAbsolutePath());
        }
        this.jConf = jConf;
        this.isLocal = isLocal;
    }

    private SchemaTupleFactory internalNewSchemaTupleFactory(Schema s, boolean isAppendable, SchemaTupleClassGenerator.GenContext context) {
        return this.newSchemaTupleFactory(StructuresHelper.Triple.make(new StructuresHelper.SchemaKey(s), isAppendable, context));
    }

    private SchemaTupleFactory internalNewSchemaTupleFactory(int id) {
        SchemaTupleFactory stf = this.schemaTupleFactoriesById.get(id);
        if (stf == null) {
            LOG.debug((Object)("No SchemaTupleFactory present for given identifier: " + id));
        }
        return stf;
    }

    private SchemaTupleFactory newSchemaTupleFactory(StructuresHelper.Triple<StructuresHelper.SchemaKey, Boolean, SchemaTupleClassGenerator.GenContext> trip) {
        SchemaTupleFactory stf = this.schemaTupleFactoriesByTriple.get(trip);
        if (stf == null) {
            LOG.debug((Object)("No SchemaTupleFactory present for given SchemaKey/Boolean/Context combination " + trip));
        }
        return stf;
    }

    private void copyAndResolve() throws IOException {
        if (this.abort) {
            LOG.debug((Object)"Nothing to resolve on the backend.");
            return;
        }
        if (!this.jConf.getBoolean("pig.schematuple", false)) {
            LOG.info((Object)"Key [pig.schematuple] was not set... will not generate code.");
            return;
        }
        if (!this.isLocal) {
            this.copyAllFromDistributedCache();
        }
        for (File f : this.codeDir.listFiles()) {
            String name = f.getName().split("\\.")[0];
            if (name.contains("$")) continue;
            this.filesToResolve.add(name);
            LOG.info((Object)("Added class to list of class to resolve: " + name));
        }
        this.resolveClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAllFromDistributedCache() throws IOException {
        String toDeserialize = this.jConf.get("pig.schematuple.classes");
        if (toDeserialize == null) {
            LOG.info((Object)"No classes in in key [pig.schematuple.classes] to copy from distributed cache.");
            return;
        }
        LOG.info((Object)("Copying files in key [pig.schematuple.classes] from distributed cache: " + toDeserialize));
        for (String s : toDeserialize.split(",")) {
            LOG.info((Object)("Attempting to read file: " + s));
            File src = new File(s);
            FileInputStream fin = null;
            FileOutputStream fos = null;
            try {
                fin = new FileInputStream(src);
                fos = new FileOutputStream(new File(this.codeDir, s));
                fin.getChannel().transferTo(0L, src.length(), fos.getChannel());
                LOG.info((Object)"Successfully copied file to local directory.");
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    private void resolveClasses() {
        for (String s : this.filesToResolve) {
            SchemaTuple st;
            Class<SchemaTuple<?>> clazz;
            SchemaTupleFactory.LOG.info((Object)("Attempting to resolve class: " + s));
            try {
                clazz = this.classLoader.loadClass(s);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to find class: " + s, e);
            }
            if (!SchemaTuple.class.isAssignableFrom(clazz)) {
                return;
            }
            Class<SchemaTuple<?>> stClass = clazz;
            try {
                st = (SchemaTuple)stClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error instantiating file: " + s, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing file: " + s, e);
            }
            boolean isAppendable = st instanceof AppendableSchemaTuple;
            int id = st.getSchemaTupleIdentifier();
            Schema schema = st.getSchema();
            SchemaTupleFactory stf = new SchemaTupleFactory(stClass, st.getQuickGenerator());
            for (SchemaTupleClassGenerator.GenContext context : SchemaTupleClassGenerator.GenContext.values()) {
                if (context != SchemaTupleClassGenerator.GenContext.FORCE_LOAD && !context.shouldGenerate(stClass)) {
                    SchemaTupleFactory.LOG.debug((Object)("Context [" + (Object)((Object)context) + "] not present for class, skipping."));
                    continue;
                }
                StructuresHelper.Triple<StructuresHelper.SchemaKey, Boolean, SchemaTupleClassGenerator.GenContext> trip = StructuresHelper.Triple.make(new StructuresHelper.SchemaKey(schema), isAppendable, context);
                this.schemaTupleFactoriesByTriple.put(trip, stf);
                SchemaTupleFactory.LOG.info((Object)("Successfully resolved class for schema [" + schema + "] and appendability [" + isAppendable + "]" + " in context: " + (Object)((Object)context)));
            }
            this.schemaTupleFactoriesById.put(id, stf);
        }
    }

    public static void reset() {
        stb = null;
    }

    public static void initialize(Configuration jConf, PigContext pigContext) throws IOException {
        if (stb != null) {
            SchemaTupleFrontend.lazyReset(pigContext);
        }
        SchemaTupleBackend.initialize(jConf, pigContext.getExecType().isLocal());
    }

    public static void initialize(Configuration jConf) throws IOException {
        SchemaTupleBackend.initialize(jConf, Utils.isLocal(jConf));
    }

    public static void initialize(Configuration jConf, boolean isLocal) throws IOException {
        if (stb != null) {
            LOG.warn((Object)"SchemaTupleBackend has already been initialized");
        } else {
            SchemaTupleFrontend.reset();
            SchemaTupleBackend stbInstance = new SchemaTupleBackend(jConf, isLocal);
            stbInstance.copyAndResolve();
            stb = stbInstance;
        }
    }

    public static SchemaTupleFactory newSchemaTupleFactory(Schema s, boolean isAppendable, SchemaTupleClassGenerator.GenContext context) {
        if (stb == null) {
            throw new RuntimeException("initialize was not called! Even when SchemaTuple feature is not set, it should be called.");
        }
        return stb.internalNewSchemaTupleFactory(s, isAppendable, context);
    }

    protected static SchemaTupleFactory newSchemaTupleFactory(int id) {
        if (stb == null) {
            throw new RuntimeException("initialize was not called! Even when SchemaTuple feature is not set, it should be called.");
        }
        return stb.internalNewSchemaTupleFactory(id);
    }
}

