/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.examples;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.examples.custommodel.v25.message.ZDT_A01;
import ca.uhn.hl7v2.examples.custommodel.v25.segment.ZPI;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.v25.message.ADT_A01;
import ca.uhn.hl7v2.parser.CustomModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;

public class CustomModelClasses {
    public static void main(String[] args) throws HL7Exception {
        String messageText = "MSH|^~\\&|IRIS|SANTER|AMB_R|SANTER|200803051508||ADT^A01|263206|P|2.5\rEVN||200803051509||||200803031508\rPID|||5520255^^^PK^PK~ZZZZZZ83M64Z148R^^^CF^CF~ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103^99991231~^^^^TEAM||ZZZ^ZZZ||19830824|F||||||||||||||||||||||N\rZPI|Fido~Fred|13\rPV1||I|6402DH^^^^^^^^MED. 1 - ONCOLOGIA^^OSPEDALE MAGGIORE DI LODI&LODI|||^^^^^^^^^^OSPEDALE MAGGIORE DI LODI&LODI|13936^TEST^TEST||||||||||5068^TEST2^TEST2||2008003369||||||||||||||||||||||||||200803031508\rPR1|1||1111^Mastoplastica|Protesi|20090224|02|";
        ADT_A01 message = (ADT_A01)new PipeParser().parse(messageText);
        Segment zpiGenericSegment = (Segment)message.get("ZPI");
        String firstPetName = zpiGenericSegment.getField(1, 0).encode();
        String secondPetName = zpiGenericSegment.getField(1, 1).encode();
        System.out.println(firstPetName);
        System.out.println(secondPetName);
        String shoeSize = zpiGenericSegment.getField(2, 0).encode();
        System.out.println(shoeSize);
        CustomModelClassFactory cmf = new CustomModelClassFactory("ca.uhn.hl7v2.examples.custommodel");
        PipeParser parser = new PipeParser((ModelClassFactory)cmf);
        messageText = "MSH|^~\\&|IRIS|SANTER|AMB_R|SANTER|200803051508||ZDT^A01|263206|P|2.5\rEVN||200803051509||||200803031508\rPID|||5520255^^^PK^PK~ZZZZZZ83M64Z148R^^^CF^CF~ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103^99991231~^^^^TEAM||ZZZ^ZZZ||19830824|F||||||||||||||||||||||N\rZPI|Fido~Fred|13\rPV1||I|6402DH^^^^^^^^MED. 1 - ONCOLOGIA^^OSPEDALE MAGGIORE DI LODI&LODI|||^^^^^^^^^^OSPEDALE MAGGIORE DI LODI&LODI|13936^TEST^TEST||||||||||5068^TEST2^TEST2||2008003369||||||||||||||||||||||||||200803031508\rPR1|1||1111^Mastoplastica|Protesi|20090224|02|";
        ZDT_A01 zdtA01 = (ZDT_A01)parser.parse(messageText);
        ZPI zpi = zdtA01.getZPI();
        System.out.println(zpi.getPetName()[0].encode());
        System.out.println(zpi.getPetName()[1].encode());
        System.out.println(zpi.getShoeSize().encode());
    }
}

