/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.lmax.disruptor.RingBuffer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.management.MemoryType;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.RingBufferTruck;
import org.apache.hadoop.hbase.regionserver.wal.SequenceIdAccounting;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALPrettyPrinter;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.htrace.core.TraceScope;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractFSWAL<W extends WALProvider.WriterBase>
implements WAL {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSWAL.class);
    protected static final int DEFAULT_SLOW_SYNC_TIME_MS = 100;
    private static final int DEFAULT_WAL_SYNC_TIMEOUT_MS = 300000;
    protected final FileSystem fs;
    protected final Path walDir;
    protected final Path walArchiveDir;
    protected final PathFilter ourFiles;
    protected final String walFilePrefix;
    protected final String walFileSuffix;
    protected final String prefixPathStr;
    protected final WALCoprocessorHost coprocessorHost;
    protected final Configuration conf;
    protected final List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    protected final SequenceIdAccounting sequenceIdAccounting = new SequenceIdAccounting();
    protected final long slowSyncNs;
    private final long walSyncTimeoutNs;
    protected final long logrollsize;
    protected final long blocksize;
    protected final int maxLogs;
    protected final ReentrantLock rollWriterLock = new ReentrantLock(true);
    protected final AtomicLong filenum = new AtomicLong(-1L);
    protected final AtomicInteger numEntries = new AtomicInteger(0);
    protected volatile long highestUnsyncedTxid = -1L;
    protected final AtomicLong highestSyncedTxid = new AtomicLong(0L);
    protected final AtomicLong totalLogSize = new AtomicLong(0L);
    volatile W writer;
    private long lastTimeCheckLowReplication = EnvironmentEdgeManager.currentTime();
    protected volatile boolean closed = false;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    final Comparator<Path> LOG_NAME_COMPARATOR = (o1, o2) -> Long.compare(this.getFileNumFromFileName((Path)o1), this.getFileNumFromFileName((Path)o2));
    protected ConcurrentNavigableMap<Path, WalProps> walFile2Props = new ConcurrentSkipListMap<Path, WalProps>(this.LOG_NAME_COMPARATOR);
    private final ConcurrentMap<Thread, SyncFuture> syncFuturesByHandler;
    protected final String implClassName;

    public long getFilenum() {
        return this.filenum.get();
    }

    protected long getFileNumFromFileName(Path fileName) {
        Preconditions.checkNotNull((Object)fileName, (Object)"file name can't be null");
        if (!this.ourFiles.accept(fileName)) {
            throw new IllegalArgumentException("The log file " + fileName + " doesn't belong to this WAL. (" + this.toString() + ")");
        }
        String fileNameString = fileName.toString();
        String chompedPath = fileNameString.substring(this.prefixPathStr.length(), fileNameString.length() - this.walFileSuffix.length());
        return Long.parseLong(chompedPath);
    }

    private int calculateMaxLogFiles(Configuration conf, long logRollSize) {
        Pair<Long, MemoryType> globalMemstoreSize = MemorySizeUtil.getGlobalMemStoreSize(conf);
        return (int)((Long)globalMemstoreSize.getFirst() * 2L / logRollSize);
    }

    protected final int getPreallocatedEventCount() {
        int preallocatedEventCount = this.conf.getInt("hbase.regionserver.wal.disruptor.event.count", 16384);
        Preconditions.checkArgument((preallocatedEventCount >= 0 ? 1 : 0) != 0, (Object)"hbase.regionserver.wal.disruptor.event.count must > 0");
        int floor = Integer.highestOneBit(preallocatedEventCount);
        if (floor == preallocatedEventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    protected AbstractFSWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws FailedLogCloseException, IOException {
        boolean maxLogsDefined;
        FileStatus[] walFiles;
        this.fs = fs;
        this.walDir = new Path(rootDir, logDir);
        this.walArchiveDir = new Path(rootDir, archiveDir);
        this.conf = conf;
        if (!fs.exists(this.walDir) && !fs.mkdirs(this.walDir)) {
            throw new IOException("Unable to mkdir " + this.walDir);
        }
        if (!fs.exists(this.walArchiveDir) && !fs.mkdirs(this.walArchiveDir)) {
            throw new IOException("Unable to mkdir " + this.walArchiveDir);
        }
        String string = this.walFilePrefix = prefix == null || prefix.isEmpty() ? "wal" : URLEncoder.encode(prefix, "UTF8");
        if (suffix != null && !suffix.isEmpty() && !suffix.startsWith(".")) {
            throw new IllegalArgumentException("WAL suffix must start with '.' but instead was '" + suffix + "'");
        }
        CommonFSUtils.setStoragePolicy((FileSystem)fs, (Configuration)conf, (Path)this.walDir, (String)"hbase.wal.storage.policy", (String)"HOT");
        this.walFileSuffix = suffix == null ? "" : URLEncoder.encode(suffix, "UTF8");
        this.prefixPathStr = new Path(this.walDir, this.walFilePrefix + ".").toString();
        this.ourFiles = new PathFilter(){

            public boolean accept(Path fileName) {
                String fileNameString = fileName.toString();
                if (!fileNameString.startsWith(AbstractFSWAL.this.prefixPathStr)) {
                    return false;
                }
                if (AbstractFSWAL.this.walFileSuffix.isEmpty()) {
                    return org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)fileNameString.substring(AbstractFSWAL.this.prefixPathStr.length()));
                }
                return fileNameString.endsWith(AbstractFSWAL.this.walFileSuffix);
            }
        };
        if (failIfWALExists && null != (walFiles = CommonFSUtils.listStatus((FileSystem)fs, (Path)this.walDir, (PathFilter)this.ourFiles)) && 0 != walFiles.length) {
            throw new IOException("Target WAL already exists within directory " + this.walDir);
        }
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
        this.blocksize = WALUtil.getWALBlockSize(this.conf, this.fs, this.walDir);
        float multiplier = conf.getFloat("hbase.regionserver.logroll.multiplier", 0.5f);
        this.logrollsize = (long)((float)this.blocksize * multiplier);
        boolean bl = maxLogsDefined = conf.get("hbase.regionserver.maxlogs") != null;
        if (maxLogsDefined) {
            LOG.warn("'hbase.regionserver.maxlogs' was deprecated.");
        }
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", Math.max(32, this.calculateMaxLogFiles(conf, this.logrollsize)));
        LOG.info("WAL configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", prefix=" + this.walFilePrefix + ", suffix=" + this.walFileSuffix + ", logDir=" + this.walDir + ", archiveDir=" + this.walArchiveDir);
        this.slowSyncNs = TimeUnit.MILLISECONDS.toNanos(conf.getInt("hbase.regionserver.hlog.slowsync.ms", 100));
        this.walSyncTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.regionserver.hlog.sync.timeout", 300000L));
        int maxHandlersCount = conf.getInt("hbase.regionserver.handler.count", 200);
        this.syncFuturesByHandler = new ConcurrentHashMap<Thread, SyncFuture>(maxHandlersCount);
        this.implClassName = this.getClass().getSimpleName();
    }

    @Override
    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> families) {
        return this.sequenceIdAccounting.startCacheFlush(encodedRegionName, families);
    }

    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Map<byte[], Long> familyToSeq) {
        return this.sequenceIdAccounting.startCacheFlush(encodedRegionName, familyToSeq);
    }

    @Override
    public void completeCacheFlush(byte[] encodedRegionName) {
        this.sequenceIdAccounting.completeCacheFlush(encodedRegionName);
    }

    @Override
    public void abortCacheFlush(byte[] encodedRegionName) {
        this.sequenceIdAccounting.abortCacheFlush(encodedRegionName);
    }

    @Override
    public long getEarliestMemStoreSeqNum(byte[] encodedRegionName) {
        return this.sequenceIdAccounting.getLowestSequenceId(encodedRegionName);
    }

    @Override
    public long getEarliestMemStoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
        return this.sequenceIdAccounting.getLowestSequenceId(encodedRegionName, familyName);
    }

    @Override
    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("WAL file number can't be < 0");
        }
        String child = this.walFilePrefix + "." + filenum + this.walFileSuffix;
        return new Path(this.walDir, child);
    }

    public Path getCurrentFileName() {
        return this.computeFilename(this.filenum.get());
    }

    private Path getNewPath() throws IOException {
        this.filenum.set(System.currentTimeMillis());
        Path newPath = this.getCurrentFileName();
        while (this.fs.exists(newPath)) {
            this.filenum.incrementAndGet();
            newPath = this.getCurrentFileName();
        }
        return newPath;
    }

    @VisibleForTesting
    Path getOldPath() {
        long currentFilenum = this.filenum.get();
        Path oldPath = null;
        if (currentFilenum > 0L) {
            oldPath = this.computeFilename(currentFilenum);
        }
        return oldPath;
    }

    private void tellListenersAboutPreLogRoll(Path oldPath, Path newPath) throws IOException {
        this.coprocessorHost.preWALRoll(oldPath, newPath);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogRoll(oldPath, newPath);
            }
        }
    }

    private void tellListenersAboutPostLogRoll(Path oldPath, Path newPath) throws IOException {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogRoll(oldPath, newPath);
            }
        }
        this.coprocessorHost.postWALRoll(oldPath, newPath);
    }

    public int getNumRolledLogFiles() {
        return this.walFile2Props.size();
    }

    public int getNumLogFiles() {
        return this.getNumRolledLogFiles() + 1;
    }

    byte[][] findRegionsToForceFlush() throws IOException {
        byte[][] regions = null;
        int logCount = this.getNumRolledLogFiles();
        if (logCount > this.maxLogs && logCount > 0) {
            Map.Entry firstWALEntry = this.walFile2Props.firstEntry();
            regions = this.sequenceIdAccounting.findLower(((WalProps)firstWALEntry.getValue()).encodedName2HighestSequenceId);
        }
        if (regions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toStringBinary((byte[])regions[i]));
            }
            LOG.info("Too many WALs; count=" + logCount + ", max=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString());
        }
        return regions;
    }

    private void cleanOldLogs() throws IOException {
        ArrayList<Pair> logsToArchive = null;
        for (Map.Entry e : this.walFile2Props.entrySet()) {
            Path log = (Path)e.getKey();
            Map<byte[], Long> sequenceNums = ((WalProps)e.getValue()).encodedName2HighestSequenceId;
            if (!this.sequenceIdAccounting.areAllLower(sequenceNums)) continue;
            if (logsToArchive == null) {
                logsToArchive = new ArrayList<Pair>();
            }
            logsToArchive.add(Pair.newPair((Object)log, (Object)((WalProps)e.getValue()).logSize));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("WAL file ready for archiving " + log);
        }
        if (logsToArchive != null) {
            for (Pair logAndSize : logsToArchive) {
                this.totalLogSize.addAndGet(-((Long)logAndSize.getSecond()).longValue());
                this.archiveLogFile((Path)logAndSize.getFirst());
                this.walFile2Props.remove(logAndSize.getFirst());
            }
        }
    }

    public static Path getWALArchivePath(Path archiveDir, Path p) {
        return new Path(archiveDir, p.getName());
    }

    private void archiveLogFile(Path p) throws IOException {
        Path newPath = AbstractFSWAL.getWALArchivePath(this.walArchiveDir, p);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        LOG.info("Archiving " + p + " to " + newPath);
        if (!CommonFSUtils.renameAndSetModifyTime((FileSystem)this.fs, (Path)p, (Path)newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected final void logRollAndSetupWalProps(Path oldPath, Path newPath, long oldFileLen) {
        String newPathString;
        int oldNumEntries = this.numEntries.getAndSet(0);
        String string = newPathString = newPath != null ? CommonFSUtils.getPath((Path)newPath) : null;
        if (oldPath != null) {
            this.walFile2Props.put(oldPath, new WalProps(this.sequenceIdAccounting.resetHighest(), oldFileLen));
            this.totalLogSize.addAndGet(oldFileLen);
            LOG.info("Rolled WAL {} with entries={}, filesize={}; new WAL {}", new Object[]{CommonFSUtils.getPath((Path)oldPath), oldNumEntries, StringUtils.byteDesc((long)oldFileLen), newPathString});
        } else {
            LOG.info("New WAL {}", (Object)newPathString);
        }
    }

    @VisibleForTesting
    Path replaceWriter(Path oldPath, Path newPath, W nextWriter) throws IOException {
        try (TraceScope scope = TraceUtil.createTrace((String)"FSHFile.replaceWriter");){
            this.doReplaceWriter(oldPath, newPath, nextWriter);
            Path path = newPath;
            return path;
        }
    }

    protected final void blockOnSync(SyncFuture syncFuture) throws IOException {
        try {
            if (syncFuture != null) {
                if (this.closed) {
                    throw new IOException("WAL has been closed");
                }
                syncFuture.get(this.walSyncTimeoutNs);
            }
        }
        catch (TimeoutIOException tioe) {
            this.syncFuturesByHandler.remove(Thread.currentThread());
            throw tioe;
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted", (Throwable)ie);
            throw this.convertInterruptedExceptionToIOException(ie);
        }
        catch (ExecutionException e) {
            throw AbstractFSWAL.ensureIOException(e.getCause());
        }
    }

    private static IOException ensureIOException(Throwable t) {
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    private IOException convertInterruptedExceptionToIOException(InterruptedException ie) {
        Thread.currentThread().interrupt();
        InterruptedIOException ioe = new InterruptedIOException();
        ioe.initCause(ie);
        return ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
        this.rollWriterLock.lock();
        try {
            if (!force && this.writer != null && this.numEntries.get() <= 0) {
                byte[][] byArray = null;
                return byArray;
            }
            byte[][] regionsToFlush = null;
            if (this.closed) {
                LOG.debug("WAL closed. Skipping rolling of writer");
                byte[][] byArray = regionsToFlush;
                return byArray;
            }
            try (TraceScope scope = TraceUtil.createTrace((String)"FSHLog.rollWriter");){
                Path oldPath = this.getOldPath();
                Path newPath = this.getNewPath();
                W nextWriter = this.createWriterInstance(newPath);
                this.tellListenersAboutPreLogRoll(oldPath, newPath);
                newPath = this.replaceWriter(oldPath, newPath, nextWriter);
                this.tellListenersAboutPostLogRoll(oldPath, newPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Create new " + this.implClassName + " writer with pipeline: " + Arrays.toString(this.getPipeline()));
                }
                if (this.getNumRolledLogFiles() > 0) {
                    this.cleanOldLogs();
                    regionsToFlush = this.findRegionsToForceFlush();
                }
            }
            catch (CommonFSUtils.StreamLacksCapabilityException exception) {
                throw new IOException("Underlying FileSystem can't meet stream requirements. See RS log for details.", exception);
            }
            byte[][] byArray = regionsToFlush;
            return byArray;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    public long getLogFileSize() {
        return this.totalLogSize.get();
    }

    public void requestLogRoll() {
        this.requestLogRoll(false);
    }

    @VisibleForTesting
    FileStatus[] getFiles() throws IOException {
        return CommonFSUtils.listStatus((FileSystem)this.fs, (Path)this.walDir, (PathFilter)this.ourFiles);
    }

    @Override
    public void shutdown() throws IOException {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.closed = true;
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logCloseRequested();
            }
        }
        this.rollWriterLock.lock();
        try {
            this.doShutdown();
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
        FileStatus[] files = this.getFiles();
        if (null != files && 0 != files.length) {
            for (FileStatus file : files) {
                Path p = AbstractFSWAL.getWALArchivePath(this.walArchiveDir, file.getPath());
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogArchive(file.getPath(), p);
                    }
                }
                if (!CommonFSUtils.renameAndSetModifyTime((FileSystem)this.fs, (Path)file.getPath(), (Path)p)) {
                    throw new IOException("Unable to rename " + file.getPath() + " to " + p);
                }
                if (this.listeners.isEmpty()) continue;
                for (WALActionsListener i : this.listeners) {
                    i.postLogArchive(file.getPath(), p);
                }
            }
            LOG.debug("Moved " + files.length + " WAL file(s) to " + CommonFSUtils.getPath((Path)this.walArchiveDir));
        }
        LOG.info("Closed WAL: " + this.toString());
    }

    @Override
    public void updateStore(byte[] encodedRegionName, byte[] familyName, Long sequenceid, boolean onlyIfGreater) {
        this.sequenceIdAccounting.updateStore(encodedRegionName, familyName, sequenceid, onlyIfGreater);
    }

    protected final SyncFuture getSyncFuture(long sequence) {
        return ((SyncFuture)CollectionUtils.computeIfAbsent(this.syncFuturesByHandler, (Object)Thread.currentThread(), SyncFuture::new)).reset(sequence);
    }

    protected final void requestLogRoll(boolean tooFewReplicas) {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested(tooFewReplicas);
            }
        }
    }

    long getUnflushedEntriesCount() {
        long highestUnsynced;
        long highestSynced = this.highestSyncedTxid.get();
        return highestSynced >= (highestUnsynced = this.highestUnsyncedTxid) ? 0L : highestUnsynced - highestSynced;
    }

    boolean isUnflushedEntries() {
        return this.getUnflushedEntriesCount() > 0L;
    }

    @VisibleForTesting
    void atHeadOfRingBufferEventHandlerAppend() {
    }

    protected final boolean append(W writer, FSWALEntry entry) throws IOException {
        this.atHeadOfRingBufferEventHandlerAppend();
        long start = EnvironmentEdgeManager.currentTime();
        byte[] encodedRegionName = entry.getKey().getEncodedRegionName();
        long regionSequenceId = entry.getKey().getSequenceId();
        if (entry.getEdit().isEmpty()) {
            return false;
        }
        this.coprocessorHost.preWALWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.visitLogEntryBeforeWrite(entry.getKey(), entry.getEdit());
            }
        }
        this.doAppend(writer, entry);
        assert (this.highestUnsyncedTxid < entry.getTxid());
        this.highestUnsyncedTxid = entry.getTxid();
        this.sequenceIdAccounting.update(encodedRegionName, entry.getFamilyNames(), regionSequenceId, entry.isInMemStore());
        this.coprocessorHost.postWALWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
        this.postAppend(entry, EnvironmentEdgeManager.currentTime() - start);
        this.numEntries.incrementAndGet();
        return true;
    }

    private long postAppend(WAL.Entry e, long elapsedTime) throws IOException {
        long len = 0L;
        if (!this.listeners.isEmpty()) {
            for (Cell cell : e.getEdit().getCells()) {
                len += (long)PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            for (WALActionsListener listener : this.listeners) {
                listener.postAppend(len, elapsedTime, e.getKey(), e.getEdit());
            }
        }
        return len;
    }

    protected final void postSync(long timeInNanos, int handlerSyncs) {
        if (timeInNanos > this.slowSyncNs) {
            String msg = "Slow sync cost: " + timeInNanos / 1000000L + " ms, current pipeline: " + Arrays.toString(this.getPipeline());
            TraceUtil.addTimelineAnnotation((String)msg);
            LOG.info(msg);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener listener : this.listeners) {
                listener.postSync(timeInNanos, handlerSyncs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long stampSequenceIdAndPublishToRingBuffer(RegionInfo hri, WALKeyImpl key, WALEdit edits, boolean inMemstore, RingBuffer<RingBufferTruck> ringBuffer) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed, regionName = " + hri.getRegionNameAsString());
        }
        MutableLong txidHolder = new MutableLong();
        MultiVersionConcurrencyControl.WriteEntry we = key.getMvcc().begin(() -> txidHolder.setValue(ringBuffer.next()));
        long txid = txidHolder.longValue();
        try (TraceScope scope = TraceUtil.createTrace((String)(this.implClassName + ".append"));){
            FSWALEntry entry = new FSWALEntry(txid, key, edits, hri, inMemstore);
            entry.stampRegionSequenceId(we);
            ((RingBufferTruck)ringBuffer.get(txid)).load(entry);
        }
        finally {
            ringBuffer.publish(txid);
        }
        return txid;
    }

    @Override
    public String toString() {
        return this.implClassName + " " + this.walFilePrefix + ":" + this.walFileSuffix + "(num " + this.filenum + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalLong getLogFileSizeIfBeingWritten(Path path) {
        this.rollWriterLock.lock();
        try {
            Path currentPath = this.getOldPath();
            if (path.equals((Object)currentPath)) {
                W writer = this.writer;
                OptionalLong optionalLong = writer != null ? OptionalLong.of(writer.getLength()) : OptionalLong.empty();
                return optionalLong;
            }
            OptionalLong optionalLong = OptionalLong.empty();
            return optionalLong;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @Override
    public abstract long append(RegionInfo var1, WALKeyImpl var2, WALEdit var3, boolean var4) throws IOException;

    protected abstract void doAppend(W var1, FSWALEntry var2) throws IOException;

    protected abstract W createWriterInstance(Path var1) throws IOException, CommonFSUtils.StreamLacksCapabilityException;

    protected abstract void doReplaceWriter(Path var1, Path var2, W var3) throws IOException;

    protected abstract void doShutdown() throws IOException;

    protected abstract boolean doCheckLogLowReplication();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLogLowReplication(long checkInterval) {
        long now = EnvironmentEdgeManager.currentTime();
        if (now - this.lastTimeCheckLowReplication < checkInterval) {
            return;
        }
        if (!this.rollWriterLock.tryLock()) {
            return;
        }
        try {
            this.lastTimeCheckLowReplication = now;
            if (this.doCheckLogLowReplication()) {
                this.requestLogRoll(true);
            }
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @VisibleForTesting
    abstract DatanodeInfo[] getPipeline();

    @VisibleForTesting
    abstract int getLogReplication();

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FSUtils.getWALFileSystem((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDirectory()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = FSUtils.getWALRootDir((Configuration)conf);
        Path archiveDir = new Path(baseDir, "oldWALs");
        if (conf.getBoolean("hbase.separate.oldlogdir.by.regionserver", false)) {
            archiveDir = new Path(archiveDir, p.getName());
        }
        WALSplitter.split(baseDir, p, archiveDir, fs, conf, WALFactory.getInstance(conf));
    }

    private static void usage() {
        System.err.println("Usage: AbstractFSWAL <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: AbstractFSWAL --dump hdfs://example.com:9000/hbase/WALs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: AbstractFSWAL --split hdfs://example.com:9000/hbase/WALs/DIR");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            AbstractFSWAL.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            WALPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--perf") == 0) {
            LOG.error(HBaseMarkers.FATAL, "Please use the WALPerformanceEvaluation tool instead. i.e.:");
            LOG.error(HBaseMarkers.FATAL, "\thbase org.apache.hadoop.hbase.wal.WALPerformanceEvaluation --iterations " + args[1]);
            System.exit(-1);
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Path logPath = new Path(args[i]);
                    FSUtils.setFsDefault((Configuration)conf, (Path)logPath);
                    AbstractFSWAL.split(conf, logPath);
                    continue;
                }
                catch (IOException t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            AbstractFSWAL.usage();
            System.exit(-1);
        }
    }

    private static final class WalProps {
        public final Map<byte[], Long> encodedName2HighestSequenceId;
        public final long logSize;

        public WalProps(Map<byte[], Long> encodedName2HighestSequenceId, long logSize) {
            this.encodedName2HighestSequenceId = encodedName2HighestSequenceId;
            this.logSize = logSize;
        }
    }
}

