/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischargeHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompactedHFilesDischarger
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(CompactedHFilesDischarger.class);
    private RegionServerServices regionServerServices;
    @VisibleForTesting
    private boolean useExecutor = true;

    public CompactedHFilesDischarger(int period, Stoppable stopper, RegionServerServices regionServerServices) {
        super("CompactedHFilesCleaner", stopper, period);
        this.regionServerServices = regionServerServices;
    }

    @VisibleForTesting
    public CompactedHFilesDischarger(int period, Stoppable stopper, RegionServerServices regionServerServices, boolean useExecutor) {
        this(period, stopper, regionServerServices);
        this.useExecutor = useExecutor;
    }

    @VisibleForTesting
    boolean setUseExecutor(boolean useExecutor) {
        boolean oldSetting = this.useExecutor;
        this.useExecutor = useExecutor;
        return oldSetting;
    }

    public void chore() {
        if (this.regionServerServices == null) {
            return;
        }
        List onlineRegions = this.regionServerServices.getRegions();
        if (onlineRegions == null) {
            return;
        }
        for (HRegion region : onlineRegions) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Started compacted hfiles cleaner on " + region.getRegionInfo());
            }
            for (HStore store : region.getStores()) {
                try {
                    if (this.useExecutor && this.regionServerServices != null) {
                        CompactedHFilesDischargeHandler handler = new CompactedHFilesDischargeHandler(this.regionServerServices, EventType.RS_COMPACTED_FILES_DISCHARGER, store);
                        this.regionServerServices.getExecutorService().submit(handler);
                    } else {
                        store.closeAndArchiveCompactedFiles();
                    }
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Completed archiving the compacted files for the region " + region.getRegionInfo() + " under the store " + store.getColumnFamilyName());
                }
                catch (Exception e) {
                    LOG.error("Exception while trying to close and archive the compacted store files of the store  " + store.getColumnFamilyName() + " in the" + " region " + region.getRegionInfo(), (Throwable)e);
                }
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Completed the compacted hfiles cleaner for the region " + region.getRegionInfo());
        }
    }
}

