/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.metrics.MetricsUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestCallback;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestLogBrowser;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestMetrics;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestResults;
import org.pentaho.di.trans.dataservice.ui.controller.DataServiceTestController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceTestModel;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class DataServiceTestDialog
implements Serializable {
    public static Class<?> PKG = DataServiceTestDialog.class;
    private static final String XUL_PATH = "org/pentaho/di/trans/dataservice/ui/xul/dataservice-test-dialog.xul";
    private static final String XUL_DIALOG_ID = "dataservice-test-dialog";
    private static final String GENTRANS_LOG_XUL_ID = "genTrans-log-tab";
    private static final String GENTRANS_METRICS_XUL_ID = "genTrans-metrics-tab";
    private static final String SVCTRANS_LOG_XUL_ID = "serviceTrans-log-tab";
    private static final String SVCTRANS_METRICS_XUL_ID = "serviceTrans-metrics-tab";
    private static final String QUERY_RESULTS_XUL_ID = "results-tab";
    private final DataServiceTestModel model = new DataServiceTestModel();
    private final DataServiceTestController dataServiceTestController;
    private final DataServiceTestResults resultsView;
    private final DataServiceTestLogBrowser serviceTransLogBrowser;
    private final DataServiceTestLogBrowser genTransLogBrowser;
    private final DataServiceTestMetrics serviceTransMetrics;
    private final DataServiceTestMetrics genTransMetrics;
    private final Document xulDocument;
    private final SwtDialog dialog;
    private static final Class<?> CLZ = DataServiceTestDialog.class;
    private final ResourceBundle resourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)CLZ, (String)key, (String[])new String[0]);
        }
    };

    public DataServiceTestDialog(Shell parent, DataServiceMeta dataService, DataServiceContext context) throws KettleException {
        CTabFolder tabFolder;
        try {
            this.dataServiceTestController = new DataServiceTestController(this.model, dataService, context);
        }
        catch (KettleException ke) {
            new ErrorDialog(parent, BaseMessages.getString(PKG, (String)"DataServiceTest.TestDataServiceError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataServiceTest.TestDataServiceError.Message", (String[])new String[0]), (Exception)((Object)ke));
            throw ke;
        }
        this.xulDocument = this.initXul((Composite)parent);
        this.resultsView = this.initDataServiceResultsView(dataService);
        this.serviceTransLogBrowser = new DataServiceTestLogBrowser(this.getComposite(SVCTRANS_LOG_XUL_ID));
        this.serviceTransMetrics = new DataServiceTestMetrics(this.getComposite(SVCTRANS_METRICS_XUL_ID));
        this.genTransLogBrowser = new DataServiceTestLogBrowser(this.getComposite(GENTRANS_LOG_XUL_ID));
        this.genTransMetrics = new DataServiceTestMetrics(this.getComposite(GENTRANS_METRICS_XUL_ID));
        this.dialog = (SwtDialog)this.xulDocument.getElementById(XUL_DIALOG_ID);
        Text textbox = (Text)this.xulDocument.getElementById("sql-textbox").getManagedObject();
        if (textbox != null) {
            textbox.addListener(1, (Listener)new SqlKeyListener(this.dataServiceTestController, true));
        }
        if ((tabFolder = (CTabFolder)this.xulDocument.getElementById("tabbox").getManagedObject()) != null) {
            tabFolder.addListener(1, (Listener)new SqlKeyListener(this.dataServiceTestController, false));
        }
        this.attachCallback();
    }

    private Composite getComposite(String elementId) {
        return (Composite)this.xulDocument.getElementById(elementId).getManagedObject();
    }

    public void open() throws KettleException {
        this.dialog.show();
    }

    public void close() {
        this.genTransLogBrowser.dispose();
        this.genTransMetrics.dispose();
        this.serviceTransLogBrowser.dispose();
        this.serviceTransMetrics.dispose();
        this.dialog.dispose();
    }

    private DataServiceTestResults initDataServiceResultsView(DataServiceMeta dataService) throws KettleStepException {
        Composite results = this.getComposite(QUERY_RESULTS_XUL_ID);
        results.setLayout((Layout)new FillLayout());
        return new DataServiceTestResults(dataService, results);
    }

    private void attachCallback() {
        this.dataServiceTestController.setCallback(new DataServiceTestCallback(){

            @Override
            public void onExecuteComplete() {
                DataServiceTestDialog.this.resultsView.setRowMeta(DataServiceTestDialog.this.model.getResultRowMeta());
                DataServiceTestDialog.this.resultsView.load(DataServiceTestDialog.this.model.getResultRows(), new SqlKeyListener(DataServiceTestDialog.this.dataServiceTestController, false));
                this.updateMetrics();
            }

            @Override
            public void onLogChannelUpdate() {
                DataServiceTestDialog.this.updateLogChannel();
            }

            @Override
            public void onClose() {
                DataServiceTestDialog.this.close();
            }

            @Override
            public void onUpdate(List<Object[]> rows) {
                DataServiceTestDialog.this.resultsView.updateTableView(DataServiceTestDialog.this.model.getResultRows());
                this.updateMetrics();
            }

            private void updateMetrics() {
                List genTransMetrics = MetricsUtil.getAllDurations((String)DataServiceTestDialog.this.model.getGenTransLogChannel().getLogChannelId());
                DataServiceTestDialog.this.genTransMetrics.display(genTransMetrics);
                LogChannelInterface serviceTransLogChannel = DataServiceTestDialog.this.model.getServiceTransLogChannel();
                if (serviceTransLogChannel != null) {
                    DataServiceTestDialog.this.serviceTransMetrics.display(MetricsUtil.getAllDurations((String)serviceTransLogChannel.getLogChannelId()));
                }
            }
        });
    }

    private void updateLogChannel() {
        if (this.model.getServiceTransLogChannel() != null) {
            this.serviceTransLogBrowser.attachToLogBrowser(this.model.getServiceTransLogChannel());
        }
        if (this.model.getGenTransLogChannel() != null) {
            this.genTransLogBrowser.attachToLogBrowser(this.model.getGenTransLogChannel());
        }
    }

    private Document initXul(Composite parent) throws KettleException {
        try {
            KettleXulLoader swtLoader = new KettleXulLoader();
            swtLoader.setOuterContext((Object)parent);
            swtLoader.registerClassLoader((Object)this.getClass().getClassLoader());
            XulDomContainer container = swtLoader.loadXul(XUL_PATH, (Object)this.resourceBundle);
            container.addEventHandler((XulEventHandler)this.dataServiceTestController);
            SwtXulRunner runner = new SwtXulRunner();
            runner.addContainer(container);
            runner.initialize();
            return container.getDocumentRoot();
        }
        catch (XulException xulException) {
            throw new KettleException("Failed to initialize DataServicesTestDialog.", (Throwable)xulException);
        }
    }

    static class SqlKeyListener
    implements Listener {
        DataServiceTestController dataServiceTestController;
        boolean consume = false;

        public SqlKeyListener(DataServiceTestController dataServiceTestController, boolean consume) {
            this.dataServiceTestController = dataServiceTestController;
            this.consume = consume;
        }

        public void handleEvent(Event e) {
            if (e.keyCode == 13 && (e.stateMask & 0x40000) != 0 && this.dataServiceTestController != null) {
                try {
                    this.dataServiceTestController.executeSql();
                }
                catch (KettleException e1) {
                    e1.printStackTrace();
                }
                e.doit = !this.consume;
            }
        }
    }
}

