/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.parameters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.tools.parameters.ParseException;
import org.apache.pig.tools.parameters.PigFileParser;
import org.apache.pig.tools.parameters.PreprocessorContext;

public class ParameterSubstitutionPreprocessor {
    private PreprocessorContext pc;
    private final Log log = LogFactory.getLog(this.getClass());
    private PigFileParser pigParser;

    public ParameterSubstitutionPreprocessor(int limit) {
        this(new PreprocessorContext(limit));
    }

    public ParameterSubstitutionPreprocessor(PreprocessorContext pc) {
        this.pc = pc;
        Reader sr = null;
        this.pigParser = new PigFileParser(sr);
        this.pigParser.setContext(pc);
    }

    public void genSubstitutedFile(BufferedReader pigInput, Writer pigOutput) throws ParseException {
        String line = null;
        StringBuilder blder = new StringBuilder();
        try {
            while ((line = pigInput.readLine()) != null) {
                blder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
        pigInput = new BufferedReader(new StringReader(blder.toString()));
        this.parsePigFile(pigInput, pigOutput);
    }

    public void genSubstitutedFile(BufferedReader pigInput, Writer pigOutput, String[] params, String[] paramFiles) throws ParseException {
        try {
            this.pc.loadParamVal(params == null ? null : Arrays.asList(params), paramFiles == null ? null : Arrays.asList(paramFiles));
            this.genSubstitutedFile(pigInput, pigOutput);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void parsePigFile(BufferedReader in, Writer out) throws ParseException {
        this.pigParser.setOutputWriter(out);
        this.pigParser.ReInit(in);
        try {
            this.pigParser.Parse();
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            RuntimeException rte = new RuntimeException(e.getMessage(), e);
            throw rte;
        }
    }
}

