/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.ArrayList;
import java.util.List;

public class LinkPipe
extends AbstractPipe<Vertex, Vertex>
implements SideEffectPipe.LazySideEffectPipe<Vertex, Object> {
    private final Direction direction;
    private final String label;
    private AsPipe<?, Vertex> asPipe;
    private Vertex other;
    private Object sideEffect;

    private LinkPipe(Direction direction, String label) {
        this.direction = direction;
        this.label = label;
        if (direction.equals((Object)Direction.BOTH)) {
            this.sideEffect = new ArrayList();
        }
    }

    public LinkPipe(Direction direction, String label, Vertex other) {
        this(direction, label);
        this.other = other;
    }

    public LinkPipe(Direction direction, String label, AsPipe<?, Vertex> asPipe) {
        this(direction, label);
        this.asPipe = asPipe;
    }

    @Override
    public Object getSideEffect() {
        return this.sideEffect;
    }

    @Override
    protected Vertex processNextStart() {
        Edge edge;
        Vertex vertex = (Vertex)this.starts.next();
        if (null != this.asPipe) {
            this.other = this.asPipe.getCurrentEnd();
        }
        if (this.direction.equals((Object)Direction.BOTH)) {
            ((List)this.sideEffect).clear();
        }
        if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
            edge = this.other.addEdge(this.label, vertex);
            if (this.direction.equals((Object)Direction.BOTH)) {
                ((List)this.sideEffect).add(edge);
            } else {
                this.sideEffect = edge;
            }
        }
        if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
            edge = vertex.addEdge(this.label, this.other);
            if (this.direction.equals((Object)Direction.BOTH)) {
                ((List)this.sideEffect).add(edge);
            } else {
                this.sideEffect = edge;
            }
        }
        return vertex;
    }

    @Override
    public void reset() {
        super.reset();
        this.sideEffect = null;
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, this.direction.name(), this.label, null == this.asPipe ? this.other : this.asPipe.getName());
    }
}

