/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.mapreduce.JobBase;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.mapreduce.AvroInputFormat;
import org.apache.sqoop.mapreduce.AvroJob;
import org.apache.sqoop.mapreduce.AvroOutputFormat;
import org.apache.sqoop.mapreduce.ExportJobBase;
import org.apache.sqoop.mapreduce.MergeAvroMapper;
import org.apache.sqoop.mapreduce.MergeAvroReducer;
import org.apache.sqoop.mapreduce.MergeRecord;
import org.apache.sqoop.mapreduce.MergeRecordMapper;
import org.apache.sqoop.mapreduce.MergeReducer;
import org.apache.sqoop.mapreduce.MergeTextMapper;
import org.apache.sqoop.mapreduce.RawKeyTextOutputFormat;
import org.apache.sqoop.util.Jars;

public class MergeJob
extends JobBase {
    public static final String MERGE_OLD_PATH_KEY = "sqoop.merge.old.path";
    public static final String MERGE_NEW_PATH_KEY = "sqoop.merge.new.path";
    public static final String MERGE_KEY_COL_KEY = "sqoop.merge.key.col";
    public static final String MERGE_SQOOP_RECORD_KEY = "sqoop.merge.class";

    public MergeJob(SqoopOptions opts) {
        super(opts, null, null, null);
    }

    public boolean runMergeJob() throws IOException {
        Configuration conf = this.options.getConf();
        Job job = this.createJob(conf);
        String userClassName = this.options.getClassName();
        if (null == userClassName) {
            throw new IOException("Record class name not specified with --class-name.");
        }
        String existingJar = this.options.getExistingJarName();
        if (existingJar != null) {
            LOG.debug((Object)("Setting job jar to user-specified jar: " + existingJar));
            job.getConfiguration().set("mapred.jar", existingJar);
        } else {
            try {
                Class userClass = conf.getClassByName(userClassName);
                if (null != userClass) {
                    String userJar = Jars.getJarPathForClass(userClass);
                    LOG.debug((Object)("Setting job jar based on user class " + userClassName + ": " + userJar));
                    job.getConfiguration().set("mapred.jar", userJar);
                } else {
                    LOG.warn((Object)("Specified class " + userClassName + " is not in a jar. " + "MapReduce may not find the class"));
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
        }
        try {
            Path oldPath = new Path(this.options.getMergeOldPath());
            Path newPath = new Path(this.options.getMergeNewPath());
            Configuration jobConf = job.getConfiguration();
            FileSystem fs = FileSystem.get((Configuration)jobConf);
            oldPath = oldPath.makeQualified(fs);
            newPath = newPath.makeQualified(fs);
            this.propagateOptionsToJob(job);
            FileInputFormat.addInputPath((Job)job, (Path)oldPath);
            FileInputFormat.addInputPath((Job)job, (Path)newPath);
            jobConf.set(MERGE_OLD_PATH_KEY, oldPath.toString());
            jobConf.set(MERGE_NEW_PATH_KEY, newPath.toString());
            jobConf.set(MERGE_KEY_COL_KEY, this.options.getMergeKeyCol());
            jobConf.set(MERGE_SQOOP_RECORD_KEY, userClassName);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.options.getTargetDir()));
            ExportJobBase.FileType fileType = ExportJobBase.getFileType(jobConf, oldPath);
            switch (fileType) {
                case AVRO_DATA_FILE: {
                    this.configueAvroMergeJob(conf, job, oldPath, newPath);
                    break;
                }
                case SEQUENCE_FILE: {
                    job.setInputFormatClass(SequenceFileInputFormat.class);
                    job.setOutputFormatClass(SequenceFileOutputFormat.class);
                    job.setMapperClass(MergeRecordMapper.class);
                    job.setReducerClass(MergeReducer.class);
                    break;
                }
                default: {
                    job.setMapperClass(MergeTextMapper.class);
                    job.setOutputFormatClass(RawKeyTextOutputFormat.class);
                    job.setReducerClass(MergeReducer.class);
                }
            }
            jobConf.set("mapred.output.key.class", userClassName);
            job.setOutputValueClass(NullWritable.class);
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(MergeRecord.class);
            this.cacheJars(job, null);
            this.setJob(job);
            return this.runJob(job);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    private void configueAvroMergeJob(Configuration conf, Job job, Path oldPath, Path newPath) throws IOException {
        LOG.info((Object)"Trying to merge avro files");
        Schema oldPathSchema = AvroUtil.getAvroSchema(oldPath, conf);
        Schema newPathSchema = AvroUtil.getAvroSchema(newPath, conf);
        if (oldPathSchema == null || newPathSchema == null || !oldPathSchema.equals((Object)newPathSchema)) {
            throw new IOException("Invalid schema for input directories. Schema for old data: [" + oldPathSchema + "]. Schema for new data: [" + newPathSchema + "]");
        }
        LOG.debug((Object)("Avro Schema:" + oldPathSchema));
        job.setInputFormatClass(AvroInputFormat.class);
        job.setOutputFormatClass(AvroOutputFormat.class);
        job.setMapperClass(MergeAvroMapper.class);
        job.setReducerClass(MergeAvroReducer.class);
        AvroJob.setOutputSchema(job.getConfiguration(), oldPathSchema);
    }
}

