/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import org.pentaho.reporting.engine.classic.core.util.LongList;

public class LongSequence
extends LongList {
    private long fillValue;

    public LongSequence(int capacity, long fillValue) {
        super(capacity);
        this.fillValue = fillValue;
    }

    public void increment(int position) {
        if (position < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position >= this.size()) {
            this.fillSequence(position + 1);
        }
        long oldValue = this.get(position);
        this.set(position, oldValue + 1L);
    }

    private void fillSequence(int targetSize) {
        while (this.size() < targetSize) {
            this.add(this.fillValue);
        }
    }

    @Override
    public long get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.size()) {
            return 0L;
        }
        return super.get(index);
    }

    @Override
    public void set(int position, long value) {
        if (position < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position >= this.size()) {
            this.fillSequence(position + 1);
        }
        super.set(position, value);
    }

    @Override
    public void fill(long value) {
        super.fill(value);
    }
}

