/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.css.DefaultDocumentContext;
import org.pentaho.reporting.engine.classic.core.style.css.DocumentContext;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleRule;
import org.pentaho.reporting.engine.classic.core.style.css.SimpleStyleRuleMatcher;
import org.pentaho.reporting.engine.classic.core.style.css.StyleRuleMatcher;
import org.pentaho.reporting.engine.classic.core.style.css.StyleSheetParserUtil;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.selector.SelectorWeight;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;
import org.pentaho.reporting.engine.classic.core.style.resolver.StyleResolver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CSSStyleResolver
implements StyleResolver,
Cloneable {
    private static final Log logger = LogFactory.getLog(CSSStyleResolver.class);
    private StyleRuleMatcher styleRuleMatcher;
    private DocumentContext documentContext;
    private NamespaceCollection namespaces;
    private SimpleStyleResolver simpleStyleResolver;

    public CSSStyleResolver() {
        this(false);
    }

    public CSSStyleResolver(boolean designTime) {
        this.simpleStyleResolver = new SimpleStyleResolver(designTime);
    }

    public static StyleResolver createDesignTimeResolver(ReportDefinition report, ResourceManager resourceManager, ResourceKey contentBase, boolean designTime) {
        ElementStyleDefinition styleDefinition = CSSStyleResolver.createStyleDefinition(report, resourceManager, contentBase);
        if (styleDefinition.getRuleCount() == 0 && styleDefinition.getStyleSheetCount() == 0) {
            return new SimpleStyleResolver(designTime);
        }
        CSSStyleResolver resolver = new CSSStyleResolver(designTime);
        NamespaceCollection namespaceCollection = StyleSheetParserUtil.getInstance().getNamespaceCollection();
        DefaultDocumentContext documentContext = new DefaultDocumentContext(namespaceCollection, resourceManager, contentBase, null, styleDefinition);
        resolver.initialize(documentContext);
        return resolver;
    }

    private static ElementStyleDefinition createStyleDefinition(ReportDefinition reportDefinition, ResourceManager resourceManager, ResourceKey contentBase) {
        ElementStyleDefinition styleDefinition;
        Object maybeStyleSheet = reportDefinition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet");
        if (maybeStyleSheet instanceof ElementStyleDefinition) {
            ElementStyleDefinition sd = (ElementStyleDefinition)maybeStyleSheet;
            styleDefinition = sd.clone();
        } else {
            styleDefinition = new ElementStyleDefinition();
        }
        Object styleSheetRefs = reportDefinition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet-reference");
        ArrayList<Object> styleRefs = new ArrayList<Object>();
        if (styleSheetRefs instanceof Object[]) {
            Object[] styleArray = (Object[])styleSheetRefs;
            for (int i = 0; i < styleArray.length; ++i) {
                styleRefs.add(styleArray[i]);
            }
        } else if (styleSheetRefs instanceof Collection) {
            Collection c = (Collection)styleSheetRefs;
            styleRefs.addAll(c);
        } else if (styleSheetRefs != null) {
            styleRefs.add(styleSheetRefs);
        }
        for (int i = 0; i < styleRefs.size(); ++i) {
            Object o = styleRefs.get(i);
            try {
                ResourceKey key = resourceManager.createOrDeriveKey(contentBase, o, null);
                Resource resource = resourceManager.create(key, key, ElementStyleDefinition.class);
                ElementStyleDefinition definition = (ElementStyleDefinition)resource.getResource();
                styleDefinition.addStyleSheet(definition);
                continue;
            }
            catch (ResourceKeyCreationException e) {
                logger.debug((Object)("Failed to load referenced style-sheet: " + o), (Throwable)e);
                continue;
            }
            catch (ResourceException e) {
                logger.info((Object)("Failed to load referenced style-sheet: " + o), (Throwable)e);
            }
        }
        return styleDefinition;
    }

    public void initialize(DocumentContext layoutProcess) {
        this.documentContext = layoutProcess;
        this.namespaces = this.documentContext.getNamespaces();
        this.styleRuleMatcher = new SimpleStyleRuleMatcher();
        this.styleRuleMatcher.initialize(layoutProcess);
    }

    protected DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    protected NamespaceCollection getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void resolve(ReportElement element, ResolverStyleSheet resolverTarget) {
        resolverTarget.clear();
        resolverTarget.setId(element.getStyle().getId());
        this.simpleStyleResolver.resolveParent(element, resolverTarget);
        this.performSelectionStep(element, resolverTarget);
        resolverTarget.addAll(element.getStyle());
        resolverTarget.addDefault(element.getDefaultStyleSheet());
    }

    private void performSelectionStep(ReportElement element, ElementStyleSheet target) {
        StyleRuleMatcher.MatcherResult[] activeStyleRules = this.styleRuleMatcher.getMatchingRules(element);
        SelectorWeight[] weights = new SelectorWeight[target.getPropertyKeys().length];
        for (int i = 0; i < activeStyleRules.length; ++i) {
            StyleRuleMatcher.MatcherResult activeStyleRule = activeStyleRules[i];
            ElementStyleRule rule = activeStyleRule.getRule();
            SelectorWeight weight = activeStyleRule.getWeight();
            StyleKey[] definedPropertyNamesArray = rule.getDefinedPropertyNamesArray();
            for (int j = 0; j < definedPropertyNamesArray.length; ++j) {
                Object styleProperty;
                SelectorWeight selectorWeight;
                StyleKey styleKey = definedPropertyNamesArray[j];
                if (styleKey == null || (selectorWeight = weights[j]) != null && selectorWeight.compareTo(weight) <= 0 || (styleProperty = rule.getStyleProperty(styleKey)) == null) continue;
                target.setStyleProperty(styleKey, styleProperty);
                weights[j] = weight;
            }
        }
    }

    @Override
    public StyleResolver clone() {
        try {
            return (StyleResolver)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

