/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorageKey;

public class FunctionStorage
implements Serializable {
    private static final boolean PARANOID_CHECK = false;
    private HashMap storage = new HashMap();

    public void store(FunctionStorageKey key, Expression[] expressions, int length) throws ReportProcessingException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (expressions == null) {
            throw new NullPointerException();
        }
        try {
            Expression[] copy = new Expression[length];
            for (int i = 0; i < length; ++i) {
                copy[i] = (Expression)expressions[i].clone();
            }
            this.storage.put(key, copy);
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Storing expressions failed.");
        }
    }

    public Expression[] restore(FunctionStorageKey key) throws ReportProcessingException {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            Expression[] expressions = (Expression[])this.storage.get(key);
            if (expressions == null) {
                return null;
            }
            Expression[] copy = (Expression[])expressions.clone();
            for (int i = 0; i < expressions.length; ++i) {
                copy[i] = (Expression)expressions[i].clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Restoring expressions failed.");
        }
    }
}

