/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.sorting;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.sorting.GenericComparator;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;

public class TableSorter {
    private static final Log logger = LogFactory.getLog(TableSorter.class);
    private TableModel model;
    private SortConstraint[] constraints;
    private Tuple[] sortData;
    private HashMap<String, Integer> columnNames;

    public TableSorter init(TableModel model, SortConstraint[] constraints) {
        this.model = model;
        this.constraints = constraints;
        return this;
    }

    private HashMap<String, Integer> createColumnNameIndex() {
        HashMap<String, Integer> idx = new HashMap<String, Integer>();
        TableModel tableModel = this.getModel();
        int cc = tableModel.getColumnCount();
        for (int i = 0; i < cc; ++i) {
            idx.put(tableModel.getColumnName(i), i);
        }
        return idx;
    }

    public TableSorter populate() {
        this.columnNames = this.createColumnNameIndex();
        this.sortData = this.calculateSortColumnIndex();
        return this;
    }

    protected Tuple[] calculateSortColumnIndex() {
        ArrayList<Tuple> index = new ArrayList<Tuple>();
        for (SortConstraint constraint : this.constraints) {
            int idx = this.findIndex(constraint.getField());
            if (idx >= 0) {
                index.add(new Tuple(idx, constraint));
                continue;
            }
            logger.debug((Object)("Sort constraint contained references invalid column '" + constraint.getField() + "'"));
        }
        return index.toArray(new Tuple[index.size()]);
    }

    private int findIndex(String columnName) {
        Integer integer = this.columnNames.get(columnName);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected TableModel getModel() {
        return this.model;
    }

    protected SortConstraint[] getConstraints() {
        return this.constraints;
    }

    public Tuple[] getSortData() {
        return this.sortData;
    }

    public int[] sortData() {
        if (this.sortData.length > 0) {
            Object[] sortableArray = this.createSortableData();
            Arrays.sort(sortableArray);
            return this.buildRawIndex((IndexElement[])sortableArray);
        }
        return this.buildIdentityMapping();
    }

    private int[] buildIdentityMapping() {
        int[] raw = new int[this.model.getRowCount()];
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = i;
        }
        return raw;
    }

    private int[] buildRawIndex(IndexElement[] sortableArray) {
        int[] raw = new int[sortableArray.length];
        for (int i = 0; i < sortableArray.length; ++i) {
            IndexElement indexElement = sortableArray[i];
            raw[i] = indexElement.getSourceRow();
        }
        return raw;
    }

    private IndexElement[] createSortableData() {
        IndexElement[] indexElements = new IndexElement[this.model.getRowCount()];
        for (int i = 0; i < indexElements.length; ++i) {
            indexElements[i] = this.createIndexElement(i);
        }
        return indexElements;
    }

    protected IndexElement createIndexElement(int row) {
        return new IndexElement(row);
    }

    protected Comparator<Object> getComparator() {
        return GenericComparator.INSTANCE;
    }

    public static int[] sort(TableModel model, SortConstraint[] constraints) {
        TableSorter tableSorter = (TableSorter)ClassicEngineBoot.getInstance().getObjectFactory().get(TableSorter.class);
        return tableSorter.init(model, constraints).populate().sortData();
    }

    protected static class Tuple {
        public final int columnIndex;
        public final String name;
        public final int sortOrder;

        public Tuple(int columnIndex, SortConstraint c) {
            this.columnIndex = columnIndex;
            this.name = c.getField();
            this.sortOrder = c.isAscending() ? 1 : -1;
        }
    }

    protected class IndexElement
    implements Comparable<IndexElement> {
        private int sourceRow;
        private WeakReference<Object[]> rowData;

        public IndexElement(int sourceRow) {
            this.sourceRow = sourceRow;
        }

        public int getSourceRow() {
            return this.sourceRow;
        }

        protected Object[] getRowData() {
            Object[] objects;
            if (this.rowData != null && (objects = (Object[])this.rowData.get()) != null) {
                return objects;
            }
            Tuple[] sortData = TableSorter.this.getSortData();
            Object[] row = new Object[sortData.length];
            for (int i = 0; i < row.length; ++i) {
                row[i] = TableSorter.this.getModel().getValueAt(this.getSourceRow(), sortData[i].columnIndex);
            }
            this.rowData = new WeakReference<Object[]>(row);
            return row;
        }

        @Override
        public int compareTo(IndexElement o) {
            Object[] data = this.getRowData();
            Object[] otherData = o.getRowData();
            Tuple[] sortData = TableSorter.this.getSortData();
            Comparator<Object> comparator = TableSorter.this.getComparator();
            for (int i = 0; i < sortData.length; ++i) {
                Tuple tuple = sortData[i];
                Object rawMine = data[i];
                Object rawTheirs = otherData[i];
                int result = comparator.compare(rawMine, rawTheirs) * tuple.sortOrder;
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(this.sourceRow, o.sourceRow);
        }
    }
}

