/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PageReadHandler
extends AbstractPropertyXmlReadHandler {
    private static final Log logger = LogFactory.getLog(PageReadHandler.class);
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    public static final String WIDTH_ATT = "width";
    public static final String HEIGHT_ATT = "height";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverse_landscape";
    private float x;
    private float y;
    private PageFormat pageFormat;

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public float getY() {
        return this.y;
    }

    public float getX() {
        return this.x;
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        this.handlePageFormat(attrs);
        this.x = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), "x"), (float)0.0f);
        this.y = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), "y"), (float)0.0f);
    }

    private void handlePageFormat(Attributes atts) throws SAXException {
        MasterReport report = (MasterReport)this.getRootHandler().getHelperObject("::Report");
        PageFormat format = report.getPageDefinition().getPageFormat(0);
        float defTopMargin = (float)format.getImageableY();
        float defBottomMargin = (float)(format.getHeight() - format.getImageableHeight() - format.getImageableY());
        float defLeftMargin = (float)format.getImageableX();
        float defRightMargin = (float)(format.getWidth() - format.getImageableWidth() - format.getImageableX());
        format = this.createPageFormat(format, atts);
        defTopMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), TOPMARGIN_ATT), (float)defTopMargin);
        defBottomMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), BOTTOMMARGIN_ATT), (float)defBottomMargin);
        defLeftMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), LEFTMARGIN_ATT), (float)defLeftMargin);
        defRightMargin = ParserUtil.parseFloat((String)atts.getValue(this.getUri(), RIGHTMARGIN_ATT), (float)defRightMargin);
        Paper p = format.getPaper();
        switch (format.getOrientation()) {
            case 1: {
                PageFormatFactory.getInstance().setBorders(p, defTopMargin, defLeftMargin, defBottomMargin, defRightMargin);
                break;
            }
            case 0: {
                PageFormatFactory.getInstance().setBorders(p, defRightMargin, defTopMargin, defLeftMargin, defBottomMargin);
                break;
            }
            case 2: {
                PageFormatFactory.getInstance().setBorders(p, defLeftMargin, defBottomMargin, defRightMargin, defTopMargin);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected paper orientation.");
            }
        }
        format.setPaper(p);
        this.pageFormat = format;
    }

    private PageFormat createPageFormat(PageFormat format, Attributes atts) throws SAXException {
        int orientationVal;
        String pageformatName = atts.getValue(this.getUri(), PAGEFORMAT_ATT);
        String orientation = atts.getValue(this.getUri(), ORIENTATION_ATT);
        if (orientation == null) {
            orientationVal = 1;
        } else if (orientation.equals(ORIENTATION_LANDSCAPE_VAL)) {
            orientationVal = 0;
        } else if (orientation.equals(ORIENTATION_REVERSE_LANDSCAPE_VAL)) {
            orientationVal = 2;
        } else if (orientation.equals(ORIENTATION_PORTRAIT_VAL)) {
            orientationVal = 1;
        } else {
            throw new ParseException("Orientation value in REPORT-Tag is invalid.", this.getRootHandler().getDocumentLocator());
        }
        if (pageformatName != null) {
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatName);
            if (p == null) {
                logger.warn((Object)("Unable to create the requested Paper. " + pageformatName));
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        if (atts.getValue(this.getUri(), WIDTH_ATT) != null && atts.getValue(this.getUri(), HEIGHT_ATT) != null) {
            int[] pageformatData = new int[]{ParserUtil.parseInt((String)atts.getValue(this.getUri(), WIDTH_ATT), (String)"No Width set", (Locator)this.getLocator()), ParserUtil.parseInt((String)atts.getValue(this.getUri(), HEIGHT_ATT), (String)"No Height set", (Locator)this.getLocator())};
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatData);
            if (p == null) {
                logger.warn((Object)("Unable to create the requested Paper. Paper={" + pageformatData[0] + ", " + pageformatData[1] + '}'));
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        logger.info((Object)"Insufficient Data to create a pageformat: Returned default.");
        return format;
    }

    public Object getObject() {
        return null;
    }
}

