/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class AbstractObjectDescription
implements ObjectDescription,
Cloneable {
    private Class className;
    private HashMap parameters;
    private HashMap parameterDefs;
    private Configuration config;

    protected AbstractObjectDescription(Class className) {
        this.className = className;
        this.parameters = new HashMap();
        this.parameterDefs = new HashMap();
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractObjectDescription od = (AbstractObjectDescription)super.clone();
        od.parameterDefs = (HashMap)this.parameterDefs.clone();
        od.parameters = (HashMap)this.parameters.clone();
        return od;
    }

    @Override
    public Class getParameterDefinition(String name) {
        return (Class)this.parameterDefs.get(name);
    }

    public void setParameterDefinition(String name, Class obj) {
        if (obj == null) {
            this.parameterDefs.remove(name);
        } else {
            this.parameterDefs.put(name, obj);
        }
    }

    public static Class convertPrimitiveClass(Class obj) {
        if (!obj.isPrimitive()) {
            return obj;
        }
        if (obj == Boolean.TYPE) {
            return Boolean.class;
        }
        if (obj == Byte.TYPE) {
            return Byte.class;
        }
        if (obj == Character.TYPE) {
            return Character.class;
        }
        if (obj == Short.TYPE) {
            return Short.class;
        }
        if (obj == Integer.TYPE) {
            return Integer.class;
        }
        if (obj == Long.TYPE) {
            return Long.class;
        }
        if (obj == Float.TYPE) {
            return Float.class;
        }
        if (obj == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException("Class 'void' is not allowed here");
    }

    @Override
    public void setParameter(String name, Object value) {
        if (this.getParameterDefinition(name) == null) {
            throw new IllegalArgumentException("No such Parameter defined: " + name + " in class " + this.getObjectClass());
        }
        if (value == null) {
            this.parameters.remove(name);
            return;
        }
        Class parameterClass = AbstractObjectDescription.convertPrimitiveClass(this.getParameterDefinition(name));
        if (!parameterClass.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("In Object " + this.getObjectClass() + ": Value is not assignable: " + value.getClass() + " is not assignable from " + parameterClass);
        }
        this.parameters.put(name, value);
    }

    @Override
    public synchronized Iterator getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.parameterDefs.keySet());
        Collections.sort(parameterNames);
        return parameterNames.iterator();
    }

    protected Iterator getDefinedParameterNames() {
        ArrayList parameterNames = new ArrayList(this.parameters.keySet());
        return parameterNames.iterator();
    }

    @Override
    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Class getObjectClass() {
        return this.className;
    }

    @Override
    public ObjectDescription getInstance() {
        try {
            AbstractObjectDescription c = (AbstractObjectDescription)super.clone();
            c.parameters = (HashMap)this.parameters.clone();
            return c;
        }
        catch (Exception e) {
            throw new IllegalStateException("Should not happen: Error on clone");
        }
    }

    @Override
    public ObjectDescription getUnconfiguredInstance() {
        try {
            AbstractObjectDescription c = (AbstractObjectDescription)super.clone();
            c.parameters = (HashMap)this.parameters.clone();
            c.config = null;
            return c;
        }
        catch (Exception e) {
            throw new IllegalStateException("Should not happen: Error on clone");
        }
    }

    @Override
    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractObjectDescription)) {
            return false;
        }
        AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)o;
        return this.className.equals(abstractObjectDescription.className);
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }
}

