/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.FormulaFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.DefaultExpressionPropertyWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertyWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleExpressionPropertyWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ExpressionWriterUtility {
    private static final Log logger = LogFactory.getLog(ExpressionWriterUtility.class);

    private ExpressionWriterUtility() {
    }

    public static boolean isElementLayoutExpressionActive(BundleWriterState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        ExpressionCollection exp = state.getReport().getExpressions();
        ExpressionRegistry registry = ExpressionRegistry.getInstance();
        for (int i = 0; i < exp.size(); ++i) {
            ExpressionMetaData emd;
            Expression expression = exp.getExpression(i);
            if (!registry.isExpressionRegistered(expression.getClass().getName()) || !(emd = registry.getExpressionMetaData(expression.getClass().getName())).isElementLayoutProcessor()) continue;
            return true;
        }
        return false;
    }

    public static void writeElementLayoutExpressions(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter writer) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        ExpressionCollection exp = state.getReport().getExpressions();
        ExpressionRegistry registry = ExpressionRegistry.getInstance();
        for (int i = 0; i < exp.size(); ++i) {
            ExpressionMetaData emd;
            Expression expression = exp.getExpression(i);
            if (!registry.isExpressionRegistered(expression.getClass().getName()) || !(emd = registry.getExpressionMetaData(expression.getClass().getName())).isElementLayoutProcessor()) continue;
            ExpressionWriterUtility.writeExpression(bundle, state, expression, writer, "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "expression");
        }
    }

    public static boolean isGlobalLayoutExpressionActive(BundleWriterState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        ExpressionCollection exp = state.getReport().getExpressions();
        ExpressionRegistry registry = ExpressionRegistry.getInstance();
        for (int i = 0; i < exp.size(); ++i) {
            ExpressionMetaData emd;
            Expression expression = exp.getExpression(i);
            if (!registry.isExpressionRegistered(expression.getClass().getName()) || !(emd = registry.getExpressionMetaData(expression.getClass().getName())).isGlobalLayoutProcessor()) continue;
            return true;
        }
        return false;
    }

    public static void writeGlobalLayoutExpressions(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter writer) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        ExpressionCollection exp = state.getReport().getExpressions();
        ExpressionRegistry registry = ExpressionRegistry.getInstance();
        for (int i = 0; i < exp.size(); ++i) {
            ExpressionMetaData emd;
            Expression expression = exp.getExpression(i);
            if (!registry.isExpressionRegistered(expression.getClass().getName()) || !(emd = registry.getExpressionMetaData(expression.getClass().getName())).isGlobalLayoutProcessor()) continue;
            ExpressionWriterUtility.writeExpression(bundle, state, expression, writer, "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "expression");
        }
    }

    public static void writeDataExpressions(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter writer) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        ExpressionCollection exp = state.getReport().getExpressions();
        ExpressionRegistry registry = ExpressionRegistry.getInstance();
        for (int i = 0; i < exp.size(); ++i) {
            ExpressionMetaData emd;
            Expression expression = exp.getExpression(i);
            if (!registry.isExpressionRegistered(expression.getClass().getName()) || (emd = registry.getExpressionMetaData(expression.getClass().getName())).isGlobalLayoutProcessor() || emd.isElementLayoutProcessor()) continue;
            ExpressionWriterUtility.writeExpression(bundle, state, expression, writer, "http://reporting.pentaho.org/namespaces/engine/classic/bundle/data/1.0", "expression");
        }
    }

    public static void writeExpression(WriteableDocumentBundle bundle, BundleWriterState state, Expression expression, XmlWriter writer, String namespaceUri, String expressionTag) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (expressionTag == null) {
            throw new NullPointerException();
        }
        AttributeList expressionAttrList = new AttributeList();
        if (expression.getName() != null) {
            expressionAttrList.setAttribute(namespaceUri, "name", expression.getName());
        }
        if (expression.getDependencyLevel() > 0) {
            expressionAttrList.setAttribute(namespaceUri, "deplevel", String.valueOf(expression.getDependencyLevel()));
        }
        ExpressionWriterUtility.writeExpressionCore(bundle, state, expression, writer, namespaceUri, expressionTag, expressionAttrList);
    }

    public static void writeStyleExpression(WriteableDocumentBundle bundle, BundleWriterState state, Expression expression, XmlWriter writer, StyleKey styleKey, String namespaceUri, String expressionTag) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (styleKey == null) {
            throw new NullPointerException();
        }
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (expressionTag == null) {
            throw new NullPointerException();
        }
        AttributeList expressionAttrList = new AttributeList();
        expressionAttrList.setAttribute(namespaceUri, "style-key", styleKey.getName());
        ExpressionWriterUtility.writeExpressionCore(bundle, state, expression, writer, namespaceUri, expressionTag, expressionAttrList);
    }

    public static void writeExpressionCore(WriteableDocumentBundle bundle, BundleWriterState state, Expression expression, XmlWriter writer, String namespaceUri, String expressionTag, AttributeList expressionAttrList) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (expressionTag == null) {
            throw new NullPointerException();
        }
        if (expressionAttrList == null) {
            throw new NullPointerException();
        }
        if (expression instanceof FormulaExpression) {
            FormulaExpression fe = (FormulaExpression)expression;
            if (StringUtils.isEmpty((String)fe.getFormula())) {
                return;
            }
            expressionAttrList.setAttribute(namespaceUri, "formula", fe.getFormula());
            if (fe.getFailOnError() != null) {
                expressionAttrList.setAttribute(namespaceUri, "failOnError", fe.getFailOnError().toString());
            }
            writer.writeTag(namespaceUri, expressionTag, expressionAttrList, true);
            return;
        }
        if (expression instanceof FormulaFunction) {
            FormulaFunction fe = (FormulaFunction)expression;
            if (StringUtils.isEmpty((String)fe.getFormula())) {
                return;
            }
            expressionAttrList.setAttribute(namespaceUri, "formula", fe.getFormula());
            expressionAttrList.setAttribute(namespaceUri, "initial", fe.getInitial());
            writer.writeTag(namespaceUri, expressionTag, expressionAttrList, true);
            return;
        }
        try {
            String expressionId = expression.getClass().getName();
            expressionAttrList.setAttribute(namespaceUri, "class", expressionId);
            ExpressionMetaData emd = ExpressionRegistry.getInstance().isExpressionRegistered(expressionId) ? ExpressionRegistry.getInstance().getExpressionMetaData(expressionId) : null;
            if (emd != null) {
                BeanUtility bu = new BeanUtility(expression);
                ExpressionPropertyMetaData[] expressionProperties = emd.getPropertyDescriptions();
                boolean propertiesOpen = false;
                for (int i = 0; i < expressionProperties.length; ++i) {
                    ExpressionPropertyMetaData metaData = expressionProperties[i];
                    String propertyName = metaData.getName();
                    if (ExpressionWriterUtility.isFilteredProperty(propertyName) || metaData.isComputed()) continue;
                    if (!propertiesOpen) {
                        writer.writeTag(namespaceUri, expressionTag, expressionAttrList, false);
                        writer.writeTag(namespaceUri, "properties", false);
                        propertiesOpen = true;
                    }
                    ExpressionWriterUtility.copyStaticResources(bundle, state, expression, bu, expressionProperties);
                    ExpressionWriterUtility.writeExpressionParameter(bundle, state, writer, expression, bu, propertyName, namespaceUri);
                }
                if (propertiesOpen) {
                    writer.writeCloseTag();
                    writer.writeCloseTag();
                } else {
                    writer.writeTag(namespaceUri, expressionTag, expressionAttrList, true);
                }
            } else {
                BeanUtility beanUtility = new BeanUtility(expression);
                String[] propertyNames = beanUtility.getProperties();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String key = propertyNames[i];
                    if (ExpressionWriterUtility.isFilteredProperty(key)) continue;
                    ExpressionWriterUtility.writeExpressionParameter(bundle, state, writer, expression, beanUtility, key, namespaceUri);
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new BundleWriterException("Unable to extract or write properties.", e);
        }
    }

    private static boolean isFilteredProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if ("name".equals(name)) {
            return true;
        }
        if ("dependencyLevel".equals(name)) {
            return true;
        }
        if ("runtime".equals(name)) {
            return true;
        }
        if ("active".equals(name)) {
            return true;
        }
        return "preserve".equals(name);
    }

    private static void writeExpressionParameter(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter writer, Expression e, BeanUtility beanUtility, String propertyName, String namespaceUri) throws IOException, BeanException {
        ExpressionPropertyWriteHandler writeHandler = ExpressionWriterUtility.createWriteHandler(e, propertyName);
        if (writeHandler instanceof BundleExpressionPropertyWriteHandler) {
            BundleExpressionPropertyWriteHandler bw = (BundleExpressionPropertyWriteHandler)writeHandler;
            bw.initBundleContext(bundle, state);
        }
        writeHandler.writeExpressionParameter(writer, beanUtility, propertyName, namespaceUri);
    }

    private static ExpressionPropertyWriteHandler createWriteHandler(Expression e, String key) {
        try {
            ExpressionMetaData expressionMetaData = ExpressionRegistry.getInstance().getExpressionMetaData(e.getClass().getName());
            ExpressionPropertyMetaData propertyDescription = expressionMetaData.getPropertyDescription(key);
            Class<? extends ExpressionPropertyWriteHandler> writeHandlerRef = propertyDescription.getPropertyWriteHandler();
            if (writeHandlerRef != null) {
                return writeHandlerRef.newInstance();
            }
        }
        catch (Exception ex) {
            logger.info((Object)("No valid property metadata defined for " + e.getClass() + " on property " + key));
        }
        return new DefaultExpressionPropertyWriteHandler();
    }

    public static void copyStaticResources(WriteableDocumentBundle bundle, BundleWriterState state, Expression expression, BeanUtility beanUtility, ExpressionPropertyMetaData[] datas) throws BundleWriterException, BeanException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        if (beanUtility == null) {
            throw new NullPointerException();
        }
        if (datas == null) {
            throw new NullPointerException();
        }
        AbstractReportDefinition report = state.getReport();
        ResourceKey contentBase = report.getContentBase();
        if (contentBase == null) {
            return;
        }
        ResourceKey defSource = report.getDefinitionSource();
        if (defSource == null) {
            return;
        }
        if (!ObjectUtilities.equal((Object)contentBase.getParent(), (Object)defSource.getParent())) {
            return;
        }
        Object contentBasePathRaw = contentBase.getIdentifier();
        if (!(contentBasePathRaw instanceof String)) {
            return;
        }
        String contentBasePath = String.valueOf(contentBasePathRaw);
        ResourceManager resourceManager = state.getMasterReport().getResourceManager();
        for (int i = 0; i < datas.length; ++i) {
            ExpressionPropertyMetaData attributeMetaData = datas[i];
            Object attValue = beanUtility.getProperty(attributeMetaData.getName());
            if (attValue == null) continue;
            ResourceReference[] referencedResources = attributeMetaData.getReferencedResources(expression, attValue, report, resourceManager);
            for (int j = 0; j < referencedResources.length; ++j) {
                ResourceKey path;
                Object identifier;
                ResourceReference reference = referencedResources[j];
                if (reference.isLinked() || !((identifier = (path = reference.getPath()).getIdentifier()) instanceof String)) continue;
                String identifierString = String.valueOf(identifier);
                String relativePath = IOUtils.getInstance().createRelativePath(identifierString, contentBasePath);
                try {
                    BundleUtilities.copyInto((WriteableDocumentBundle)bundle, (String)relativePath, (ResourceKey)path, (ResourceManager)resourceManager);
                    continue;
                }
                catch (Exception e) {
                    throw new BundleWriterException("Failed to copy content from key " + path, e);
                }
            }
        }
    }
}

