/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements;

import java.beans.PropertyEditor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ClassicEngineFactoryParameters;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.StyleExpressionHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.ElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.ElementStyleReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.AttributeExpressionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.BulkAttributeReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.BulkExpressionReadHandler;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractElementReadHandler
extends AbstractXmlReadHandler
implements ElementReadHandler {
    private static final Log logger = LogFactory.getLog(AbstractElementReadHandler.class);
    private Element element;
    private ElementMetaData metaData;
    private ArrayList<StyleExpressionHandler> styleExpressions = new ArrayList();
    private ArrayList<AttributeExpressionReadHandler> attributeExpressions = new ArrayList();
    private ArrayList<BulkAttributeReadHandler> bulkattributes = new ArrayList();
    private ArrayList<BulkExpressionReadHandler> bulkexpressions = new ArrayList();

    protected AbstractElementReadHandler() {
    }

    protected AbstractElementReadHandler(ElementType elementType) throws ParseException {
        this();
        this.initialize(elementType);
    }

    protected void autoInit() throws ParseException {
        ElementMetaData elementType;
        String tagName = this.getTagName();
        String uri = this.getUri();
        if (!ObjectUtilities.equal((Object)uri, (Object)(elementType = ElementTypeRegistry.getInstance().getElementType(tagName)).getNamespace())) {
            throw new ParseException("Metadata not registered, and auto-registration does not match namespace");
        }
        this.metaData = elementType;
        this.element = this.createElement();
    }

    protected void initialize(ElementType elementType) throws ParseException {
        this.metaData = elementType.getMetaData();
        this.element = this.createElement();
    }

    protected Element createElement() throws ParseException {
        try {
            ElementType elementTypeObj = this.metaData.create();
            return (Element)elementTypeObj.create();
        }
        catch (InstantiationException e) {
            throw new ParseException("Unable to instantiate element for type '" + this.metaData.getName() + '\"');
        }
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        Element element = this.getElement();
        if (element == null) {
            throw new IllegalStateException("Failed at " + this.getClass());
        }
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String name;
            if ("xmlns".equals(attrs.getQName(i)) || attrs.getQName(i).startsWith("xmlns:") || (name = attrs.getLocalName(i)).indexOf(58) > -1) continue;
            String namespace = attrs.getURI(i);
            String attributeValue = attrs.getValue(i);
            this.setAttributeValue(element, namespace, name, attributeValue, ReportAttributeMap.EMPTY_MAP);
        }
    }

    private void setAttributeValue(ReportElement element, String namespace, String name, String attributeValue, ReportAttributeMap attributes) throws ParseException {
        AttributeMetaData attributeMetaData = this.metaData.getAttributeDescription(namespace, name);
        if (attributeMetaData == null || attributeValue == null) {
            element.setAttribute(namespace, name, attributeValue);
            return;
        }
        if (attributeMetaData.isTransient()) {
            return;
        }
        if (this.isFiltered(attributeMetaData)) {
            return;
        }
        if ("Resource".equals(attributeMetaData.getValueRole())) {
            try {
                Object type = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-type");
                if ("url".equals(type)) {
                    element.setAttribute(namespace, name, new URL(attributeValue));
                    return;
                }
                if ("file".equals(type)) {
                    element.setAttribute(namespace, name, new File(attributeValue));
                    return;
                }
                if ("local-ref".equals(type)) {
                    element.setAttribute(namespace, name, attributeValue);
                    return;
                }
                if ("resource-key".equals(type)) {
                    ResourceManager resourceManager = this.getRootHandler().getResourceManager();
                    ResourceKey key = this.getRootHandler().getContext();
                    ResourceKey parent = key.getParent();
                    ResourceKey valueKey = resourceManager.deserialize(parent, attributeValue);
                    ResourceKey resourceKey = this.localizeKey(resourceManager, valueKey);
                    element.setAttribute(namespace, name, resourceKey);
                    return;
                }
                element.setAttribute(namespace, name, attributeValue);
                return;
            }
            catch (MalformedURLException e) {
                throw new ParseException("Failed to parse URL value", (Exception)e);
            }
            catch (ResourceKeyCreationException e) {
                throw new ParseException("Failed to parse resource-key value", (Exception)((Object)e));
            }
        }
        Class type = attributeMetaData.getTargetType();
        if (String.class.equals((Object)type)) {
            element.setAttribute(namespace, name, attributeValue);
        } else {
            try {
                PropertyEditor propertyEditor = attributeMetaData.getEditor();
                if (propertyEditor != null) {
                    propertyEditor.setAsText(attributeValue);
                    element.setAttribute(namespace, name, propertyEditor.getValue());
                } else {
                    ConverterRegistry instance = ConverterRegistry.getInstance();
                    ValueConverter valueConverter = instance.getValueConverter(type);
                    if (valueConverter != null) {
                        Object o = ConverterRegistry.toPropertyValue(attributeValue, type);
                        element.setAttribute(namespace, name, o);
                    } else if (String.class.isAssignableFrom(type)) {
                        element.setAttribute(namespace, name, attributeValue);
                    }
                }
            }
            catch (BeanException e) {
                logger.warn((Object)("Attribute '" + namespace + '|' + name + "' is not convertible with the bean-methods " + this.getLocator()));
            }
        }
    }

    protected boolean isFiltered(AttributeMetaData attributeMetaData) {
        return "http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(attributeMetaData.getNameSpace()) && "element-type".equals(attributeMetaData.getName());
    }

    private ResourceKey localizeKey(ResourceManager resourceManager, ResourceKey valueKey) {
        Object object = valueKey.getFactoryParameters().get(ClassicEngineFactoryParameters.EMBED);
        if ("false".equals(object)) {
            return valueKey;
        }
        if (!"org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleLoader".equals(valueKey.getSchema()) && object == null) {
            return valueKey;
        }
        try {
            ResourceData resourceData = resourceManager.load(valueKey);
            byte[] resource = resourceData.getResource(resourceManager);
            return resourceManager.createKey((Object)resource, valueKey.getFactoryParameters());
        }
        catch (ResourceException e) {
            if (logger.isDebugEnabled()) {
                logger.info((Object)"Unable to normalize embedded resource-key, using ordinary key-object instead.", (Throwable)e);
            } else {
                logger.info((Object)"Unable to normalize embedded resource-key, using ordinary key-object instead.");
            }
            return valueKey;
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0".equals(uri)) {
            if ("attribute-expression".equals(tagName)) {
                AttributeExpressionReadHandler readHandler = new AttributeExpressionReadHandler();
                this.attributeExpressions.add(readHandler);
                return readHandler;
            }
            if ("style-expression".equals(tagName)) {
                StyleExpressionHandler readHandler = new StyleExpressionHandler();
                this.styleExpressions.add(readHandler);
                return readHandler;
            }
            if ("expression".equals(tagName)) {
                BulkExpressionReadHandler readHandler = new BulkExpressionReadHandler();
                this.bulkexpressions.add(readHandler);
                return readHandler;
            }
            if ("attribute".equals(tagName)) {
                String namespace = atts.getValue(this.getUri(), "namespace");
                String attrName = atts.getValue(this.getUri(), "name");
                BulkAttributeReadHandler readHandler = new BulkAttributeReadHandler(namespace, attrName);
                this.bulkattributes.add(readHandler);
                return readHandler;
            }
        }
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0".equals(uri) && "element-style".equals(tagName)) {
            return new ElementStyleReadHandler(this.getElement().getStyle());
        }
        if (this.metaData.getAttributeDescription(uri, tagName) != null) {
            BulkAttributeReadHandler readHandler = new BulkAttributeReadHandler(uri, tagName);
            this.bulkattributes.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        AbstractXmlReadHandler handler;
        int i;
        for (i = 0; i < this.styleExpressions.size(); ++i) {
            handler = this.styleExpressions.get(i);
            StyleKey key = handler.getKey();
            if (handler.getKey() == null) continue;
            Expression expression = handler.getExpression();
            this.element.setStyleExpression(key, expression);
        }
        for (i = 0; i < this.attributeExpressions.size(); ++i) {
            handler = this.attributeExpressions.get(i);
            Expression expression = handler.getExpression();
            this.element.setAttributeExpression(handler.getNamespace(), handler.getName(), expression);
        }
        for (i = 0; i < this.bulkattributes.size(); ++i) {
            BulkAttributeReadHandler attributeReadHandler = this.bulkattributes.get(i);
            this.setAttributeValue(this.element, attributeReadHandler.getNamespace(), attributeReadHandler.getName(), attributeReadHandler.getResult(), attributeReadHandler.getAttributes());
        }
        for (i = 0; i < this.bulkexpressions.size(); ++i) {
            BulkExpressionReadHandler expressionReadHandler = this.bulkexpressions.get(i);
            this.element.setAttribute(expressionReadHandler.getAttributeNameSpace(), expressionReadHandler.getAttributeName(), expressionReadHandler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return this.getElement();
    }

    @Override
    public Element getElement() {
        return this.element;
    }
}

