/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.xml;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;

public class XMLWriter
extends AbstractFunction
implements OutputFunction {
    private static final Log logger = LogFactory.getLog(XMLWriter.class);
    private Writer w;
    private int depLevel;
    private final CharacterEntityParser entityParser;
    private static final InlineSubreportMarker[] EMPTY_SUBREPORTS = new InlineSubreportMarker[0];

    public XMLWriter() {
        this.setDependencyLevel(-2);
        this.entityParser = CharacterEntityParser.createXMLEntityParser();
    }

    public Writer getWriter() {
        return this.w;
    }

    public void setWriter(Writer w) {
        this.w = w;
    }

    private void writeBand(Band b) throws IOException {
        for (Element e : b.unsafeGetElementArray()) {
            if (e instanceof Band) {
                this.w.write("<band>");
                this.writeBand((Band)e);
                this.w.write("</band>");
                continue;
            }
            this.w.write("<element name=\"");
            this.w.write(this.entityParser.encodeEntities(e.getName()));
            this.w.write("\">");
            String value = String.valueOf(e.getElementType().getValue(this.getRuntime(), e));
            this.w.write(this.entityParser.encodeEntities(value));
            this.w.write("</element>");
        }
    }

    @Override
    public void reportStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<report>");
            this.w.write("<reportheader>");
            this.writeBand(event.getReport().getReportHeader());
            this.w.write("</reportheader>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    @Override
    public void reportFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<reportfooter>");
            this.writeBand(event.getReport().getReportFooter());
            this.w.write("</reportfooter>");
            this.w.write("</report>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            Group g = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            if (g instanceof RelationalGroup) {
                RelationalGroup rg = (RelationalGroup)g;
                this.w.write("<groupheader name=\"");
                this.w.write(this.entityParser.encodeEntities(g.getName()));
                this.w.write("\">");
                this.writeBand(rg.getHeader());
                this.w.write("</groupheader>");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    @Override
    public void groupFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            Group g = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            if (g instanceof RelationalGroup) {
                RelationalGroup rg = (RelationalGroup)g;
                this.w.write("<groupfooter name=\"");
                this.w.write(this.entityParser.encodeEntities(g.getName()));
                this.w.write("\">");
                this.writeBand(rg.getFooter());
                this.w.write("</groupfooter>");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            ItemBand itemBand = event.getReport().getItemBand();
            if (itemBand != null) {
                this.w.write("<itemband>");
                this.writeBand(itemBand);
                this.w.write("</itemband>");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            DetailsHeader header;
            NoDataBand noDataBand;
            if (event.getState().getNumberOfRows() == 0 && (noDataBand = event.getReport().getNoDataBand()) != null) {
                this.w.write("<nodata>");
                this.writeBand(noDataBand);
                this.w.write("</nodata>");
            }
            if ((header = event.getReport().getDetailsHeader()) != null) {
                this.w.write("<details-header>");
                this.writeBand(header);
                this.w.write("</details-header>");
                this.w.write("<items>");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the items tag", (Throwable)ioe);
        }
    }

    @Override
    public void itemsFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            DetailsFooter header = event.getReport().getDetailsFooter();
            if (header != null) {
                this.w.write("<details-footer>");
                this.writeBand(header);
                this.w.write("</details-footer>");
                this.w.write("</items>");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the items tag", (Throwable)ioe);
        }
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public int getDependencyLevel() {
        return this.depLevel;
    }

    @Override
    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    @Override
    public OutputFunction deriveForStorage() {
        try {
            return (OutputFunction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public OutputFunction deriveForPagebreak() {
        try {
            return (OutputFunction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        XMLWriter o = (XMLWriter)super.clone();
        return o;
    }

    @Override
    public InlineSubreportMarker[] getInlineSubreports() {
        return EMPTY_SUBREPORTS;
    }

    @Override
    public void clearInlineSubreports(SubReportProcessType inlineExecution) {
    }

    @Override
    public void restart(ReportState state) {
    }

    @Override
    public void groupBodyFinished(ReportEvent event) {
    }

    @Override
    public boolean createRollbackInformation() {
        return false;
    }
}

