/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import java.util.Arrays;

public class TableCutList
implements Cloneable {
    private static final Boolean[] EMPTY_ENTRIES = new Boolean[0];
    private static final long[] EMPTY_KEYS = new long[0];
    private static final int LIN_VS_BIN = 16;
    private Boolean[] entries;
    private long[] keys;
    private int size;
    private int increment;
    private boolean enableQuickLookup;
    private long scaleFactor;
    public static long bin;
    public static long lin;

    public TableCutList(int increment, boolean enableQuickLookup) {
        if (increment < 1) {
            throw new IllegalArgumentException();
        }
        this.increment = increment;
        this.entries = EMPTY_ENTRIES;
        this.keys = EMPTY_KEYS;
        this.enableQuickLookup = enableQuickLookup;
    }

    public TableCutList clone() {
        try {
            TableCutList clone = (TableCutList)super.clone();
            clone.entries = (Boolean[])clone.entries.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public void clear() {
        this.size = 0;
        this.scaleFactor = 0L;
    }

    public boolean isEnableQuickLookup() {
        return this.enableQuickLookup;
    }

    public void setEnableQuickLookup(boolean enableQuickLookup) {
        this.enableQuickLookup = enableQuickLookup;
    }

    public int size() {
        return this.size;
    }

    private void ensureCapacity(int c) {
        if (this.keys.length <= c) {
            int newIncrement = Math.min(25000, Math.max(this.keys.length / 2, this.increment));
            long[] newKeys = new long[Math.max(this.keys.length + newIncrement, c + 1)];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            this.keys = newKeys;
            Boolean[] newCuts = new Boolean[Math.max(this.entries.length + newIncrement, c + 1)];
            System.arraycopy(this.entries, 0, newCuts, 0, this.size);
            this.entries = newCuts;
        }
    }

    public boolean put(long key, Boolean entry) {
        int position;
        if (entry == null) {
            throw new NullPointerException();
        }
        if (this.size > 0 && key > this.keys[this.size - 1]) {
            this.ensureCapacity(this.size + 1);
            this.keys[this.size] = key;
            this.entries[this.size] = entry;
            ++this.size;
            this.scaleFactor = (key - this.keys[0]) / (long)this.size;
            return true;
        }
        int start = 0;
        int end = this.size;
        if (this.enableQuickLookup && this.size > 0 && this.scaleFactor != 0L) {
            if (key < this.keys[0]) {
                end = 1;
            } else {
                int maxIdx = this.size - 1;
                long lastVal = this.keys[maxIdx];
                if (lastVal > 0L) {
                    boolean maxMorePos;
                    int targetIdx = (int)((key - this.keys[0]) / this.scaleFactor);
                    int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
                    int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
                    long minKey = this.keys[minTgtIdx];
                    long maxKey = this.keys[maxTgtIdx];
                    boolean minLessPos = key >= minKey;
                    boolean bl = maxMorePos = key <= maxKey;
                    if (minLessPos) {
                        start = minTgtIdx;
                    }
                    if (maxMorePos) {
                        end = maxTgtIdx + 1;
                    }
                }
            }
        }
        if (end - start < 16) {
            ++lin;
            position = TableCutList.linearSearch(this.keys, key, start, end);
        } else {
            ++bin;
            position = TableCutList.binarySearch(this.keys, key, start, end);
        }
        if (position >= 0) {
            Boolean entryFromList = this.entries[position];
            if (entryFromList == null) {
                throw new IllegalStateException("Must not happen");
            }
            if (Boolean.TRUE.equals(entryFromList)) {
                this.entries[position] = entry;
            }
            return false;
        }
        this.ensureCapacity(this.size + 1);
        int insertPoint = -(position + 1);
        if (insertPoint < this.size) {
            System.arraycopy(this.keys, insertPoint, this.keys, insertPoint + 1, this.size - insertPoint);
            System.arraycopy(this.entries, insertPoint, this.entries, insertPoint + 1, this.size - insertPoint);
        }
        this.keys[insertPoint] = key;
        this.entries[insertPoint] = entry;
        ++this.size;
        this.scaleFactor = insertPoint == this.size - 1 ? (key - this.keys[0]) / (long)this.size : (this.keys[this.size - 1] - this.keys[0]) / (long)this.size;
        return true;
    }

    private int findKeyInternal(long pos) {
        return this.findKeyInternal(pos, -1);
    }

    private int findKeyInternal(long pos, int lastFoundPos) {
        int i;
        int start = 0;
        int end = this.size;
        if (lastFoundPos != -1 && lastFoundPos < this.size && this.keys[lastFoundPos] == pos) {
            return lastFoundPos;
        }
        if (this.enableQuickLookup && this.size > 0 && this.scaleFactor != 0L) {
            if (pos < this.keys[0]) {
                return -1;
            }
            int maxIdx = this.size - 1;
            long lastVal = this.keys[maxIdx];
            if (lastVal > 0L) {
                boolean maxMorePos;
                int targetIdx = (int)((pos - this.keys[0]) / this.scaleFactor);
                int minTgtIdx = Math.max(0, Math.min(maxIdx, targetIdx - 7));
                int maxTgtIdx = Math.min(maxIdx, targetIdx + 7);
                long minKey = this.keys[minTgtIdx];
                long maxKey = this.keys[maxTgtIdx];
                boolean minLessPos = pos >= minKey;
                boolean bl = maxMorePos = pos <= maxKey;
                if (minLessPos) {
                    start = minTgtIdx;
                }
                if (maxMorePos) {
                    end = maxTgtIdx + 1;
                }
            }
        }
        if (end - start < 16) {
            ++lin;
            i = TableCutList.linearSearch(this.keys, pos, start, end);
        } else {
            ++bin;
            i = TableCutList.binarySearch(this.keys, pos, start, end);
        }
        if (i > -1) {
            return i;
        }
        if (i == -1) {
            return -1;
        }
        return i;
    }

    public boolean remove(long key) {
        int position = this.findKeyInternal(key);
        if (position < 0) {
            return false;
        }
        int shiftElements = this.size - position - 1;
        if (shiftElements == 0) {
            this.keys[position] = 0L;
            this.entries[position] = null;
            --this.size;
            this.scaleFactor = this.size == 0 ? 0L : (this.keys[this.size - 1] - this.keys[0]) / (long)this.size;
            return true;
        }
        --this.size;
        System.arraycopy(this.keys, position + 1, this.keys, position, shiftElements);
        System.arraycopy(this.entries, position + 1, this.entries, position, shiftElements);
        this.keys[this.size] = 0L;
        this.entries[this.size] = null;
        this.scaleFactor = this.size == 0 ? 0L : (this.keys[this.size - 1] - this.keys[0]) / (long)this.size;
        return true;
    }

    public Boolean get(long key) {
        if (this.size == 0) {
            return null;
        }
        if (key > this.keys[this.size - 1]) {
            return null;
        }
        int position = this.findKeyInternal(key);
        if (position < 0) {
            return null;
        }
        return this.entries[position];
    }

    public Boolean getPrevious(long key) {
        if (this.size == 0) {
            return null;
        }
        if (key > this.keys[this.size - 1]) {
            return this.entries[this.size - 1];
        }
        int position = this.findKeyInternal(key);
        if (position == 0) {
            return null;
        }
        if (position > 0) {
            return this.entries[position - 1];
        }
        int insertPoint = -(position + 2);
        return this.entries[insertPoint];
    }

    public boolean containsKey(long key) {
        if (this.size > 0 && key > this.keys[this.size - 1]) {
            return false;
        }
        return this.findKeyInternal(key) >= 0;
    }

    private static int linearSearch(long[] array, long key, int start, int end) {
        for (int i = start; i < end; ++i) {
            long value = array[i];
            if (value == key) {
                return i;
            }
            if (key >= value) continue;
            return -(i + 1);
        }
        return -(end + 1);
    }

    private static int binarySearch(long[] array, long key, int start, int end) {
        int low = start;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Boolean[] getRawEntries() {
        return this.entries;
    }

    public long[] getKeys() {
        if (this.size == 0) {
            return EMPTY_KEYS;
        }
        if (this.size == this.keys.length) {
            return (long[])this.keys.clone();
        }
        long[] retval = new long[this.size];
        System.arraycopy(this.keys, 0, retval, 0, this.size);
        return retval;
    }

    public long[] getKeys(long[] retval) {
        if (retval == null || retval.length < this.size) {
            retval = new long[this.size];
        }
        System.arraycopy(this.keys, 0, retval, 0, this.size);
        return retval;
    }

    public int findKeyPosition(long coordinate, boolean greater) {
        return this.findKeyPosition(coordinate, greater, -1);
    }

    public int findKeyPosition(long coordinate, boolean greater, int lastFoundPos) {
        int pos = this.findKeyInternal(coordinate, lastFoundPos);
        if (pos == this.size) {
            return this.size - 1;
        }
        if (pos >= 0) {
            return pos;
        }
        if (pos == -(this.size + 1)) {
            return this.size - 1;
        }
        if (greater) {
            return -pos - 1;
        }
        return -pos - 2;
    }

    public long getKeyAt(int indexPosition) {
        if (indexPosition >= this.size || indexPosition < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[indexPosition];
    }

    public Boolean getValueAt(int indexPosition) {
        if (indexPosition >= this.size || indexPosition < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.entries[indexPosition];
    }

    public long findKey(long key, boolean upperBounds) {
        int pos = this.findKeyPosition(key, upperBounds);
        return this.keys[pos];
    }

    public void removeAll(long[] cutArray, long cutSize) {
        if (cutSize == 0L) {
            return;
        }
        int cutIndex = 0;
        long currentCut = cutArray[0];
        int targetPosition = 0;
        for (int sourcePosition = 0; sourcePosition < this.size; ++sourcePosition) {
            long key = this.keys[sourcePosition];
            if (key == currentCut) {
                if ((long)(++cutIndex) == cutSize) {
                    System.arraycopy(this.keys, sourcePosition + 1, this.keys, targetPosition, this.size - sourcePosition - 1);
                    System.arraycopy(this.entries, sourcePosition + 1, this.entries, targetPosition, this.size - sourcePosition - 1);
                    targetPosition = this.size - cutIndex;
                    break;
                }
                currentCut = cutArray[cutIndex];
                continue;
            }
            this.keys[targetPosition] = key;
            this.entries[targetPosition] = this.entries[sourcePosition];
            ++targetPosition;
        }
        Arrays.fill(this.keys, targetPosition, this.size, 0L);
        Arrays.fill((Object[])this.entries, targetPosition, this.size, null);
        this.size = targetPosition;
        this.scaleFactor = this.size != 0 ? (this.keys[this.size - 1] - this.keys[0]) / (long)this.size : 0L;
    }
}

