/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.awt.print.Paper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PlaintextDataChunk;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.EncodingUtilities;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;

public class TextFilePrinterDriver
implements PrinterDriver {
    private OutputStream out;
    private char[] endOfLine;
    private char[] endOfPage;
    private float charsPerInch;
    private float linesPerInch;
    private EncodingUtilities encodingUtilities;
    private String defaultEncoding;
    private boolean firstPage;
    private int borderLeft;

    public TextFilePrinterDriver(OutputStream out, float charsPerInch, float linesPerInch) {
        this(out, charsPerInch, linesPerInch, false);
    }

    public TextFilePrinterDriver(OutputStream out, float charsPerInch, float linesPerInch, boolean unixEndOfLine) {
        this.out = out;
        this.charsPerInch = charsPerInch;
        this.linesPerInch = linesPerInch;
        if (!unixEndOfLine) {
            this.endOfLine = new char[]{'\r', '\n'};
            this.endOfPage = new char[]{'\r', '\n', '\f'};
        } else {
            this.endOfLine = new char[]{'\n'};
            this.endOfPage = new char[]{'\n', '\f'};
        }
        this.firstPage = true;
    }

    @Override
    public void endLine(boolean overflow) throws IOException {
        this.getEncodingUtilities(this.defaultEncoding).writeEncodedText(this.endOfLine, this.out);
    }

    @Override
    public void endPage(boolean overflow) throws IOException {
        this.getEncodingUtilities(this.defaultEncoding).writeEncodedText(this.endOfPage, this.out);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public float getCharactersPerInch() {
        return this.charsPerInch;
    }

    @Override
    public float getLinesPerInch() {
        return this.linesPerInch;
    }

    @Override
    public void printChunk(PlaintextDataChunk chunk) throws IOException {
        String text = chunk.getText().substring(0, chunk.getWidth());
        this.getEncodingUtilities(this.defaultEncoding).writeEncodedText(text, this.out);
    }

    @Override
    public void printEmptyChunk(int count) throws IOException {
        EncodingUtilities encodingUtilities = this.getEncodingUtilities(this.defaultEncoding);
        for (int i = 0; i < count; ++i) {
            this.out.write(encodingUtilities.getSpace());
        }
    }

    @Override
    public void printRaw(byte[] raw) throws IOException {
        this.out.write(raw);
    }

    @Override
    public void startLine() throws IOException {
        this.printEmptyChunk(this.borderLeft);
    }

    @Override
    public void startPage(Paper paper, String encoding) throws IOException {
        this.defaultEncoding = encoding;
        if (this.firstPage) {
            EncodingUtilities encodingUtilities = this.getEncodingUtilities(encoding);
            this.out.write(encodingUtilities.getEncodingHeader());
            this.firstPage = false;
        }
        PageFormatFactory fact = PageFormatFactory.getInstance();
        float charWidthPoints = 72.0f / this.getCharactersPerInch();
        this.borderLeft = (int)(fact.getLeftBorder(paper) / (double)charWidthPoints);
        float lineHeightPoints = 72.0f / this.getLinesPerInch();
        int borderTop = (int)(fact.getTopBorder(paper) / (double)lineHeightPoints);
        for (int i = 0; i < borderTop; ++i) {
            this.startLine();
            this.endLine(false);
        }
    }

    protected EncodingUtilities getEncodingUtilities(String encoding) throws UnsupportedEncodingException {
        if (this.encodingUtilities != null && this.encodingUtilities.getEncoding().equals(encoding)) {
            return this.encodingUtilities;
        }
        this.encodingUtilities = new EncodingUtilities(encoding);
        return this.encodingUtilities;
    }

    public char[] getEndOfLine() {
        return this.endOfLine;
    }

    public void setEndOfLine(char[] endOfLine) {
        if (endOfLine == null) {
            throw new NullPointerException();
        }
        this.endOfLine = (char[])endOfLine.clone();
    }

    public char[] getEndOfPage() {
        return this.endOfPage;
    }

    public void setEndOfPage(char[] endOfPage) {
        if (endOfPage == null) {
            throw new NullPointerException();
        }
        this.endOfPage = (char[])endOfPage.clone();
    }
}

